/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.ClusterSchema;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class RSGroupUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RSGroupUtil.class);
    public static final String RS_GROUP_ENABLED = "hbase.balancer.rsgroup.enabled";

    private RSGroupUtil() {
    }

    public static boolean isRSGroupEnabled(Configuration conf) {
        return conf.getBoolean(RS_GROUP_ENABLED, false);
    }

    public static void enableRSGroup(Configuration conf) {
        conf.setBoolean(RS_GROUP_ENABLED, true);
    }

    public static List<TableName> listTablesInRSGroup(MasterServices master, String groupName) throws IOException {
        ArrayList<TableName> tables = new ArrayList<TableName>();
        boolean isDefaultGroup = "default".equals(groupName);
        for (TableDescriptor td : master.getTableDescriptors().getAll().values()) {
            if (!RSGroupUtil.getRSGroupInfo(master, master.getRSGroupInfoManager(), td.getTableName()).map(g2 -> g2.getName().equals(groupName)).orElse(isDefaultGroup).booleanValue()) continue;
            tables.add(td.getTableName());
        }
        return tables;
    }

    public static Optional<RSGroupInfo> getRSGroupInfo(MasterServices master, RSGroupInfoManager manager, TableName tableName) throws IOException {
        RSGroupInfo group;
        TableDescriptor td = master.getTableDescriptors().get(tableName);
        if (td == null) {
            return Optional.empty();
        }
        Optional<String> optGroupNameOfTable = td.getRegionServerGroup();
        if (optGroupNameOfTable.isPresent() && (group = manager.getRSGroup(optGroupNameOfTable.get())) != null) {
            return Optional.of(group);
        }
        RSGroupInfo groupFromOldRSGroupInfo = manager.getRSGroupForTable(tableName);
        if (groupFromOldRSGroupInfo != null) {
            return Optional.of(groupFromOldRSGroupInfo);
        }
        String groupDeterminedByAdmin = manager.determineRSGroupInfoForTable(tableName);
        RSGroupInfo groupInfo = null;
        if (groupDeterminedByAdmin != null) {
            groupInfo = manager.getRSGroup(groupDeterminedByAdmin);
        }
        if (groupInfo != null) {
            return Optional.of(groupInfo);
        }
        ClusterSchema clusterSchema = master.getClusterSchema();
        if (clusterSchema == null) {
            if (TableName.isMetaTableName(tableName)) {
                LOG.info("Can not get the namespace rs group config for meta table, since the meta table is not online yet, will use default group to assign meta first");
            } else {
                LOG.warn("ClusterSchema is null, can only use default rsgroup, should not happen?");
            }
            return Optional.empty();
        }
        NamespaceDescriptor nd = clusterSchema.getNamespace(tableName.getNamespaceAsString());
        String groupNameOfNs = nd.getConfigurationValue("hbase.rsgroup.name");
        if (groupNameOfNs == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(manager.getRSGroup(groupNameOfNs));
    }

    public static RSGroupInfo fillTables(RSGroupInfo rsGroupInfo, Collection<TableDescriptor> tds) {
        RSGroupInfo newRsGroupInfo = new RSGroupInfo(rsGroupInfo);
        Predicate<TableDescriptor> filter = rsGroupInfo.getName().equals("default") ? td -> {
            Optional<String> optGroupName = td.getRegionServerGroup();
            return !optGroupName.isPresent() || optGroupName.get().equals("default");
        } : td -> {
            Optional<String> optGroupName = td.getRegionServerGroup();
            return optGroupName.isPresent() && optGroupName.get().equals(newRsGroupInfo.getName());
        };
        tds.stream().filter(filter).map(TableDescriptor::getTableName).forEach(newRsGroupInfo::addTable);
        return newRsGroupInfo;
    }
}

