/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.util.compaction.MajorCompactorTTL;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hbase.thirdparty.org.apache.commons.cli.DefaultParser;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Option;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Options;
import org.apache.hbase.thirdparty.org.apache.commons.cli.ParseException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class RSGroupMajorCompactionTTL
extends MajorCompactorTTL {
    private static final Logger LOG = LoggerFactory.getLogger(RSGroupMajorCompactionTTL.class);

    @InterfaceAudience.Private
    RSGroupMajorCompactionTTL() {
    }

    public int compactTTLRegionsOnGroup(Configuration conf, String rsgroup, int concurrency, long sleep, int numServers, int numRegions, boolean dryRun, boolean skipWait) throws Exception {
        try (Connection conn = ConnectionFactory.createConnection(conf);
             Admin admin = conn.getAdmin();){
            if (admin.getRSGroup(rsgroup) == null) {
                LOG.error("Invalid rsgroup specified: " + rsgroup);
                throw new IllegalArgumentException("Invalid rsgroup specified: " + rsgroup);
            }
            Iterator<TableName> iterator = admin.listTablesInRSGroup(rsgroup).iterator();
            while (true) {
                if (iterator.hasNext()) {
                    TableName tableName = iterator.next();
                    int status = this.compactRegionsTTLOnTable(conf, tableName.getNameAsString(), concurrency, sleep, numServers, numRegions, dryRun, skipWait);
                    if (status == 0) continue;
                    LOG.error("Failed to compact table: " + tableName);
                    int n = status;
                    return n;
                    continue;
                }
                break;
            }
        }
        return 0;
    }

    protected Options getOptions() {
        Options options = this.getCommonOptions();
        options.addOption(Option.builder("rsgroup").required().desc("Tables of rsgroup to be compacted").hasArg().build());
        return options;
    }

    @Override
    public int run(String[] args) throws Exception {
        CommandLine commandLine;
        Options options = this.getOptions();
        DefaultParser cmdLineParser = new DefaultParser();
        try {
            commandLine = cmdLineParser.parse(options, args);
        }
        catch (ParseException parseException) {
            System.out.println("ERROR: Unable to parse command-line arguments " + Arrays.toString(args) + " due to: " + parseException);
            RSGroupMajorCompactionTTL.printUsage(options);
            return -1;
        }
        if (commandLine == null) {
            System.out.println("ERROR: Failed parse, empty commandLine; " + Arrays.toString(args));
            RSGroupMajorCompactionTTL.printUsage(options);
            return -1;
        }
        String rsgroup = commandLine.getOptionValue("rsgroup");
        int numServers = Integer.parseInt(commandLine.getOptionValue("numservers", "-1"));
        int numRegions = Integer.parseInt(commandLine.getOptionValue("numregions", "-1"));
        int concurrency = Integer.parseInt(commandLine.getOptionValue("servers", "1"));
        long sleep = Long.parseLong(commandLine.getOptionValue("sleep", Long.toString(30000L)));
        boolean dryRun = commandLine.hasOption("dryRun");
        boolean skipWait = commandLine.hasOption("skipWait");
        Configuration conf = this.getConf();
        return this.compactTTLRegionsOnGroup(conf, rsgroup, concurrency, sleep, numServers, numRegions, dryRun, skipWait);
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new RSGroupMajorCompactionTTL(), (String[])args);
    }
}

