/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BalanceRequest;
import org.apache.hadoop.hbase.client.BalanceResponse;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.DisabledRSGroupInfoManager;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManagerImpl;
import org.apache.hadoop.hbase.rsgroup.RSGroupUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public interface RSGroupInfoManager {
    public void start();

    public void addRSGroup(RSGroupInfo var1) throws IOException;

    public void removeRSGroup(String var1) throws IOException;

    public void moveServers(Set<Address> var1, String var2) throws IOException;

    public RSGroupInfo getRSGroupOfServer(Address var1) throws IOException;

    public RSGroupInfo getRSGroup(String var1) throws IOException;

    public List<RSGroupInfo> listRSGroups() throws IOException;

    public boolean isOnline();

    public void removeServers(Set<Address> var1) throws IOException;

    public RSGroupInfo getRSGroupForTable(TableName var1) throws IOException;

    public static RSGroupInfoManager create(MasterServices master) throws IOException {
        if (RSGroupUtil.isRSGroupEnabled(master.getConfiguration())) {
            return RSGroupInfoManagerImpl.getInstance(master);
        }
        return new DisabledRSGroupInfoManager(master.getServerManager());
    }

    public BalanceResponse balanceRSGroup(String var1, BalanceRequest var2) throws IOException;

    public void setRSGroup(Set<TableName> var1, String var2) throws IOException;

    public String determineRSGroupInfoForTable(TableName var1);

    public void renameRSGroup(String var1, String var2) throws IOException;

    public void updateRSGroupConfig(String var1, Map<String, String> var2) throws IOException;
}

