/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ModifyTableDescriptorProcedure;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MigrateRSGroupProcedure
extends ModifyTableDescriptorProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(MigrateRSGroupProcedure.class);

    public MigrateRSGroupProcedure() {
    }

    public MigrateRSGroupProcedure(MasterProcedureEnv env, TableName tableName) {
        super(env, tableName);
    }

    @Override
    protected Optional<TableDescriptor> modify(MasterProcedureEnv env, TableDescriptor current) throws IOException {
        if (current.getRegionServerGroup().isPresent()) {
            LOG.debug("Skip migrating {} since it is already in group {}", (Object)current.getTableName(), (Object)current.getRegionServerGroup().get());
            return Optional.empty();
        }
        RSGroupInfo group = env.getMasterServices().getRSGroupInfoManager().getRSGroupForTable(current.getTableName());
        if (group == null) {
            LOG.debug("RSGroup for table {} is empty when migrating, usually this should not happen unless we have removed the RSGroup, ignore...", (Object)current.getTableName());
            return Optional.empty();
        }
        return Optional.of(TableDescriptorBuilder.newBuilder(current).setRegionServerGroup(group.getName()).build());
    }
}

