/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.OptionalLong;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationGroupOffset;
import org.apache.hadoop.hbase.replication.ReplicationOffsetUtil;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerImpl;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueueData;
import org.apache.hadoop.hbase.replication.ReplicationQueueId;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationUtils;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationGlobalSourceSource;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationRuntimeException;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceFactory;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.replication.regionserver.SyncReplicationPeerMappingManager;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryBatch;
import org.apache.hadoop.hbase.replication.regionserver.WALFileLengthProvider;
import org.apache.hadoop.hbase.shaded.com.google.errorprone.annotations.RestrictedApi;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.AbstractWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ReplicationSourceManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationSourceManager.class);
    private final ConcurrentMap<String, ReplicationSourceInterface> sources;
    private final List<ReplicationSourceInterface> oldsources;
    private final ReplicationQueueStorage queueStorage;
    private final ReplicationPeers replicationPeers;
    private final UUID clusterId;
    private final Server server;
    private final ConcurrentMap<ReplicationQueueId, Map<String, NavigableSet<String>>> walsById;
    private final ConcurrentMap<ReplicationQueueId, Map<String, NavigableSet<Path>>> walsByIdRecoveredQueues;
    private final SyncReplicationPeerMappingManager syncReplicationPeerMappingManager;
    private final Configuration conf;
    private final FileSystem fs;
    private final Map<String, Path> latestPaths;
    private final Path logDir;
    private final Path oldLogDir;
    private final WALFactory walFactory;
    private final long sleepBeforeFailover;
    private final ThreadPoolExecutor executor;
    private AtomicLong totalBufferUsed = new AtomicLong();
    private final long sleepForRetries;
    private final int maxRetriesMultiplier;
    private final long totalBufferLimit;
    private final MetricsReplicationGlobalSourceSource globalMetrics;

    public ReplicationSourceManager(ReplicationQueueStorage queueStorage, ReplicationPeers replicationPeers, Configuration conf, Server server, FileSystem fs, Path logDir, Path oldLogDir, UUID clusterId, WALFactory walFactory, SyncReplicationPeerMappingManager syncReplicationPeerMappingManager, MetricsReplicationGlobalSourceSource globalMetrics) throws IOException {
        this.sources = new ConcurrentHashMap<String, ReplicationSourceInterface>();
        this.queueStorage = queueStorage;
        this.replicationPeers = replicationPeers;
        this.server = server;
        this.walsById = new ConcurrentHashMap<ReplicationQueueId, Map<String, NavigableSet<String>>>();
        this.walsByIdRecoveredQueues = new ConcurrentHashMap<ReplicationQueueId, Map<String, NavigableSet<Path>>>();
        this.oldsources = new ArrayList<ReplicationSourceInterface>();
        this.conf = conf;
        this.fs = fs;
        this.logDir = logDir;
        this.oldLogDir = oldLogDir;
        this.sleepBeforeFailover = conf.getLong("replication.sleep.before.failover", 30000L);
        this.clusterId = clusterId;
        this.walFactory = walFactory;
        this.syncReplicationPeerMappingManager = syncReplicationPeerMappingManager;
        int nbWorkers = conf.getInt("replication.executor.workers", 1);
        this.executor = new ThreadPoolExecutor(nbWorkers, nbWorkers, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder();
        tfb.setNameFormat("ReplicationExecutor-%d");
        tfb.setDaemon(true);
        this.executor.setThreadFactory(tfb.build());
        this.latestPaths = new HashMap<String, Path>();
        this.sleepForRetries = this.conf.getLong("replication.source.sync.sleepforretries", 1000L);
        this.maxRetriesMultiplier = this.conf.getInt("replication.source.sync.maxretriesmultiplier", 60);
        this.totalBufferLimit = conf.getLong("replication.total.buffer.quota", 0x10000000L);
        this.globalMetrics = globalMetrics;
    }

    void init() throws IOException {
        for (String id : this.replicationPeers.getAllPeerIds()) {
            this.addSource(id, true);
        }
    }

    public void addPeer(String peerId) throws IOException {
        boolean added = false;
        try {
            added = this.replicationPeers.addPeer(peerId);
        }
        catch (ReplicationException e) {
            throw new IOException(e);
        }
        if (added) {
            this.addSource(peerId, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeer(String peerId) {
        ReplicationPeerConfig peerConfig;
        ReplicationPeerImpl peer = this.replicationPeers.removePeer(peerId);
        String terminateMessage = "Replication stream was removed by a user";
        ArrayList<ReplicationSourceInterface> oldSourcesToDelete = new ArrayList<ReplicationSourceInterface>();
        List<ReplicationSourceInterface> list = this.oldsources;
        synchronized (list) {
            for (ReplicationSourceInterface src : this.oldsources) {
                if (!peerId.equals(src.getPeerId())) continue;
                oldSourcesToDelete.add(src);
            }
            for (ReplicationSourceInterface src : oldSourcesToDelete) {
                src.terminate(terminateMessage);
                this.removeRecoveredSource(src);
            }
        }
        LOG.info("Number of deleted recovered sources for {}: {}", (Object)peerId, (Object)oldSourcesToDelete.size());
        ReplicationSourceInterface srcToRemove = (ReplicationSourceInterface)this.sources.get(peerId);
        if (srcToRemove != null) {
            srcToRemove.terminate(terminateMessage);
            this.removeSource(srcToRemove);
        }
        if ((peerConfig = peer.getPeerConfig()).isSyncReplication()) {
            this.syncReplicationPeerMappingManager.remove(peerId, peerConfig);
        }
    }

    private ReplicationSourceInterface createSource(ReplicationQueueData queueData, ReplicationPeer replicationPeer) throws IOException {
        ReplicationSourceInterface src = ReplicationSourceFactory.create(this.conf, queueData.getId());
        WALFileLengthProvider walFileLengthProvider = this.walFactory.getWALProvider() != null ? this.walFactory.getWALProvider().getWALFileLengthProvider() : p -> OptionalLong.empty();
        src.init(this.conf, this.fs, this, this.queueStorage, replicationPeer, this.server, queueData, this.clusterId, walFileLengthProvider, new MetricsSource(queueData.getId().toString()));
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSource(String peerId, boolean init) throws IOException {
        ReplicationPeerImpl peer = this.replicationPeers.getPeer(peerId);
        if ("org.apache.hadoop.hbase.replication.regionserver.RegionReplicaReplicationEndpoint".equals(peer.getPeerConfig().getReplicationEndpointImpl())) {
            LOG.info("Legacy region replication peer found, skip adding: {}", (Object)peer.getPeerConfig());
            return;
        }
        ReplicationQueueId queueId = new ReplicationQueueId(this.server.getServerName(), peerId);
        ReplicationSourceInterface src = this.createSource(new ReplicationQueueData(queueId, ImmutableMap.of()), peer);
        Map<String, Path> map = this.latestPaths;
        synchronized (map) {
            this.sources.put(peerId, src);
            HashMap walsByGroup = new HashMap();
            this.walsById.put(queueId, walsByGroup);
            if (!this.latestPaths.isEmpty()) {
                for (Map.Entry<String, Path> walPrefixAndPath : this.latestPaths.entrySet()) {
                    Path walPath = walPrefixAndPath.getValue();
                    TreeSet<String> wals = new TreeSet<String>();
                    wals.add(walPath.getName());
                    walsByGroup.put(walPrefixAndPath.getKey(), wals);
                    if (!init) {
                        this.abortAndThrowIOExceptionWhenFail(() -> this.queueStorage.setOffset(queueId, (String)walPrefixAndPath.getKey(), new ReplicationGroupOffset(walPath.getName(), 0L), Collections.emptyMap()));
                    }
                    src.enqueueLog(walPath);
                    LOG.trace("Enqueued {} to source {} during source creation.", (Object)walPath, (Object)src.getQueueId());
                }
            }
        }
        ReplicationPeerConfig peerConfig = peer.getPeerConfig();
        if (peerConfig.isSyncReplication()) {
            this.syncReplicationPeerMappingManager.add(peer.getId(), peerConfig);
        }
        src.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drainSources(String peerId) throws IOException, ReplicationException {
        ReplicationQueueData queueData;
        String terminateMessage = "Sync replication peer " + peerId + " is transiting to STANDBY. Will close the previous replication source and open a new one";
        ReplicationPeerImpl peer = this.replicationPeers.getPeer(peerId);
        assert (peer.getPeerConfig().isSyncReplication());
        ReplicationQueueId queueId = new ReplicationQueueId(this.server.getServerName(), peerId);
        ReplicationSourceInterface src = this.createSource(new ReplicationQueueData(queueId, ImmutableMap.of()), peer);
        Object object = this.latestPaths;
        synchronized (object) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ConcurrentMap<ReplicationQueueId, Map<String, NavigableSet<String>>> concurrentMap = this.walsById;
            synchronized (concurrentMap) {
                ((Map)this.walsById.get(queueId)).forEach((group, wals) -> {
                    if (!wals.isEmpty()) {
                        builder.put(group, new ReplicationGroupOffset((String)wals.last(), -1L));
                    }
                });
            }
            queueData = new ReplicationQueueData(queueId, builder.build());
            src = this.createSource(queueData, peer);
            ReplicationSourceInterface toRemove = this.sources.put(peerId, src);
            if (toRemove != null) {
                LOG.info("Terminate replication source for " + toRemove.getPeerId());
                toRemove.terminate(terminateMessage);
                toRemove.getSourceMetrics().clear();
            }
        }
        for (Map.Entry entry : queueData.getOffsets().entrySet()) {
            this.queueStorage.setOffset(queueId, (String)entry.getKey(), (ReplicationGroupOffset)entry.getValue(), Collections.emptyMap());
        }
        LOG.info("Startup replication source for " + src.getPeerId());
        src.startup();
        object = this.walsById;
        synchronized (object) {
            Map wals2 = (Map)this.walsById.get(queueId);
            queueData.getOffsets().forEach((group, offset) -> {
                NavigableSet walsByGroup = (NavigableSet)wals2.get(group);
                if (walsByGroup != null) {
                    walsByGroup.headSet(offset.getWal(), true).clear();
                }
            });
        }
        object = this.oldsources;
        synchronized (object) {
            Iterator<ReplicationSourceInterface> iter = this.oldsources.iterator();
            while (iter.hasNext()) {
                ReplicationSourceInterface oldSource = iter.next();
                if (!oldSource.getPeerId().equals(peerId)) continue;
                ReplicationQueueId oldSourceQueueId = oldSource.getQueueId();
                oldSource.terminate(terminateMessage);
                oldSource.getSourceMetrics().clear();
                this.queueStorage.removeQueue(oldSourceQueueId);
                this.walsByIdRecoveredQueues.remove(oldSourceQueueId);
                iter.remove();
            }
        }
    }

    private ReplicationSourceInterface createRefreshedSource(ReplicationQueueId queueId, ReplicationPeer peer) throws IOException, ReplicationException {
        Map<String, ReplicationGroupOffset> offsets = this.queueStorage.getOffsets(queueId);
        return this.createSource(new ReplicationQueueData(queueId, ImmutableMap.copyOf(offsets)), peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshSources(String peerId) throws ReplicationException, IOException {
        ReplicationSourceInterface src;
        String terminateMessage = "Peer " + peerId + " state or config changed. Will close the previous replication source and open a new one";
        ReplicationPeerImpl peer = this.replicationPeers.getPeer(peerId);
        ReplicationQueueId queueId = new ReplicationQueueId(this.server.getServerName(), peerId);
        Map<String, Path> map = this.latestPaths;
        synchronized (map) {
            ReplicationSourceInterface toRemove = (ReplicationSourceInterface)this.sources.remove(peerId);
            if (toRemove != null) {
                LOG.info("Terminate replication source for " + toRemove.getPeerId());
                toRemove.terminate(terminateMessage, null, false);
            }
            src = this.createRefreshedSource(queueId, peer);
            this.sources.put(peerId, src);
            for (NavigableSet walsByGroup : ((Map)this.walsById.get(queueId)).values()) {
                walsByGroup.forEach(wal -> src.enqueueLog(new Path(this.logDir, wal)));
            }
        }
        LOG.info("Startup replication source for " + src.getPeerId());
        src.startup();
        ArrayList<ReplicationSourceInterface> toStartup = new ArrayList<ReplicationSourceInterface>();
        List<ReplicationSourceInterface> list = this.oldsources;
        synchronized (list) {
            ArrayList<ReplicationQueueId> oldSourceQueueIds = new ArrayList<ReplicationQueueId>();
            Iterator<ReplicationSourceInterface> iter = this.oldsources.iterator();
            while (iter.hasNext()) {
                ReplicationSourceInterface oldSource = iter.next();
                if (!oldSource.getPeerId().equals(peerId)) continue;
                oldSourceQueueIds.add(oldSource.getQueueId());
                oldSource.terminate(terminateMessage);
                iter.remove();
            }
            for (ReplicationQueueId oldSourceQueueId : oldSourceQueueIds) {
                ReplicationSourceInterface recoveredReplicationSource = this.createRefreshedSource(oldSourceQueueId, peer);
                this.oldsources.add(recoveredReplicationSource);
                for (NavigableSet walsByGroup : ((Map)this.walsByIdRecoveredQueues.get(oldSourceQueueId)).values()) {
                    walsByGroup.forEach(wal -> recoveredReplicationSource.enqueueLog((Path)wal));
                }
                toStartup.add(recoveredReplicationSource);
            }
        }
        for (ReplicationSourceInterface replicationSource : toStartup) {
            replicationSource.startup();
        }
    }

    private boolean removeRecoveredSource(ReplicationSourceInterface src) {
        if (!this.oldsources.remove(src)) {
            return false;
        }
        LOG.info("Done with the recovered queue {}", (Object)src.getQueueId());
        this.deleteQueue(src.getQueueId());
        this.walsByIdRecoveredQueues.remove(src.getQueueId());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishRecoveredSource(ReplicationSourceInterface src) {
        List<ReplicationSourceInterface> list = this.oldsources;
        synchronized (list) {
            if (!this.removeRecoveredSource(src)) {
                return;
            }
        }
        LOG.info("Finished recovering queue {} with the following stats: {}", (Object)src.getQueueId(), (Object)src.getStats());
    }

    void removeSource(ReplicationSourceInterface src) {
        LOG.info("Done with the queue " + src.getQueueId());
        this.sources.remove(src.getPeerId());
        this.deleteQueue(src.getQueueId());
        this.walsById.remove(src.getQueueId());
    }

    private void deleteQueue(ReplicationQueueId queueId) {
        this.abortWhenFail(() -> this.queueStorage.removeQueue(queueId));
    }

    private void interruptOrAbortWhenFail(ReplicationQueueOperation op) {
        try {
            op.exec();
        }
        catch (ReplicationException e) {
            if (e.getCause() != null && e.getCause() instanceof KeeperException.SystemErrorException && e.getCause().getCause() != null && e.getCause().getCause() instanceof InterruptedException) {
                throw new ReplicationRuntimeException("Thread is interrupted, the replication source may be terminated", e.getCause().getCause());
            }
            this.server.abort("Failed to operate on replication queue", e);
        }
    }

    private void abortWhenFail(ReplicationQueueOperation op) {
        try {
            op.exec();
        }
        catch (ReplicationException e) {
            this.server.abort("Failed to operate on replication queue", e);
        }
    }

    private void throwIOExceptionWhenFail(ReplicationQueueOperation op) throws IOException {
        try {
            op.exec();
        }
        catch (ReplicationException e) {
            throw new IOException(e);
        }
    }

    private void abortAndThrowIOExceptionWhenFail(ReplicationQueueOperation op) throws IOException {
        try {
            op.exec();
        }
        catch (ReplicationException e) {
            this.server.abort("Failed to operate on replication queue", e);
            throw new IOException(e);
        }
    }

    public void logPositionAndCleanOldLogs(ReplicationSourceInterface source, WALEntryBatch entryBatch) {
        String walName = entryBatch.getLastWalPath().getName();
        String walPrefix = AbstractFSWALProvider.getWALPrefixFromWALName(walName);
        ReplicationGroupOffset offset = new ReplicationGroupOffset(walName, entryBatch.isEndOfFile() ? -1L : entryBatch.getLastWalPosition());
        this.interruptOrAbortWhenFail(() -> this.queueStorage.setOffset(source.getQueueId(), walPrefix, offset, entryBatch.getLastSeqIds()));
        this.cleanOldLogs(walName, entryBatch.isEndOfFile(), source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanOldLogs(String log, boolean inclusive, ReplicationSourceInterface source) {
        String logPrefix = AbstractFSWALProvider.getWALPrefixFromWALName(log);
        if (source.isRecovered()) {
            NavigableSet wals = (NavigableSet)((Map)this.walsByIdRecoveredQueues.get(source.getQueueId())).get(logPrefix);
            if (wals != null) {
                NavigableSet walsToRemove = wals.headSet(new Path(this.oldLogDir, log), inclusive).stream().map(Path::getName).collect(Collectors.toCollection(TreeSet::new));
                if (walsToRemove.isEmpty()) {
                    return;
                }
                this.cleanOldLogs(walsToRemove, source);
                walsToRemove.clear();
            }
        } else {
            NavigableSet<String> walsToRemove;
            NavigableSet wals;
            ConcurrentMap<ReplicationQueueId, Map<String, NavigableSet<String>>> concurrentMap = this.walsById;
            synchronized (concurrentMap) {
                wals = (NavigableSet)((Map)this.walsById.get(source.getQueueId())).get(logPrefix);
                if (wals == null) {
                    return;
                }
                walsToRemove = wals.headSet(log, inclusive);
                if (walsToRemove.isEmpty()) {
                    return;
                }
                walsToRemove = new TreeSet<String>((SortedSet<String>)walsToRemove);
            }
            this.cleanOldLogs(walsToRemove, source);
            concurrentMap = this.walsById;
            synchronized (concurrentMap) {
                wals.removeAll(walsToRemove);
            }
        }
    }

    private void removeRemoteWALs(String peerId, String remoteWALDir, Collection<String> wals) throws IOException {
        Path remoteWALDirForPeer = ReplicationUtils.getPeerRemoteWALDir(remoteWALDir, peerId);
        FileSystem fs = ReplicationUtils.getRemoteWALFileSystem(this.conf, remoteWALDir);
        for (String wal : wals) {
            Path walFile = new Path(remoteWALDirForPeer, wal);
            try {
                if (fs.delete(walFile, false) || !fs.exists(walFile)) continue;
                throw new IOException("Can not delete " + walFile);
            }
            catch (FileNotFoundException e) {
                LOG.debug("The remote wal {} has already been deleted?", (Object)walFile, (Object)e);
            }
        }
    }

    private void cleanOldLogs(NavigableSet<String> wals, ReplicationSourceInterface source) {
        LOG.debug("Removing {} logs in the list: {}", (Object)wals.size(), wals);
        if (source.isSyncReplication()) {
            String peerId = source.getPeerId();
            String remoteWALDir = source.getPeer().getPeerConfig().getRemoteWALDir();
            List<String> remoteWals = wals.stream().filter(w -> AbstractWALProvider.getSyncReplicationPeerIdFromWALName(w).map(peerId::equals).orElse(false)).collect(Collectors.toList());
            LOG.debug("Removing {} logs from remote dir {} in the list: {}", new Object[]{remoteWals.size(), remoteWALDir, remoteWals});
            if (!remoteWals.isEmpty()) {
                int sleepMultiplier = 0;
                while (true) {
                    try {
                        this.removeRemoteWALs(peerId, remoteWALDir, remoteWals);
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to delete remote wals from remote dir {} for peer {}", (Object)remoteWALDir, (Object)peerId);
                        if (!source.isSourceActive()) {
                            return;
                        }
                        if (!ReplicationUtils.sleepForRetries("Failed to delete remote wals", this.sleepForRetries, sleepMultiplier, this.maxRetriesMultiplier)) continue;
                        ++sleepMultiplier;
                        continue;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postLogRoll(Path newLog) throws IOException {
        String logName = newLog.getName();
        String logPrefix = AbstractFSWALProvider.getWALPrefixFromWALName(logName);
        Map<String, Path> map = this.latestPaths;
        synchronized (map) {
            ConcurrentMap<ReplicationQueueId, Map<String, NavigableSet<String>>> concurrentMap = this.walsById;
            synchronized (concurrentMap) {
                for (Map.Entry entry : this.walsById.entrySet()) {
                    ReplicationQueueId queueId = (ReplicationQueueId)entry.getKey();
                    String peerId = queueId.getPeerId();
                    Map walsByPrefix = (Map)entry.getValue();
                    boolean existingPrefix = false;
                    for (Map.Entry walsEntry : walsByPrefix.entrySet()) {
                        SortedSet wals = (SortedSet)walsEntry.getValue();
                        if (this.sources.isEmpty()) {
                            wals.clear();
                        }
                        if (!logPrefix.equals(walsEntry.getKey())) continue;
                        wals.add(logName);
                        existingPrefix = true;
                    }
                    if (existingPrefix) continue;
                    LOG.debug("Start tracking logs for wal group {} for peer {}", (Object)logPrefix, (Object)peerId);
                    TreeSet<String> wals = new TreeSet<String>();
                    wals.add(logName);
                    walsByPrefix.put(logPrefix, wals);
                }
            }
            this.latestPaths.put(logPrefix, newLog);
        }
        for (ReplicationSourceInterface source : this.sources.values()) {
            source.enqueueLog(newLog);
            LOG.trace("Enqueued {} to source {} while performing postLogRoll operation.", (Object)newLog, (Object)source.getQueueId());
        }
    }

    private boolean shouldReplicate(ReplicationGroupOffset offset, String wal) {
        if (AbstractFSWALProvider.isMetaFile(wal)) {
            return false;
        }
        return ReplicationOffsetUtil.shouldReplicate(offset, wal);
    }

    void claimQueue(ReplicationQueueId queueId) {
        this.claimQueue(queueId, false);
    }

    private PriorityQueue<Path> getWALFilesToReplicate(ServerName sourceRS, boolean syncUp, Map<String, ReplicationGroupOffset> offsets) throws IOException {
        List<Path> walFiles = AbstractFSWALProvider.getArchivedWALFiles(this.conf, sourceRS, URLEncoder.encode(sourceRS.toString(), StandardCharsets.UTF_8.name()));
        if (syncUp) {
            walFiles.addAll(AbstractFSWALProvider.getWALFiles(this.conf, sourceRS));
        }
        PriorityQueue<Path> walFilesPQ = new PriorityQueue<Path>(AbstractFSWALProvider.TIMESTAMP_COMPARATOR);
        for (Path file : walFiles) {
            String walGroupId = AbstractFSWALProvider.getWALPrefixFromWALName(file.getName());
            ReplicationGroupOffset groupOffset = offsets.get(walGroupId);
            if (this.shouldReplicate(groupOffset, file.getName())) {
                walFilesPQ.add(file);
                continue;
            }
            LOG.debug("Skip enqueuing log {} because it is before the start offset {}", (Object)file.getName(), (Object)groupOffset);
        }
        return walFilesPQ;
    }

    private void addRecoveredSource(ReplicationSourceInterface src, ReplicationPeerImpl oldPeer, ReplicationQueueId claimedQueueId, PriorityQueue<Path> walFiles) {
        Pair<SyncReplicationState, SyncReplicationState> stateAndNewState;
        ReplicationPeerImpl peer = this.replicationPeers.getPeer(src.getPeerId());
        if (peer == null || peer != oldPeer) {
            src.terminate("Recovered queue doesn't belong to any current peer");
            this.deleteQueue(claimedQueueId);
            return;
        }
        if (peer.getPeerConfig().isSyncReplication() && ((stateAndNewState = peer.getSyncReplicationStateAndNewState()).getFirst().equals((Object)SyncReplicationState.STANDBY) && stateAndNewState.getSecond().equals((Object)SyncReplicationState.NONE) || stateAndNewState.getSecond().equals((Object)SyncReplicationState.STANDBY))) {
            src.terminate("Sync replication peer is in STANDBY state");
            this.deleteQueue(claimedQueueId);
            return;
        }
        HashMap<String, TreeSet<Path>> walsByGroup = new HashMap<String, TreeSet<Path>>();
        this.walsByIdRecoveredQueues.put(claimedQueueId, walsByGroup);
        for (Path wal : walFiles) {
            String walPrefix = AbstractFSWALProvider.getWALPrefixFromWALName(wal.getName());
            TreeSet<Path> wals = (TreeSet<Path>)walsByGroup.get(walPrefix);
            if (wals == null) {
                wals = new TreeSet<Path>(AbstractFSWALProvider.TIMESTAMP_COMPARATOR);
                walsByGroup.put(walPrefix, wals);
            }
            wals.add(wal);
        }
        this.oldsources.add(src);
        LOG.info("Added source for recovered queue {}, number of wals to replicate: {}", (Object)claimedQueueId, (Object)walFiles.size());
        for (Path wal : walFiles) {
            LOG.debug("Enqueueing log {} from recovered queue for source: {}", (Object)wal, (Object)claimedQueueId);
            src.enqueueLog(wal);
        }
        src.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void claimQueue(ReplicationQueueId queueId, boolean syncUp) {
        PriorityQueue<Path> walFiles;
        ReplicationSourceInterface src;
        Map<String, ReplicationGroupOffset> offsets;
        try {
            Thread.sleep(this.sleepBeforeFailover + (long)(ThreadLocalRandom.current().nextFloat() * (float)this.sleepBeforeFailover));
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting before transferring a queue.");
            Thread.currentThread().interrupt();
        }
        if (this.server.isStopped()) {
            LOG.info("Not transferring queue since we are shutting down");
            return;
        }
        String peerId = queueId.getPeerId();
        ReplicationPeerImpl oldPeer = this.replicationPeers.getPeer(peerId);
        if (oldPeer == null) {
            LOG.info("Not transferring queue since the replication peer {} for queue {} does not exist", (Object)peerId, (Object)queueId);
            return;
        }
        try {
            offsets = this.queueStorage.claimQueue(queueId, this.server.getServerName());
        }
        catch (ReplicationException e) {
            LOG.error("ReplicationException: cannot claim dead region ({})'s replication queue", (Object)queueId.getServerName(), (Object)e);
            this.server.abort("Failed to claim queue from dead regionserver.", e);
            return;
        }
        if (offsets.isEmpty()) {
            return;
        }
        ServerName sourceRS = queueId.getServerWALsBelongTo();
        ReplicationQueueId claimedQueueId = queueId.claim(this.server.getServerName());
        ReplicationPeerImpl peer = this.replicationPeers.getPeer(peerId);
        if (peer == null || peer != oldPeer) {
            LOG.warn("Skipping failover for peer {} of node {}, peer is null", (Object)peerId, (Object)sourceRS);
            this.deleteQueue(claimedQueueId);
            return;
        }
        try {
            src = this.createSource(new ReplicationQueueData(claimedQueueId, ImmutableMap.copyOf(offsets)), peer);
        }
        catch (IOException e) {
            LOG.error("Can not create replication source for peer {} and queue {}", new Object[]{peerId, claimedQueueId, e});
            this.server.abort("Failed to create replication source after claiming queue.", e);
            return;
        }
        try {
            walFiles = this.getWALFilesToReplicate(sourceRS, syncUp, offsets);
        }
        catch (IOException e) {
            LOG.error("Can not list wal files for peer {} and queue {}", new Object[]{peerId, queueId, e});
            this.server.abort("Can not list wal files after claiming queue.", e);
            return;
        }
        List<ReplicationSourceInterface> list = this.oldsources;
        synchronized (list) {
            this.addRecoveredSource(src, oldPeer, claimedQueueId, walFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        this.executor.shutdown();
        for (ReplicationSourceInterface source : this.sources.values()) {
            source.terminate("Region server is closing");
        }
        List<ReplicationSourceInterface> list = this.oldsources;
        synchronized (list) {
            for (ReplicationSourceInterface source : this.oldsources) {
                source.terminate("Region server is closing");
            }
        }
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    public Map<ReplicationQueueId, Map<String, NavigableSet<String>>> getWALs() {
        return Collections.unmodifiableMap(this.walsById);
    }

    public List<ReplicationSourceInterface> getSources() {
        return new ArrayList<ReplicationSourceInterface>(this.sources.values());
    }

    public List<ReplicationSourceInterface> getOldSources() {
        return this.oldsources;
    }

    public ReplicationSourceInterface getSource(String peerId) {
        return (ReplicationSourceInterface)this.sources.get(peerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getSizeOfLatestPath() {
        Map<String, Path> map = this.latestPaths;
        synchronized (map) {
            return this.latestPaths.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Path> getLastestPath() {
        Map<String, Path> map = this.latestPaths;
        synchronized (map) {
            return Sets.newHashSet(this.latestPaths.values());
        }
    }

    public long getTotalBufferUsed() {
        return this.totalBufferUsed.get();
    }

    public long getTotalBufferLimit() {
        return this.totalBufferLimit;
    }

    public Path getOldLogDir() {
        return this.oldLogDir;
    }

    public Path getLogDir() {
        return this.logDir;
    }

    public FileSystem getFs() {
        return this.fs;
    }

    public ReplicationPeers getReplicationPeers() {
        return this.replicationPeers;
    }

    public String getStats() {
        StringBuilder stats = new StringBuilder();
        stats.append("Global stats: ");
        stats.append("WAL Edits Buffer Used=").append(this.getTotalBufferUsed()).append("B, Limit=").append(this.getTotalBufferLimit()).append("B\n");
        for (ReplicationSourceInterface source : this.sources.values()) {
            stats.append("Normal source for cluster " + source.getPeerId() + ": ");
            stats.append(source.getStats() + "\n");
        }
        for (ReplicationSourceInterface oldSource : this.oldsources) {
            stats.append("Recovered source for cluster/machine(s) " + oldSource.getPeerId() + ": ");
            stats.append(oldSource.getStats() + "\n");
        }
        return stats.toString();
    }

    public void addHFileRefs(TableName tableName, byte[] family, List<Pair<Path, Path>> pairs) throws IOException {
        for (ReplicationSourceInterface source : this.sources.values()) {
            this.throwIOExceptionWhenFail(() -> source.addHFileRefs(tableName, family, pairs));
        }
    }

    public void cleanUpHFileRefs(String peerId, List<String> files) {
        this.interruptOrAbortWhenFail(() -> this.queueStorage.removeHFileRefs(peerId, files));
    }

    int activeFailoverTaskCount() {
        return this.executor.getActiveCount();
    }

    MetricsReplicationGlobalSourceSource getGlobalMetrics() {
        return this.globalMetrics;
    }

    ReplicationQueueStorage getQueueStorage() {
        return this.queueStorage;
    }

    boolean acquireWALEntryBufferQuota(WALEntryBatch walEntryBatch, WAL.Entry entry) {
        long entrySize = walEntryBatch.incrementUsedBufferSize(entry);
        return this.acquireBufferQuota(entrySize);
    }

    long releaseWALEntryBatchBufferQuota(WALEntryBatch walEntryBatch) {
        long usedBufferSize = walEntryBatch.getUsedBufferSize();
        if (usedBufferSize > 0L) {
            this.releaseBufferQuota(usedBufferSize);
        }
        return usedBufferSize;
    }

    boolean acquireBufferQuota(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("size should not less than 0");
        }
        long newBufferUsed = this.addTotalBufferUsed(size);
        return newBufferUsed >= this.totalBufferLimit;
    }

    void releaseBufferQuota(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("size should not less than 0");
        }
        this.addTotalBufferUsed(-size);
    }

    private long addTotalBufferUsed(long size) {
        if (size == 0L) {
            return this.totalBufferUsed.get();
        }
        long newBufferUsed = this.totalBufferUsed.addAndGet(size);
        this.globalMetrics.setWALReaderEditsBufferBytes(newBufferUsed);
        return newBufferUsed;
    }

    boolean checkBufferQuota(String peerId) {
        if (this.totalBufferUsed.get() > this.totalBufferLimit) {
            LOG.warn("peer={}, can't read more edits from WAL as buffer usage {}B exceeds limit {}B", new Object[]{peerId, this.totalBufferUsed.get(), this.totalBufferLimit});
            return false;
        }
        return true;
    }

    @FunctionalInterface
    private static interface ReplicationQueueOperation {
        public void exec() throws ReplicationException;
    }
}

