/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.conf.ConfigurationManager;
import org.apache.hadoop.hbase.conf.PropagatingConfigurationObserver;
import org.apache.hadoop.hbase.regionserver.ReplicationSourceService;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.replication.ReplicationUtils;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationGlobalSourceSource;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceFactory;
import org.apache.hadoop.hbase.replication.regionserver.PeerActionListener;
import org.apache.hadoop.hbase.replication.regionserver.PeerProcedureHandler;
import org.apache.hadoop.hbase.replication.regionserver.PeerProcedureHandlerImpl;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationLoad;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceWALActionListener;
import org.apache.hadoop.hbase.replication.regionserver.SyncReplicationPeerInfoProvider;
import org.apache.hadoop.hbase.replication.regionserver.SyncReplicationPeerInfoProviderImpl;
import org.apache.hadoop.hbase.replication.regionserver.SyncReplicationPeerMappingManager;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class Replication
implements ReplicationSourceService,
PropagatingConfigurationObserver {
    private static final Logger LOG = LoggerFactory.getLogger(Replication.class);
    private boolean isReplicationForBulkLoadDataEnabled;
    private ReplicationSourceManager replicationManager;
    private ReplicationQueueStorage queueStorage;
    private ReplicationPeers replicationPeers;
    private volatile Configuration conf;
    private SyncReplicationPeerInfoProvider syncReplicationPeerInfoProvider;
    private Server server;
    private int statsPeriodInSecond;
    private ReplicationLoad replicationLoad;
    private MetricsReplicationGlobalSourceSource globalMetricsSource;
    private PeerProcedureHandler peerProcedureHandler;

    @Override
    public void initialize(Server server, FileSystem fs, Path logDir, Path oldLogDir, WALFactory walFactory) throws IOException {
        WALProvider walProvider;
        this.server = server;
        this.conf = this.server.getConfiguration();
        this.isReplicationForBulkLoadDataEnabled = ReplicationUtils.isReplicationForBulkLoadDataEnabled(this.conf);
        if (this.isReplicationForBulkLoadDataEnabled && (this.conf.get("hbase.replication.cluster.id") == null || this.conf.get("hbase.replication.cluster.id").isEmpty())) {
            throw new IllegalArgumentException("hbase.replication.cluster.id cannot be null/empty when hbase.replication.bulkload.enabled is set to true.");
        }
        try {
            this.queueStorage = ReplicationStorageFactory.getReplicationQueueStorage(server.getConnection(), this.conf);
            this.replicationPeers = ReplicationFactory.getReplicationPeers(server.getFileSystem(), server.getZooKeeper(), this.conf);
            this.replicationPeers.init();
        }
        catch (Exception e) {
            throw new IOException("Failed replication handler create", e);
        }
        UUID clusterId = null;
        try {
            clusterId = ZKClusterId.getUUIDForCluster(this.server.getZooKeeper());
        }
        catch (KeeperException ke) {
            throw new IOException("Could not read cluster id", ke);
        }
        SyncReplicationPeerMappingManager mapping = new SyncReplicationPeerMappingManager();
        this.globalMetricsSource = CompatibilitySingletonFactory.getInstance(MetricsReplicationSourceFactory.class).getGlobalSource();
        this.replicationManager = new ReplicationSourceManager(this.queueStorage, this.replicationPeers, this.conf, this.server, fs, logDir, oldLogDir, clusterId, walFactory, mapping, this.globalMetricsSource);
        this.statsPeriodInSecond = this.conf.getInt("replication.stats.thread.period.seconds", 300);
        this.replicationLoad = new ReplicationLoad();
        this.syncReplicationPeerInfoProvider = new SyncReplicationPeerInfoProviderImpl(this.replicationPeers, mapping);
        WALProvider wALProvider = walProvider = walFactory != null ? walFactory.getWALProvider() : null;
        if (walProvider != null) {
            walProvider.addWALActionsListener(new ReplicationSourceWALActionListener(this.conf, this.replicationManager));
            PeerActionListener peerActionListener = walProvider.getPeerActionListener();
            walProvider.setSyncReplicationPeerInfoProvider(this.syncReplicationPeerInfoProvider);
            this.replicationPeers.getAllPeerIds().stream().map(this.replicationPeers::getPeer).filter(p -> p.getPeerConfig().isSyncReplication()).filter(p -> p.getNewSyncReplicationState() != SyncReplicationState.NONE).forEach(p -> peerActionListener.peerSyncReplicationStateChange(p.getId(), p.getSyncReplicationState(), p.getNewSyncReplicationState(), 0));
            this.peerProcedureHandler = new PeerProcedureHandlerImpl(this.replicationManager, peerActionListener);
        } else {
            this.peerProcedureHandler = new PeerProcedureHandlerImpl(this.replicationManager, PeerActionListener.DUMMY);
        }
    }

    @Override
    public PeerProcedureHandler getPeerProcedureHandler() {
        return this.peerProcedureHandler;
    }

    @Override
    public void stopReplicationService() {
        this.replicationManager.join();
    }

    @Override
    public void startReplicationService() throws IOException {
        this.replicationManager.init();
        this.server.getChoreService().scheduleChore(new ReplicationStatisticsChore("ReplicationSourceStatistics", this.server, (int)TimeUnit.SECONDS.toMillis(this.statsPeriodInSecond)));
        LOG.info("{} started", (Object)this.server.toString());
    }

    @Override
    public ReplicationSourceManager getReplicationManager() {
        return this.replicationManager;
    }

    void addHFileRefsToQueue(TableName tableName, byte[] family, List<Pair<Path, Path>> pairs) throws IOException {
        try {
            this.replicationManager.addHFileRefs(tableName, family, pairs);
        }
        catch (IOException e) {
            LOG.error("Failed to add hfile references in the replication queue.", (Throwable)e);
            throw e;
        }
    }

    @Override
    public ReplicationLoad refreshAndGetReplicationLoad() {
        if (this.replicationLoad == null) {
            return null;
        }
        ArrayList<ReplicationSourceInterface> allSources = new ArrayList<ReplicationSourceInterface>();
        allSources.addAll(this.replicationManager.getSources());
        allSources.addAll(this.replicationManager.getOldSources());
        this.replicationLoad.buildReplicationLoad(allSources, null);
        return this.replicationLoad;
    }

    @Override
    public SyncReplicationPeerInfoProvider getSyncReplicationPeerInfoProvider() {
        return this.syncReplicationPeerInfoProvider;
    }

    @Override
    public ReplicationPeers getReplicationPeers() {
        return this.replicationPeers;
    }

    @Override
    public void onConfigurationChange(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public void registerChildren(ConfigurationManager manager) {
        manager.registerObserver(this.replicationPeers);
    }

    @Override
    public void deregisterChildren(ConfigurationManager manager) {
        manager.deregisterObserver(this.replicationPeers);
    }

    private final class ReplicationStatisticsChore
    extends ScheduledChore {
        ReplicationStatisticsChore(String name, Stoppable stopper, int period) {
            super(name, stopper, period);
        }

        @Override
        protected void chore() {
            this.printStats(Replication.this.replicationManager.getStats());
        }

        private void printStats(String stats) {
            if (!stats.isEmpty()) {
                LOG.info(stats);
            }
        }
    }
}

