/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncClusterConnection;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.token.FsDelegationToken;
import org.apache.hadoop.hbase.tool.BulkLoadHFiles;
import org.apache.hadoop.hbase.tool.BulkLoadHFilesTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HFileReplicator
implements Closeable {
    public static final String REPLICATION_BULKLOAD_COPY_MAXTHREADS_KEY = "hbase.replication.bulkload.copy.maxthreads";
    public static final int REPLICATION_BULKLOAD_COPY_MAXTHREADS_DEFAULT = 10;
    public static final String REPLICATION_BULKLOAD_COPY_HFILES_PERTHREAD_KEY = "hbase.replication.bulkload.copy.hfiles.perthread";
    public static final int REPLICATION_BULKLOAD_COPY_HFILES_PERTHREAD_DEFAULT = 10;
    private static final Logger LOG = LoggerFactory.getLogger(HFileReplicator.class);
    private static final String UNDERSCORE = "_";
    private static final FsPermission PERM_ALL_ACCESS = FsPermission.valueOf((String)"-rwxrwxrwx");
    private Configuration sourceClusterConf;
    private String sourceBaseNamespaceDirPath;
    private String sourceHFileArchiveDirPath;
    private Map<String, List<Pair<byte[], List<String>>>> bulkLoadHFileMap;
    private FileSystem sinkFs;
    private FsDelegationToken fsDelegationToken;
    private UserProvider userProvider;
    private Configuration conf;
    private AsyncClusterConnection connection;
    private Path hbaseStagingDir;
    private ThreadPoolExecutor exec;
    private int maxCopyThreads;
    private int copiesPerThread;
    private List<String> sourceClusterIds;

    public HFileReplicator(Configuration sourceClusterConf, String sourceBaseNamespaceDirPath, String sourceHFileArchiveDirPath, Map<String, List<Pair<byte[], List<String>>>> tableQueueMap, Configuration conf, AsyncClusterConnection connection, List<String> sourceClusterIds) throws IOException {
        this.sourceClusterConf = sourceClusterConf;
        this.sourceBaseNamespaceDirPath = sourceBaseNamespaceDirPath;
        this.sourceHFileArchiveDirPath = sourceHFileArchiveDirPath;
        this.bulkLoadHFileMap = tableQueueMap;
        this.conf = conf;
        this.connection = connection;
        this.sourceClusterIds = sourceClusterIds;
        this.userProvider = UserProvider.instantiate(conf);
        this.fsDelegationToken = new FsDelegationToken(this.userProvider, "renewer");
        this.hbaseStagingDir = new Path(CommonFSUtils.getRootDir(conf), "staging");
        this.maxCopyThreads = this.conf.getInt(REPLICATION_BULKLOAD_COPY_MAXTHREADS_KEY, 10);
        this.exec = Threads.getBoundedCachedThreadPool(this.maxCopyThreads, 60L, TimeUnit.SECONDS, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("HFileReplicationCopier-%1$d-" + this.sourceBaseNamespaceDirPath).build());
        this.copiesPerThread = conf.getInt(REPLICATION_BULKLOAD_COPY_HFILES_PERTHREAD_KEY, 10);
        this.sinkFs = FileSystem.get((Configuration)conf);
    }

    @Override
    public void close() throws IOException {
        if (this.exec != null) {
            this.exec.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void replicate() throws IOException {
        Map<String, Path> tableStagingDirsMap = this.copyHFilesToStagingDir();
        int maxRetries = this.conf.getInt("hbase.bulkload.retries.number", 10);
        for (Map.Entry<String, Path> tableStagingDir : tableStagingDirsMap.entrySet()) {
            String tableNameString = tableStagingDir.getKey();
            Path stagingDir = tableStagingDir.getValue();
            TableName tableName = TableName.valueOf(tableNameString);
            LinkedList<BulkLoadHFiles.LoadQueueItem> queue = new LinkedList<BulkLoadHFiles.LoadQueueItem>();
            BulkLoadHFilesTool.prepareHFileQueue(this.conf, this.connection, tableName, stagingDir, queue, false, false);
            if (queue.isEmpty()) {
                LOG.warn("Did not find any files to replicate in directory {}", (Object)stagingDir.toUri());
                return null;
            }
            this.fsDelegationToken.acquireDelegationToken(this.sinkFs);
            try {
                this.doBulkLoad(this.conf, tableName, stagingDir, queue, maxRetries);
            }
            finally {
                this.cleanup(stagingDir);
            }
        }
        return null;
    }

    private void doBulkLoad(Configuration conf, TableName tableName, Path stagingDir, Deque<BulkLoadHFiles.LoadQueueItem> queue, int maxRetries) throws IOException {
        BulkLoadHFilesTool loader = new BulkLoadHFilesTool(conf);
        loader.setBulkToken(stagingDir.toString());
        loader.setClusterIds(this.sourceClusterIds);
        int count = 0;
        while (!queue.isEmpty()) {
            if (count != 0) {
                LOG.warn("Error replicating HFiles; retry={} with {} remaining.", (Object)count, (Object)queue.size());
            }
            if (maxRetries != 0 && count >= maxRetries) {
                throw new IOException("Retry attempted " + count + " times without completing, bailing.");
            }
            loader.loadHFileQueue(this.connection, tableName, queue, false);
            ++count;
        }
    }

    private void cleanup(Path stagingDir) {
        this.fsDelegationToken.releaseDelegationToken();
        if (stagingDir != null) {
            try {
                this.sinkFs.delete(stagingDir, true);
            }
            catch (IOException e) {
                LOG.warn("Failed to delete the staging directory " + stagingDir, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Path> copyHFilesToStagingDir() throws IOException {
        HashMap<String, Path> mapOfCopiedHFiles = new HashMap<String, Path>();
        FileSystem sourceFs = null;
        try {
            Path sourceClusterPath = new Path(this.sourceBaseNamespaceDirPath);
            String sourceScheme = sourceClusterPath.toUri().getScheme();
            String disableCacheName = String.format("fs.%s.impl.disable.cache", sourceScheme);
            this.sourceClusterConf.setBoolean(disableCacheName, true);
            sourceFs = sourceClusterPath.getFileSystem(this.sourceClusterConf);
            User user = this.userProvider.getCurrent();
            for (Map.Entry<String, List<Pair<byte[], List<String>>>> tableEntry : this.bulkLoadHFileMap.entrySet()) {
                String tableName = tableEntry.getKey();
                Path stagingDir = this.createStagingDir(this.hbaseStagingDir, user, TableName.valueOf(tableName));
                List<Pair<byte[], List<String>>> familyHFilePathsPairsList = tableEntry.getValue();
                int familyHFilePathsPairsListSize = familyHFilePathsPairsList.size();
                for (int i = 0; i < familyHFilePathsPairsListSize; ++i) {
                    Future<Void> future;
                    Copier c;
                    Pair<byte[], List<String>> familyHFilePathsPair = familyHFilePathsPairsList.get(i);
                    byte[] family = familyHFilePathsPair.getFirst();
                    List<String> hfilePaths = familyHFilePathsPair.getSecond();
                    Path familyStagingDir = new Path(stagingDir, Bytes.toString(family));
                    int totalNoOfHFiles = hfilePaths.size();
                    ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
                    int currentCopied = 0;
                    while (totalNoOfHFiles > currentCopied + this.copiesPerThread) {
                        c = new Copier(sourceFs, familyStagingDir, hfilePaths.subList(currentCopied, currentCopied + this.copiesPerThread));
                        future = this.exec.submit(c);
                        futures.add(future);
                        currentCopied += this.copiesPerThread;
                    }
                    int remaining = totalNoOfHFiles - currentCopied;
                    if (remaining > 0) {
                        c = new Copier(sourceFs, familyStagingDir, hfilePaths.subList(currentCopied, currentCopied + remaining));
                        future = this.exec.submit(c);
                        futures.add(future);
                    }
                    for (Future future2 : futures) {
                        try {
                            future2.get();
                        }
                        catch (InterruptedException e) {
                            InterruptedIOException iioe = new InterruptedIOException("Failed to copy HFiles to local file system. This will be retried again by the source cluster.");
                            iioe.initCause(e);
                            throw iioe;
                        }
                        catch (ExecutionException e) {
                            throw new IOException("Failed to copy HFiles to local file system. This will be retried again by the source cluster.", e);
                        }
                    }
                }
                mapOfCopiedHFiles.put(tableName, stagingDir);
            }
            HashMap<String, Path> hashMap = mapOfCopiedHFiles;
            return hashMap;
        }
        finally {
            if (sourceFs != null) {
                sourceFs.close();
            }
            if (this.exec != null) {
                this.exec.shutdown();
            }
        }
    }

    private Path createStagingDir(Path baseDir, User user, TableName tableName) throws IOException {
        String tblName = tableName.getNameAsString().replace(":", UNDERSCORE);
        int RANDOM_WIDTH = 320;
        int RANDOM_RADIX = 32;
        String doubleUnderScore = "__";
        String randomDir = user.getShortName() + doubleUnderScore + tblName + doubleUnderScore + new BigInteger(RANDOM_WIDTH, ThreadLocalRandom.current()).toString(RANDOM_RADIX);
        return this.createStagingDir(baseDir, user, randomDir);
    }

    private Path createStagingDir(Path baseDir, User user, String randomDir) throws IOException {
        Path p = new Path(baseDir, randomDir);
        this.sinkFs.mkdirs(p, PERM_ALL_ACCESS);
        this.sinkFs.setPermission(p, PERM_ALL_ACCESS);
        return p;
    }

    private class Copier
    implements Callable<Void> {
        private FileSystem sourceFs;
        private Path stagingDir;
        private List<String> hfiles;

        public Copier(FileSystem sourceFs, Path stagingDir, List<String> hfiles) throws IOException {
            this.sourceFs = sourceFs;
            this.stagingDir = stagingDir;
            this.hfiles = hfiles;
        }

        @Override
        public Void call() throws IOException {
            int totalHFiles = this.hfiles.size();
            for (int i = 0; i < totalHFiles; ++i) {
                Path sourceHFilePath = new Path(HFileReplicator.this.sourceBaseNamespaceDirPath, this.hfiles.get(i));
                Path localHFilePath = new Path(this.stagingDir, sourceHFilePath.getName());
                try {
                    FileUtil.copy((FileSystem)this.sourceFs, (Path)sourceHFilePath, (FileSystem)HFileReplicator.this.sinkFs, (Path)localHFilePath, (boolean)false, (Configuration)HFileReplicator.this.conf);
                }
                catch (FileNotFoundException e) {
                    LOG.info("Failed to copy hfile from " + sourceHFilePath + " to " + localHFilePath + ". Trying to copy from hfile archive directory.", (Throwable)e);
                    sourceHFilePath = new Path(HFileReplicator.this.sourceHFileArchiveDirPath, this.hfiles.get(i));
                    try {
                        FileUtil.copy((FileSystem)this.sourceFs, (Path)sourceHFilePath, (FileSystem)HFileReplicator.this.sinkFs, (Path)localHFilePath, (boolean)false, (Configuration)HFileReplicator.this.conf);
                    }
                    catch (FileNotFoundException e1) {
                        LOG.debug("Failed to copy hfile from " + sourceHFilePath + " to " + localHFilePath + ". Hence ignoring this hfile from replication..", (Throwable)e1);
                        continue;
                    }
                }
                HFileReplicator.this.sinkFs.setPermission(localHFilePath, PERM_ALL_ACCESS);
            }
            return null;
        }
    }
}

