/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncRegionServerAdmin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.ipc.CallTimeoutException;
import org.apache.hadoop.hbase.protobuf.ReplicationProtobufUtil;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.wal.WALUtil;
import org.apache.hadoop.hbase.replication.HBaseReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationUtils;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterators;
import org.apache.hbase.thirdparty.com.google.common.collect.PeekingIterator;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HBaseInterClusterReplicationEndpoint
extends HBaseReplicationEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseInterClusterReplicationEndpoint.class);
    public static final String REPLICATION_DROP_ON_DELETED_TABLE_KEY = "hbase.replication.drop.on.deleted.table";
    public static final String REPLICATION_DROP_ON_DELETED_COLUMN_FAMILY_KEY = "hbase.replication.drop.on.deleted.columnfamily";
    private long sleepForRetries;
    private int maxRetriesMultiplier;
    private int socketTimeoutMultiplier;
    private int replicationRpcLimit;
    private MetricsSource metrics;
    private boolean peersSelected = false;
    private String replicationClusterId = "";
    private int maxThreads;
    private Path baseNamespaceDir;
    private Path hfileArchiveDir;
    private boolean replicationBulkLoadDataEnabled;
    private boolean dropOnDeletedTables;
    private boolean dropOnDeletedColumnFamilies;
    private boolean isSerial = false;
    private long lastSinkFetchTime = 0L;
    private volatile boolean stopping = false;

    @Override
    public void init(ReplicationEndpoint.Context context) throws IOException {
        super.init(context);
        this.decorateConf();
        this.maxRetriesMultiplier = this.conf.getInt("replication.source.maxretriesmultiplier", 300);
        this.socketTimeoutMultiplier = this.conf.getInt("replication.source.socketTimeoutMultiplier", this.maxRetriesMultiplier);
        this.sleepForRetries = this.conf.getLong("replication.source.sleepforretries", 1000L);
        this.metrics = context.getMetrics();
        this.maxThreads = this.conf.getInt("hbase.replication.source.maxthreads", 10);
        this.replicationRpcLimit = (int)(0.95 * (double)this.conf.getLong("hbase.ipc.max.request.size", 0x10000000L));
        this.dropOnDeletedTables = this.conf.getBoolean(REPLICATION_DROP_ON_DELETED_TABLE_KEY, false);
        this.dropOnDeletedColumnFamilies = this.conf.getBoolean(REPLICATION_DROP_ON_DELETED_COLUMN_FAMILY_KEY, false);
        this.replicationBulkLoadDataEnabled = this.conf.getBoolean("hbase.replication.bulkload.enabled", false);
        if (this.replicationBulkLoadDataEnabled) {
            this.replicationClusterId = this.conf.get("hbase.replication.cluster.id");
        }
        Path rootDir = CommonFSUtils.getRootDir(this.conf);
        Path baseNSDir = new Path("data");
        this.baseNamespaceDir = new Path(rootDir, baseNSDir);
        this.hfileArchiveDir = new Path(rootDir, new Path("archive", baseNSDir));
        this.isSerial = context.getPeerConfig().isSerial();
    }

    private void decorateConf() {
        String replicationCodec = this.conf.get("hbase.replication.rpc.codec");
        if (StringUtils.isNotEmpty(replicationCodec)) {
            this.conf.set("hbase.client.rpc.codec", replicationCodec);
        }
    }

    private void connectToPeers() {
        int sleepMultiplier = 1;
        while (this.isRunning() && this.getNumSinks() == 0) {
            this.chooseSinks();
            if (!this.isRunning() || this.getNumSinks() != 0 || !this.sleepForRetries("Waiting for peers", sleepMultiplier)) continue;
            ++sleepMultiplier;
        }
    }

    private boolean sleepForRetries(String msg, int sleepMultiplier) {
        block3: {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{} {}, sleeping {} times {}", new Object[]{this.logPeerId(), msg, this.sleepForRetries, sleepMultiplier});
                }
                Thread.sleep(this.sleepForRetries * (long)sleepMultiplier);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("{} {} Interrupted while sleeping between retries", (Object)msg, (Object)this.logPeerId());
            }
        }
        return sleepMultiplier < this.maxRetriesMultiplier;
    }

    private int getEstimatedEntrySize(WAL.Entry e) {
        long size = e.getKey().estimatedSerializedSizeOf() + e.getEdit().estimatedSerializedSizeOf();
        return (int)size;
    }

    private List<List<WAL.Entry>> createParallelBatches(List<WAL.Entry> entries) {
        int numSinks = Math.max(this.getNumSinks(), 1);
        int n = Math.min(Math.min(this.maxThreads, entries.size() / 100 + 1), numSinks);
        List<List<WAL.Entry>> entryLists = Stream.generate(ArrayList::new).limit(n).collect(Collectors.toList());
        int[] sizes = new int[n];
        for (WAL.Entry e : entries) {
            int index = Math.abs(Bytes.hashCode(e.getKey().getEncodedRegionName()) % n);
            int entrySize = this.getEstimatedEntrySize(e);
            if (sizes[index] > 0 && sizes[index] + entrySize > this.replicationRpcLimit) {
                entryLists.add(entryLists.get(index));
                entryLists.set(index, new ArrayList());
                sizes[index] = 0;
            }
            entryLists.get(index).add(e);
            int n2 = index;
            sizes[n2] = sizes[n2] + entrySize;
        }
        return entryLists;
    }

    private List<List<WAL.Entry>> createSerialBatches(List<WAL.Entry> entries) {
        TreeMap<byte[], List> regionEntries = new TreeMap<byte[], List>(Bytes.BYTES_COMPARATOR);
        for (WAL.Entry e : entries) {
            regionEntries.computeIfAbsent(e.getKey().getEncodedRegionName(), key -> new ArrayList()).add(e);
        }
        return new ArrayList<List<WAL.Entry>>(regionEntries.values());
    }

    private List<List<WAL.Entry>> createBatches(List<WAL.Entry> entries) {
        if (this.isSerial) {
            return this.createSerialBatches(entries);
        }
        return this.createParallelBatches(entries);
    }

    public static boolean isTableNotFoundException(Throwable io) {
        if (io instanceof RemoteException) {
            io = ((RemoteException)io).unwrapRemoteException();
        }
        if (io != null && io.getMessage().contains("TableNotFoundException")) {
            return true;
        }
        while (io != null) {
            if (io instanceof TableNotFoundException) {
                return true;
            }
            io = io.getCause();
        }
        return false;
    }

    public static boolean isNoSuchColumnFamilyException(Throwable io) {
        if (io instanceof RemoteException) {
            io = ((RemoteException)io).unwrapRemoteException();
        }
        if (io != null && io.getMessage().contains("NoSuchColumnFamilyException")) {
            return true;
        }
        while (io != null) {
            if (io instanceof NoSuchColumnFamilyException) {
                return true;
            }
            io = io.getCause();
        }
        return false;
    }

    List<List<WAL.Entry>> filterNotExistTableEdits(List<List<WAL.Entry>> oldEntryList) {
        ArrayList<List<WAL.Entry>> entryList = new ArrayList<List<WAL.Entry>>();
        HashMap<TableName, Boolean> existMap = new HashMap<TableName, Boolean>();
        try (Connection localConn = ConnectionFactory.createConnection(this.ctx.getLocalConfiguration());
             Admin localAdmin = localConn.getAdmin();){
            for (List<WAL.Entry> oldEntries : oldEntryList) {
                ArrayList<WAL.Entry> entries = new ArrayList<WAL.Entry>();
                for (WAL.Entry e : oldEntries) {
                    TableName tableName = e.getKey().getTableName();
                    boolean exist = true;
                    if (existMap.containsKey(tableName)) {
                        exist = (Boolean)existMap.get(tableName);
                    } else {
                        try {
                            exist = localAdmin.tableExists(tableName);
                            existMap.put(tableName, exist);
                        }
                        catch (IOException iox) {
                            LOG.warn("Exception checking for local table " + tableName, (Throwable)iox);
                            exist = true;
                        }
                    }
                    if (exist) {
                        entries.add(e);
                        continue;
                    }
                    LOG.warn("Missing table detected at sink, local table also does not exist, filtering edits for table '{}'", (Object)tableName);
                }
                if (entries.isEmpty()) continue;
                entryList.add(entries);
            }
        }
        catch (IOException iox) {
            LOG.warn("Exception when creating connection to check local table", (Throwable)iox);
            return oldEntryList;
        }
        return entryList;
    }

    List<List<WAL.Entry>> filterNotExistColumnFamilyEdits(List<List<WAL.Entry>> oldEntryList) {
        ArrayList<List<WAL.Entry>> entryList = new ArrayList<List<WAL.Entry>>();
        HashMap existColumnFamilyMap = new HashMap();
        try (Connection localConn = ConnectionFactory.createConnection(this.ctx.getLocalConfiguration());
             Admin localAdmin = localConn.getAdmin();){
            for (List<WAL.Entry> oldEntries : oldEntryList) {
                ArrayList<WAL.Entry> entries = new ArrayList<WAL.Entry>();
                for (WAL.Entry e : oldEntries) {
                    TableName tableName = e.getKey().getTableName();
                    if (!existColumnFamilyMap.containsKey(tableName)) {
                        try {
                            Set cfs = localAdmin.getDescriptor(tableName).getColumnFamilyNames().stream().map(Bytes::toString).collect(Collectors.toSet());
                            existColumnFamilyMap.put(tableName, cfs);
                        }
                        catch (Exception ex) {
                            LOG.warn("Exception getting cf names for local table {}", (Object)tableName, (Object)ex);
                            entries.add(e);
                            continue;
                        }
                    }
                    Set existColumnFamilies = (Set)existColumnFamilyMap.get(tableName);
                    HashSet missingCFs = new HashSet();
                    WALEdit walEdit = new WALEdit();
                    walEdit.getCells().addAll(e.getEdit().getCells());
                    WALUtil.filterCells(walEdit, cell -> {
                        String cf = Bytes.toString(CellUtil.cloneFamily(cell));
                        if (existColumnFamilies.contains(cf)) {
                            return cell;
                        }
                        missingCFs.add(cf);
                        return null;
                    });
                    if (!walEdit.isEmpty()) {
                        WAL.Entry newEntry = new WAL.Entry(e.getKey(), walEdit);
                        entries.add(newEntry);
                    }
                    if (missingCFs.isEmpty()) continue;
                    LOG.warn("Missing column family detected at sink, local column family also does not exist, filtering edits for table '{}',column family '{}'", (Object)tableName, missingCFs);
                }
                if (entries.isEmpty()) continue;
                entryList.add(entries);
            }
        }
        catch (IOException iox) {
            LOG.warn("Exception when creating connection to check local table", (Throwable)iox);
            return oldEntryList;
        }
        return entryList;
    }

    private long parallelReplicate(ReplicationEndpoint.ReplicateContext replicateContext, List<List<WAL.Entry>> batches) throws IOException {
        ArrayList<CompletableFuture<Integer>> futures = new ArrayList<CompletableFuture<Integer>>(batches.size());
        for (int i = 0; i < batches.size(); ++i) {
            List<WAL.Entry> entries = batches.get(i);
            if (entries.isEmpty()) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} Submitting {} entries of total size {}", new Object[]{this.logPeerId(), entries.size(), replicateContext.getSize()});
            }
            futures.add(this.asyncReplicate(entries, i, replicateContext.getTimeout()));
        }
        IOException iox = null;
        long lastWriteTime = 0L;
        for (CompletableFuture completableFuture : futures) {
            try {
                int index = (Integer)FutureUtils.get(completableFuture);
                List<WAL.Entry> batch = batches.get(index);
                batches.set(index, Collections.emptyList());
                long writeTime = batch.get(batch.size() - 1).getKey().getWriteTime();
                if (writeTime <= lastWriteTime) continue;
                lastWriteTime = writeTime;
            }
            catch (IOException e) {
                iox = e;
            }
            catch (RuntimeException e) {
                iox = new IOException(e);
            }
        }
        if (iox != null) {
            throw iox;
        }
        return lastWriteTime;
    }

    @Override
    public boolean replicate(ReplicationEndpoint.ReplicateContext replicateContext) {
        int numSinks;
        int sleepMultiplier = 1;
        int initialTimeout = replicateContext.getTimeout();
        if (!this.peersSelected && this.isRunning()) {
            this.connectToPeers();
            this.peersSelected = true;
        }
        if ((numSinks = this.getNumSinks()) == 0) {
            if (EnvironmentEdgeManager.currentTime() - this.lastSinkFetchTime >= (long)(this.maxRetriesMultiplier * 1000)) {
                LOG.warn("No replication sinks found, returning without replicating. The source should retry with the same set of edits. Not logging this again for the next {} seconds.", (Object)this.maxRetriesMultiplier);
                this.lastSinkFetchTime = EnvironmentEdgeManager.currentTime();
            }
            this.sleepForRetries("No sinks available at peer", sleepMultiplier);
            return false;
        }
        List<List<WAL.Entry>> batches = this.createBatches(replicateContext.getEntries());
        while (this.isRunning() && !this.stopping) {
            if (!this.isPeerEnabled()) {
                if (!this.sleepForRetries("Replication is disabled", sleepMultiplier)) continue;
                ++sleepMultiplier;
                continue;
            }
            try {
                this.parallelReplicate(replicateContext, batches);
                return true;
            }
            catch (IOException ioe) {
                if (ioe instanceof RemoteException) {
                    if (this.dropOnDeletedTables && HBaseInterClusterReplicationEndpoint.isTableNotFoundException(ioe)) {
                        if ((batches = this.filterNotExistTableEdits(batches)).isEmpty()) {
                            LOG.warn("After filter not exist table's edits, 0 edits to replicate, just return");
                            return true;
                        }
                    } else if (this.dropOnDeletedColumnFamilies && HBaseInterClusterReplicationEndpoint.isNoSuchColumnFamilyException(ioe)) {
                        if ((batches = this.filterNotExistColumnFamilyEdits(batches)).isEmpty()) {
                            LOG.warn("After filter not exist column family's edits, 0 edits to replicate, just return");
                            return true;
                        }
                    } else {
                        LOG.warn("{} Peer encountered RemoteException, rechecking all sinks: ", (Object)this.logPeerId(), (Object)ioe);
                        this.chooseSinks();
                    }
                } else if (ioe instanceof SocketTimeoutException) {
                    this.sleepForRetries("Encountered a SocketTimeoutException. Since the call to the remote cluster timed out, which is usually caused by a machine failure or a massive slowdown", this.socketTimeoutMultiplier);
                } else if (ioe instanceof ConnectException || ioe instanceof UnknownHostException) {
                    LOG.warn("{} Peer is unavailable, rechecking all sinks: ", (Object)this.logPeerId(), (Object)ioe);
                    this.chooseSinks();
                } else if (ioe instanceof CallTimeoutException) {
                    replicateContext.setTimeout(ReplicationUtils.getAdaptiveTimeout(initialTimeout, sleepMultiplier));
                } else {
                    LOG.warn("{} Can't replicate because of a local or network error: ", (Object)this.logPeerId(), (Object)ioe);
                }
                if (!this.sleepForRetries("Since we are unable to replicate", sleepMultiplier)) continue;
                ++sleepMultiplier;
            }
        }
        return false;
    }

    protected boolean isPeerEnabled() {
        return this.ctx.getReplicationPeer().isPeerEnabled();
    }

    @Override
    protected void doStop() {
        this.stopping = true;
        this.disconnect();
        this.notifyStopped();
    }

    protected CompletableFuture<Integer> replicateEntries(List<WAL.Entry> entries, int batchIndex, int timeout) {
        int entriesHashCode = System.identityHashCode(entries);
        if (LOG.isTraceEnabled()) {
            long size = entries.stream().mapToLong(this::getEstimatedEntrySize).sum();
            LOG.trace("{} Replicating batch {} of {} entries with total size {} bytes to {}", new Object[]{this.logPeerId(), entriesHashCode, entries.size(), size, this.replicationClusterId});
        }
        HBaseReplicationEndpoint.SinkPeer sinkPeer = null;
        CompletableFuture<Integer> resultCompletableFuture = new CompletableFuture<Integer>();
        try {
            sinkPeer = this.getReplicationSink();
        }
        catch (IOException e) {
            this.onReplicateWALEntryException(entriesHashCode, e, sinkPeer);
            resultCompletableFuture.completeExceptionally(e);
            return resultCompletableFuture;
        }
        assert (sinkPeer != null);
        AsyncRegionServerAdmin rsAdmin = sinkPeer.getRegionServer();
        HBaseReplicationEndpoint.SinkPeer sinkPeerToUse = sinkPeer;
        FutureUtils.addListener(ReplicationProtobufUtil.replicateWALEntry(rsAdmin, entries.toArray(new WAL.Entry[entries.size()]), this.replicationClusterId, this.baseNamespaceDir, this.hfileArchiveDir, timeout), (response, exception) -> {
            if (exception != null) {
                this.onReplicateWALEntryException(entriesHashCode, (Throwable)exception, sinkPeerToUse);
                resultCompletableFuture.completeExceptionally((Throwable)exception);
                return;
            }
            this.reportSinkSuccess(sinkPeerToUse);
            resultCompletableFuture.complete(batchIndex);
        });
        return resultCompletableFuture;
    }

    private void onReplicateWALEntryException(int entriesHashCode, Throwable exception, HBaseReplicationEndpoint.SinkPeer sinkPeer) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} Failed replicating batch {}", new Object[]{this.logPeerId(), entriesHashCode, exception});
        }
        if (exception instanceof IOException && sinkPeer != null) {
            this.reportBadSink(sinkPeer);
        }
    }

    private CompletableFuture<Integer> serialReplicateRegionEntries(PeekingIterator<WAL.Entry> walEntryPeekingIterator, int batchIndex, int timeout) {
        if (!walEntryPeekingIterator.hasNext()) {
            return CompletableFuture.completedFuture(batchIndex);
        }
        int batchSize = 0;
        ArrayList<WAL.Entry> batch = new ArrayList<WAL.Entry>();
        while (walEntryPeekingIterator.hasNext()) {
            WAL.Entry entry = walEntryPeekingIterator.peek();
            int entrySize = this.getEstimatedEntrySize(entry);
            if (batchSize > 0 && batchSize + entrySize > this.replicationRpcLimit) break;
            walEntryPeekingIterator.next();
            batch.add(entry);
            batchSize += entrySize;
        }
        if (batchSize <= 0) {
            return CompletableFuture.completedFuture(batchIndex);
        }
        CompletableFuture<Integer> resultCompletableFuture = new CompletableFuture<Integer>();
        FutureUtils.addListener(this.replicateEntries(batch, batchIndex, timeout), (response, exception) -> {
            if (exception != null) {
                resultCompletableFuture.completeExceptionally((Throwable)exception);
                return;
            }
            if (!walEntryPeekingIterator.hasNext()) {
                resultCompletableFuture.complete(batchIndex);
                return;
            }
            FutureUtils.addListener(this.serialReplicateRegionEntries(walEntryPeekingIterator, batchIndex, timeout), (currentResponse, currentException) -> {
                if (currentException != null) {
                    resultCompletableFuture.completeExceptionally((Throwable)currentException);
                    return;
                }
                resultCompletableFuture.complete(batchIndex);
            });
        });
        return resultCompletableFuture;
    }

    protected CompletableFuture<Integer> asyncReplicate(List<WAL.Entry> entries, int batchIndex, int timeout) {
        return this.isSerial ? this.serialReplicateRegionEntries(Iterators.peekingIterator(entries.iterator()), batchIndex, timeout) : this.replicateEntries(entries, batchIndex, timeout);
    }

    private String logPeerId() {
        return "[Source for peer " + this.ctx.getPeerId() + "]:";
    }
}

