/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfigListener;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReplicationPeerImpl
implements ReplicationPeer,
ConfigurationObserver {
    private volatile Configuration conf;
    private final String id;
    private volatile ReplicationPeerConfig peerConfig;
    private volatile ReplicationPeer.PeerState peerState;
    private volatile int syncReplicationStateBits;
    private static final int SHIFT = 16;
    private static final int AND_BITS = 65535;
    private final List<ReplicationPeerConfigListener> peerConfigListeners;

    public ReplicationPeerImpl(Configuration conf, String id, ReplicationPeerConfig peerConfig, boolean peerState, SyncReplicationState syncReplicationState, SyncReplicationState newSyncReplicationState) {
        this.conf = conf;
        this.id = id;
        this.setPeerState(peerState);
        this.peerConfig = peerConfig;
        this.syncReplicationStateBits = syncReplicationState.value() | newSyncReplicationState.value() << 16;
        this.peerConfigListeners = new ArrayList<ReplicationPeerConfigListener>();
    }

    public void setPeerState(boolean enabled) {
        this.peerState = enabled ? ReplicationPeer.PeerState.ENABLED : ReplicationPeer.PeerState.DISABLED;
    }

    public void setPeerConfig(ReplicationPeerConfig peerConfig) {
        this.peerConfig = peerConfig;
        this.peerConfigListeners.forEach(listener -> listener.peerConfigUpdated(peerConfig));
    }

    public void setNewSyncReplicationState(SyncReplicationState newState) {
        this.syncReplicationStateBits = this.syncReplicationStateBits & 0xFFFF | newState.value() << 16;
    }

    public void transitSyncReplicationState() {
        this.syncReplicationStateBits = this.syncReplicationStateBits >>> 16 | SyncReplicationState.NONE.value() << 16;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ReplicationPeer.PeerState getPeerState() {
        return this.peerState;
    }

    private static SyncReplicationState getSyncReplicationState(int bits) {
        return SyncReplicationState.valueOf(bits & 0xFFFF);
    }

    private static SyncReplicationState getNewSyncReplicationState(int bits) {
        return SyncReplicationState.valueOf(bits >>> 16);
    }

    public Pair<SyncReplicationState, SyncReplicationState> getSyncReplicationStateAndNewState() {
        int bits = this.syncReplicationStateBits;
        return Pair.newPair(ReplicationPeerImpl.getSyncReplicationState(bits), ReplicationPeerImpl.getNewSyncReplicationState(bits));
    }

    public SyncReplicationState getNewSyncReplicationState() {
        return ReplicationPeerImpl.getNewSyncReplicationState(this.syncReplicationStateBits);
    }

    @Override
    public SyncReplicationState getSyncReplicationState() {
        return ReplicationPeerImpl.getSyncReplicationState(this.syncReplicationStateBits);
    }

    @Override
    public ReplicationPeerConfig getPeerConfig() {
        return this.peerConfig;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public Map<TableName, List<String>> getTableCFs() {
        return this.peerConfig.getTableCFsMap();
    }

    @Override
    public Set<String> getNamespaces() {
        return this.peerConfig.getNamespaces();
    }

    @Override
    public long getPeerBandwidth() {
        return this.peerConfig.getBandwidth();
    }

    @Override
    public void registerPeerConfigListener(ReplicationPeerConfigListener listener) {
        this.peerConfigListeners.add(listener);
    }

    @Override
    public void onConfigurationChange(Configuration conf) {
        this.conf = conf;
    }
}

