/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.io.asyncfs.monitor.StreamSlowMonitor;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.Encryptor;
import org.apache.hadoop.hbase.io.util.LRUDictionary;
import org.apache.hadoop.hbase.regionserver.wal.AbstractProtobufWALReader;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.SecureWALCellCodec;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EncryptionTest;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class AbstractProtobufLogWriter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractProtobufLogWriter.class);
    protected CompressionContext compressionContext;
    protected Configuration conf;
    protected Encryptor encryptor;
    protected Codec.Encoder cellEncoder;
    protected WALCellCodec.ByteStringCompressor compressor;
    protected boolean trailerWritten;
    protected WALProtos.WALTrailer trailer;
    protected int trailerWarnSize;
    protected AtomicLong length = new AtomicLong();

    private WALCellCodec getCodec(Configuration conf, CompressionContext compressionContext) throws IOException {
        return WALCellCodec.create(conf, null, compressionContext);
    }

    private WALProtos.WALHeader buildWALHeader(Configuration conf, WALProtos.WALHeader.Builder builder) throws IOException {
        builder.setWriterClsName(this.getWriterClassName());
        builder.setCellCodecClsName(WALCellCodec.getWALCellCodecClass(conf).getName());
        return builder.build();
    }

    private WALProtos.WALHeader buildSecureWALHeader(Configuration conf, WALProtos.WALHeader.Builder builder) throws IOException {
        EncryptionTest.testKeyProvider(conf);
        EncryptionTest.testCipherProvider(conf);
        String cipherName = conf.get("hbase.crypto.wal.algorithm", "AES");
        Cipher cipher = Encryption.getCipher(conf, cipherName);
        if (cipher == null) {
            throw new RuntimeException("Cipher '" + cipherName + "' is not available");
        }
        Key key = cipher.getRandomKey();
        builder.setEncryptionKey(UnsafeByteOperations.unsafeWrap(EncryptionUtil.wrapKey(conf, conf.get("hbase.crypto.wal.key.name", conf.get("hbase.crypto.master.key.name", User.getCurrent().getShortName())), key)));
        Encryptor encryptor = cipher.getEncryptor();
        encryptor.setKey(key);
        this.encryptor = encryptor;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Initialized secure protobuf WAL: cipher={}", (Object)cipher.getName());
        }
        builder.setWriterClsName(this.getWriterClassName());
        builder.setCellCodecClsName(SecureWALCellCodec.class.getName());
        return builder.build();
    }

    private String getWriterClassName() {
        if (this.encryptor == null) {
            return "ProtobufLogWriter";
        }
        return "SecureProtobufLogWriter";
    }

    private boolean initializeCompressionContext(Configuration conf, Path path) throws IOException {
        boolean doCompress = conf.getBoolean("hbase.regionserver.wal.enablecompression", false);
        if (doCompress) {
            try {
                Compression.Algorithm valueCompressionType;
                boolean useTagCompression = conf.getBoolean("hbase.regionserver.wal.tags.enablecompression", true);
                boolean useValueCompression = conf.getBoolean("hbase.regionserver.wal.value.enablecompression", false);
                Compression.Algorithm algorithm = valueCompressionType = useValueCompression ? CompressionContext.getValueCompressionAlgorithm(conf) : Compression.Algorithm.NONE;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Initializing compression context for {}: isRecoveredEdits={}, hasTagCompression={}, hasValueCompression={}, valueCompressionType={}", new Object[]{path, CommonFSUtils.isRecoveredEdits(path), useTagCompression, useValueCompression, valueCompressionType});
                }
                this.compressionContext = new CompressionContext(LRUDictionary.class, CommonFSUtils.isRecoveredEdits(path), useTagCompression, useValueCompression, valueCompressionType);
            }
            catch (Exception e) {
                throw new IOException("Failed to initiate CompressionContext", e);
            }
        }
        return doCompress;
    }

    public void init(FileSystem fs, Path path, Configuration conf, boolean overwritable, long blocksize, StreamSlowMonitor monitor) throws IOException, CommonFSUtils.StreamLacksCapabilityException {
        try {
            this.conf = conf;
            boolean doCompress = this.initializeCompressionContext(conf, path);
            this.trailerWarnSize = conf.getInt("hbase.regionserver.waltrailer.warn.size", 0x100000);
            int bufferSize = CommonFSUtils.getDefaultBufferSize(fs);
            short replication = (short)conf.getInt("hbase.regionserver.hlog.replication", (int)CommonFSUtils.getDefaultReplication(fs, path));
            this.initOutput(fs, path, overwritable, bufferSize, replication, blocksize, monitor);
            boolean doTagCompress = doCompress && conf.getBoolean("hbase.regionserver.wal.tags.enablecompression", true);
            boolean doValueCompress = doCompress && conf.getBoolean("hbase.regionserver.wal.value.enablecompression", false);
            WALProtos.WALHeader.Builder headerBuilder = WALProtos.WALHeader.newBuilder().setHasCompression(doCompress).setHasTagCompression(doTagCompress).setHasValueCompression(doValueCompress);
            if (doValueCompress) {
                headerBuilder.setValueCompressionAlgorithm(CompressionContext.getValueCompressionAlgorithm(conf).ordinal());
            }
            if (conf.getBoolean("hbase.regionserver.wal.encryption", false)) {
                this.length.set(this.writeMagicAndWALHeader(AbstractProtobufWALReader.PB_WAL_MAGIC, this.buildSecureWALHeader(conf, headerBuilder)));
                this.secureInitAfterHeader(doCompress, this.encryptor);
            } else {
                this.length.set(this.writeMagicAndWALHeader(AbstractProtobufWALReader.PB_WAL_MAGIC, this.buildWALHeader(conf, headerBuilder)));
                this.initAfterHeader(doCompress);
            }
            this.trailer = WALProtos.WALTrailer.newBuilder().build();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Initialized protobuf WAL={}, compression={}, tagCompression={}, valueCompression={}", new Object[]{path, doCompress, doTagCompress, doValueCompress});
            }
        }
        catch (Exception e) {
            LOG.warn("Init output failed, path={}", (Object)path, (Object)e);
            this.closeOutputIfNecessary();
            throw e;
        }
    }

    private void initAfterHeader(boolean doCompress) throws IOException {
        WALCellCodec codec = this.getCodec(this.conf, this.compressionContext);
        this.cellEncoder = codec.getEncoder(this.getOutputStreamForCellEncoder());
        this.compressor = doCompress ? codec.getByteStringCompressor() : WALCellCodec.getNoneCompressor();
    }

    private void secureInitAfterHeader(boolean doCompress, Encryptor encryptor) throws IOException {
        if (encryptor != null) {
            WALCellCodec codec = SecureWALCellCodec.getCodec(this.conf, encryptor);
            this.cellEncoder = codec.getEncoder(this.getOutputStreamForCellEncoder());
            this.compressionContext = null;
            this.compressor = WALCellCodec.getNoneCompressor();
        } else {
            this.initAfterHeader(doCompress);
        }
    }

    void setWALTrailer(WALProtos.WALTrailer walTrailer) {
        this.trailer = walTrailer;
    }

    public long getLength() {
        return this.length.get();
    }

    private WALProtos.WALTrailer buildWALTrailer(WALProtos.WALTrailer.Builder builder) {
        return builder.build();
    }

    protected final void writeWALTrailer() {
        try {
            int trailerSize = 0;
            if (this.trailer == null) {
                LOG.warn("WALTrailer is null. Continuing with default.");
                this.trailer = this.buildWALTrailer(WALProtos.WALTrailer.newBuilder());
                trailerSize = this.trailer.getSerializedSize();
            } else {
                trailerSize = this.trailer.getSerializedSize();
                if (trailerSize > this.trailerWarnSize) {
                    LOG.warn("Please investigate WALTrailer usage. Trailer size > maximum size : " + trailerSize + " > " + this.trailerWarnSize);
                }
            }
            this.length.set(this.writeWALTrailerAndMagic(this.trailer, AbstractProtobufWALReader.PB_WAL_COMPLETE_MAGIC));
            this.trailerWritten = true;
        }
        catch (IOException ioe) {
            LOG.warn("Failed to write trailer, non-fatal, continuing...", (Throwable)ioe);
        }
    }

    protected abstract void initOutput(FileSystem var1, Path var2, boolean var3, int var4, short var5, long var6, StreamSlowMonitor var8) throws IOException, CommonFSUtils.StreamLacksCapabilityException;

    protected void closeOutputIfNecessary() {
    }

    protected abstract long writeMagicAndWALHeader(byte[] var1, WALProtos.WALHeader var2) throws IOException;

    protected abstract long writeWALTrailerAndMagic(WALProtos.WALTrailer var1, byte[] var2) throws IOException;

    protected abstract OutputStream getOutputStreamForCellEncoder();
}

