/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.master.BooleanStateStore;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReplicationPeerModificationStateStore
extends BooleanStateStore {
    public static final String STATE_NAME = "replication_peer_modification_on";

    public ReplicationPeerModificationStateStore(MasterRegion masterRegion) throws DeserializationException, IOException, KeeperException {
        super(masterRegion, STATE_NAME, null, null);
    }

    @Override
    protected byte[] toByteArray(boolean on) {
        ReplicationProtos.ReplicationPeerModificationState.Builder builder = ReplicationProtos.ReplicationPeerModificationState.newBuilder();
        builder.setOn(on);
        return ProtobufUtil.prependPBMagic(builder.build().toByteArray());
    }

    @Override
    protected boolean parseFrom(byte[] bytes) throws DeserializationException {
        ProtobufUtil.expectPBMagicPrefix(bytes);
        ReplicationProtos.ReplicationPeerModificationState.Builder builder = ReplicationProtos.ReplicationPeerModificationState.newBuilder();
        try {
            int magicLen = ProtobufUtil.lengthOfPBMagic();
            ProtobufUtil.mergeFrom(builder, bytes, magicLen, bytes.length - magicLen);
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
        return builder.build().getOn();
    }
}

