/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hadoop.hbase.master.replication.AssignReplicationQueuesProcedure;
import org.apache.hadoop.hbase.master.replication.ModifyPeerProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RemovePeerProcedure
extends ModifyPeerProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(RemovePeerProcedure.class);
    private ReplicationPeerConfig peerConfig;
    private List<Long> ongoingAssignReplicationQueuesProcIds = Collections.emptyList();

    public RemovePeerProcedure() {
    }

    public RemovePeerProcedure(String peerId) {
        super(peerId);
    }

    @Override
    public PeerProcedureInterface.PeerOperationType getPeerOperationType() {
        return PeerProcedureInterface.PeerOperationType.REMOVE;
    }

    @Override
    protected void prePeerModification(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preRemoveReplicationPeer(this.peerId);
        }
        this.peerConfig = env.getReplicationPeerManager().preRemovePeer(this.peerId);
    }

    @Override
    protected void updatePeerStorage(MasterProcedureEnv env) throws ReplicationException {
        env.getReplicationPeerManager().removePeer(this.peerId);
        this.ongoingAssignReplicationQueuesProcIds = env.getMasterServices().getMasterProcedureExecutor().getProcedures().stream().filter(p -> p instanceof AssignReplicationQueuesProcedure).filter(p -> !p.isFinished()).map(Procedure::getProcId).collect(Collectors.toList());
    }

    private void removeRemoteWALs(MasterProcedureEnv env) throws IOException {
        env.getMasterServices().getSyncReplicationReplayWALManager().removePeerRemoteWALs(this.peerId);
    }

    private void checkAssignReplicationQueuesFinished(MasterProcedureEnv env) throws ProcedureSuspendedException {
        if (this.ongoingAssignReplicationQueuesProcIds.isEmpty()) {
            LOG.info("No ongoing assign replication queues procedures when removing peer {}, move on", (Object)this.peerId);
        }
        ProcedureExecutor<MasterProcedureEnv> procExec = env.getMasterServices().getMasterProcedureExecutor();
        long[] unfinishedProcIds = this.ongoingAssignReplicationQueuesProcIds.stream().map(procExec::getProcedure).filter(p -> p != null && !p.isFinished()).mapToLong(Procedure::getProcId).toArray();
        if (unfinishedProcIds.length != 0) {
            throw this.suspend(env.getMasterConfiguration(), backoff -> LOG.info("There are still {} pending assign replication queues procedures {} when removing peer {}, sleep {} secs", new Object[]{unfinishedProcIds.length, Arrays.toString(unfinishedProcIds), this.peerId, backoff / 1000L}));
        }
        LOG.info("All assign replication queues procedures are finished when removing peer {}, move on", (Object)this.peerId);
    }

    @Override
    protected void postPeerModification(MasterProcedureEnv env) throws IOException, ReplicationException, ProcedureSuspendedException {
        this.checkAssignReplicationQueuesFinished(env);
        if (this.peerConfig.isSyncReplication()) {
            this.removeRemoteWALs(env);
        }
        env.getReplicationPeerManager().removeAllQueuesAndHFileRefs(this.peerId);
        if (this.peerConfig.isSerial()) {
            env.getReplicationPeerManager().removeAllLastPushedSeqIds(this.peerId);
        }
        LOG.info("Successfully removed peer {}", (Object)this.peerId);
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.postRemoveReplicationPeer(this.peerId);
        }
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.RemovePeerStateData.Builder builder = MasterProcedureProtos.RemovePeerStateData.newBuilder();
        if (this.peerConfig != null) {
            builder.setPeerConfig(ReplicationPeerConfigUtil.convert(this.peerConfig));
        }
        builder.addAllOngoingAssignReplicationQueuesProcIds(this.ongoingAssignReplicationQueuesProcIds);
        serializer.serialize(builder.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.RemovePeerStateData data = serializer.deserialize(MasterProcedureProtos.RemovePeerStateData.class);
        if (data.hasPeerConfig()) {
            this.peerConfig = ReplicationPeerConfigUtil.convert(data.getPeerConfig());
        }
        this.ongoingAssignReplicationQueuesProcIds = data.getOngoingAssignReplicationQueuesProcIdsList();
    }
}

