/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import org.apache.hadoop.hbase.master.replication.ClaimReplicationQueueRemoteProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationGroupOffset;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.replication.ReplicationQueueId;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@InterfaceAudience.Private
public class ClaimReplicationQueuesProcedure
extends Procedure<MasterProcedureEnv>
implements ServerProcedureInterface {
    private static final Logger LOG = LoggerFactory.getLogger(ClaimReplicationQueuesProcedure.class);
    private ServerName crashedServer;
    private RetryCounter retryCounter;

    public ClaimReplicationQueuesProcedure() {
    }

    public ClaimReplicationQueuesProcedure(ServerName crashedServer) {
        this.crashedServer = crashedServer;
    }

    @Override
    public ServerName getServerName() {
        return this.crashedServer;
    }

    @Override
    public boolean hasMetaTableRegion() {
        return false;
    }

    @Override
    public ServerProcedureInterface.ServerOperationType getServerOperationType() {
        return ServerProcedureInterface.ServerOperationType.CLAIM_REPLICATION_QUEUES;
    }

    @Override
    protected Procedure<MasterProcedureEnv>[] execute(MasterProcedureEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
        ReplicationQueueStorage storage = env.getReplicationPeerManager().getQueueStorage();
        try {
            List<ReplicationQueueId> queues = storage.listAllQueueIds(this.crashedServer);
            HashSet<String> existQueuePeerIds = new HashSet<String>();
            Iterator<ReplicationQueueId> iter = queues.iterator();
            while (iter.hasNext()) {
                ReplicationQueueId queueId = iter.next();
                if (queueId.getPeerId().equals("region_replica_replication")) {
                    LOG.info("Found replication queue {} for legacy region replication peer, skipping claiming and removing...", (Object)queueId);
                    iter.remove();
                    storage.removeQueue(queueId);
                    continue;
                }
                if (queueId.isRecovered()) continue;
                existQueuePeerIds.add(queueId.getPeerId());
            }
            List<ReplicationPeerDescription> peers = env.getReplicationPeerManager().listPeers(null);
            for (ReplicationPeerDescription peer : peers) {
                if (existQueuePeerIds.contains(peer.getPeerId())) continue;
                ReplicationQueueId queueId = new ReplicationQueueId(this.crashedServer, peer.getPeerId());
                env.getReplicationPeerManager().getQueueStorage().setOffset(queueId, this.crashedServer.toString(), ReplicationGroupOffset.BEGIN, Collections.emptyMap());
                queues.add(queueId);
            }
            if (queues.isEmpty()) {
                LOG.debug("Finish claiming replication queues for {}", (Object)this.crashedServer);
                return null;
            }
            LOG.debug("There are {} replication queues need to be claimed for {}", (Object)queues.size(), (Object)this.crashedServer);
            List<ServerName> targetServers = env.getMasterServices().getServerManager().getOnlineServersList();
            if (targetServers.isEmpty()) {
                throw new ReplicationException("no region server available");
            }
            Collections.shuffle(targetServers);
            ClaimReplicationQueueRemoteProcedure[] procs = new ClaimReplicationQueueRemoteProcedure[Math.min(queues.size(), targetServers.size())];
            for (int i = 0; i < procs.length; ++i) {
                procs[i] = new ClaimReplicationQueueRemoteProcedure(queues.get(i), targetServers.get(i));
            }
            return procs;
        }
        catch (ReplicationException e) {
            if (this.retryCounter == null) {
                this.retryCounter = ProcedureUtil.createRetryCounter(env.getMasterConfiguration());
            }
            long backoff = this.retryCounter.getBackoffTimeAndIncrementAttempts();
            LOG.warn("Failed to claim replication queues for {}, suspend {}secs {}; {};", new Object[]{this.crashedServer, backoff / 1000L, e});
            this.setTimeout(Math.toIntExact(backoff));
            this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
            this.skipPersistence();
            throw new ProcedureSuspendedException();
        }
    }

    @Override
    protected synchronized boolean setTimeoutFailure(MasterProcedureEnv env) {
        this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
        env.getProcedureScheduler().addFront(this);
        return false;
    }

    @Override
    protected void rollback(MasterProcedureEnv env) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean abort(MasterProcedureEnv env) {
        return false;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        serializer.serialize(MasterProcedureProtos.ClaimReplicationQueuesStateData.newBuilder().setCrashedServer(ProtobufUtil.toServerName(this.crashedServer)).build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.ClaimReplicationQueuesStateData data = serializer.deserialize(MasterProcedureProtos.ClaimReplicationQueuesStateData.class);
        this.crashedServer = ProtobufUtil.toServerName(data.getCrashedServer());
    }
}

