/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class LoadBalancerFactory {
    private LoadBalancerFactory() {
    }

    public static Class<? extends LoadBalancer> getDefaultLoadBalancerClass() {
        return StochasticLoadBalancer.class;
    }

    public static LoadBalancer getLoadBalancer(Configuration conf) {
        Class balancerKlass = conf.getClass("hbase.master.loadbalancer.class", LoadBalancerFactory.getDefaultLoadBalancerClass(), LoadBalancer.class);
        return (LoadBalancer)ReflectionUtils.newInstance(balancerKlass, new Object[0]);
    }
}

