/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerListener;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class WorkerAssigner
implements ServerListener {
    private final Map<ServerName, Integer> currentWorkers = new HashMap<ServerName, Integer>();
    private final MasterServices master;
    private final ProcedureEvent<?> event;
    private final int maxTasks;

    public WorkerAssigner(MasterServices master, int maxTasks, ProcedureEvent<?> event) {
        this.maxTasks = maxTasks;
        this.master = master;
        this.event = event;
        ServerManager sm = this.master.getServerManager();
        if (sm != null) {
            sm.registerListener(this);
        }
    }

    public synchronized Optional<ServerName> acquire() {
        List<ServerName> serverList = this.master.getServerManager().getOnlineServersList();
        Collections.shuffle(serverList);
        Optional<ServerName> worker = serverList.stream().filter(serverName -> !this.currentWorkers.containsKey(serverName) || this.currentWorkers.get(serverName) > 0).findAny();
        worker.ifPresent(name -> this.currentWorkers.compute((ServerName)name, (serverName, availableWorker) -> availableWorker == null ? this.maxTasks - 1 : availableWorker - 1));
        return worker;
    }

    public synchronized void release(ServerName serverName) {
        this.currentWorkers.compute(serverName, (k, v) -> v == null ? null : Integer.valueOf(v + 1));
    }

    public void suspend(Procedure<?> proc) {
        this.event.suspend();
        this.event.suspendIfNotReady(proc);
    }

    public void wake(MasterProcedureScheduler scheduler) {
        if (!this.event.isReady()) {
            this.event.wake(scheduler);
        }
    }

    @Override
    public void serverAdded(ServerName worker) {
        this.wake(this.master.getMasterProcedureExecutor().getEnvironment().getProcedureScheduler());
    }

    public synchronized void addUsedWorker(ServerName worker) {
        this.currentWorkers.compute(worker, (serverName, availableWorker) -> availableWorker == null ? this.maxTasks - 1 : availableWorker - 1);
    }

    public Integer getAvailableWorker(ServerName serverName) {
        return this.currentWorkers.get(serverName);
    }
}

