/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.ipc.NettyHBaseSaslRpcServerHandler;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.NettyServerRpcConnection;
import org.apache.hadoop.hbase.util.NettyFutureUtils;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.hbase.thirdparty.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hbase.thirdparty.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class NettyRpcServerPreambleHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    static final String DECODER_NAME = "preambleDecoder";
    private final NettyRpcServer rpcServer;
    private final NettyServerRpcConnection conn;

    public NettyRpcServerPreambleHandler(NettyRpcServer rpcServer, NettyServerRpcConnection conn) {
        this.rpcServer = rpcServer;
        this.conn = conn;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(msg.readableBytes());
        msg.readBytes(buf);
        buf.flip();
        if (!this.conn.processPreamble(buf)) {
            this.conn.close();
            return;
        }
        ChannelPipeline p = ctx.pipeline();
        if (this.conn.useSasl) {
            LengthFieldBasedFrameDecoder decoder = new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4);
            decoder.setSingleDecode(true);
            p.addBefore("NettyRpcServerResponseEncoder", "SaslNegotiationDecoder", decoder).addBefore("NettyRpcServerResponseEncoder", null, new NettyHBaseSaslRpcServerHandler(this.rpcServer, this.conn));
        } else {
            this.conn.setupHandler();
        }
        p.remove(this);
        p.remove(DECODER_NAME);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        NettyRpcServer.LOG.warn("Connection {}; caught unexpected downstream exception.", (Object)ctx.channel().remoteAddress(), (Object)cause);
        NettyFutureUtils.safeClose(ctx);
    }
}

