/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompoundConfiguration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfigBuilder;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.base.Splitter;
import org.apache.hbase.thirdparty.com.google.common.base.Strings;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Stable
public final class ReplicationPeerConfigUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationPeerConfigUtil.class);
    public static final String HBASE_REPLICATION_PEER_BASE_CONFIG = "hbase.replication.peer.base.config";

    private ReplicationPeerConfigUtil() {
    }

    public static String convertToString(Set<String> namespaces) {
        if (namespaces == null) {
            return null;
        }
        return StringUtils.join(namespaces, ';');
    }

    public static ReplicationProtos.TableCF[] convert(Map<TableName, ? extends Collection<String>> tableCfs) {
        if (tableCfs == null) {
            return null;
        }
        ArrayList<ReplicationProtos.TableCF> tableCFList = new ArrayList<ReplicationProtos.TableCF>(tableCfs.entrySet().size());
        ReplicationProtos.TableCF.Builder tableCFBuilder = ReplicationProtos.TableCF.newBuilder();
        for (Map.Entry<TableName, ? extends Collection<String>> entry : tableCfs.entrySet()) {
            tableCFBuilder.clear();
            tableCFBuilder.setTableName(ProtobufUtil.toProtoTableName(entry.getKey()));
            Collection<String> v = entry.getValue();
            if (v != null && !v.isEmpty()) {
                for (String value : entry.getValue()) {
                    tableCFBuilder.addFamilies(ByteString.copyFromUtf8(value));
                }
            }
            tableCFList.add(tableCFBuilder.build());
        }
        return tableCFList.toArray(new ReplicationProtos.TableCF[tableCFList.size()]);
    }

    public static String convertToString(Map<TableName, ? extends Collection<String>> tableCfs) {
        if (tableCfs == null) {
            return null;
        }
        return ReplicationPeerConfigUtil.convert(ReplicationPeerConfigUtil.convert(tableCfs));
    }

    public static ReplicationProtos.TableCF[] convert(String tableCFsConfig) {
        if (tableCFsConfig == null || tableCFsConfig.trim().length() == 0) {
            return null;
        }
        ReplicationProtos.TableCF.Builder tableCFBuilder = ReplicationProtos.TableCF.newBuilder();
        List<String> tables = Splitter.on(';').splitToList(tableCFsConfig);
        ArrayList<ReplicationProtos.TableCF> tableCFList = new ArrayList<ReplicationProtos.TableCF>(tables.size());
        for (String tab : tables) {
            if ((tab = tab.trim()).length() == 0) continue;
            List<String> pair = Splitter.on(':').splitToList(tab);
            if (pair.size() > 2) {
                LOG.info("incorrect format:" + tableCFsConfig);
                continue;
            }
            assert (pair.size() > 0);
            Iterator<String> i = pair.iterator();
            String tabName = i.next().trim();
            if (tabName.length() == 0) {
                LOG.info("incorrect format:" + tableCFsConfig);
                continue;
            }
            tableCFBuilder.clear();
            String ns = "default";
            String tName = tabName;
            List<String> dbs = Splitter.on('.').splitToList(tabName);
            if (dbs != null && dbs.size() == 2) {
                Iterator<String> ii = dbs.iterator();
                ns = ii.next();
                tName = ii.next();
            }
            tableCFBuilder.setTableName(ProtobufUtil.toProtoTableName(TableName.valueOf(ns, tName)));
            if (i.hasNext()) {
                List<String> cfsList = Splitter.on(',').splitToList(i.next());
                for (String cf : cfsList) {
                    String cfName = cf.trim();
                    if (cfName.length() <= 0) continue;
                    tableCFBuilder.addFamilies(ByteString.copyFromUtf8(cfName));
                }
            }
            tableCFList.add(tableCFBuilder.build());
        }
        return tableCFList.toArray(new ReplicationProtos.TableCF[tableCFList.size()]);
    }

    public static String convert(ReplicationProtos.TableCF[] tableCFs) {
        StringBuilder sb = new StringBuilder();
        for (ReplicationProtos.TableCF tableCF : tableCFs) {
            String namespace = tableCF.getTableName().getNamespace().toStringUtf8();
            if (StringUtils.isNotEmpty(namespace)) {
                sb.append(namespace).append(".").append(tableCF.getTableName().getQualifier().toStringUtf8()).append(":");
            } else {
                sb.append(tableCF.getTableName().toString()).append(":");
            }
            for (int j = 0; j < tableCF.getFamiliesCount(); ++j) {
                sb.append(tableCF.getFamilies(j).toStringUtf8()).append(",");
            }
            sb.deleteCharAt(sb.length() - 1).append(";");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static ReplicationProtos.TableCF getTableCF(ReplicationProtos.TableCF[] tableCFs, String table) {
        for (ReplicationProtos.TableCF tableCF : tableCFs) {
            if (!tableCF.getTableName().getQualifier().toStringUtf8().equals(table)) continue;
            return tableCF;
        }
        return null;
    }

    public static ReplicationProtos.TableCF[] parseTableCFs(byte[] bytes) throws IOException {
        if (bytes == null) {
            return null;
        }
        return ReplicationPeerConfigUtil.convert(Bytes.toString(bytes));
    }

    public static Map<TableName, List<String>> parseTableCFsFromConfig(String tableCFsConfig) {
        ReplicationProtos.TableCF[] tableCFs = ReplicationPeerConfigUtil.convert(tableCFsConfig);
        return ReplicationPeerConfigUtil.convert2Map(tableCFs);
    }

    public static Map<TableName, List<String>> convert2Map(ReplicationProtos.TableCF[] tableCFs) {
        if (tableCFs == null || tableCFs.length == 0) {
            return null;
        }
        HashMap<TableName, List<String>> tableCFsMap = new HashMap<TableName, List<String>>();
        for (ReplicationProtos.TableCF tableCF : tableCFs) {
            ArrayList<String> families = new ArrayList<String>();
            int m3 = tableCF.getFamiliesCount();
            for (int j = 0; j < m3; ++j) {
                families.add(tableCF.getFamilies(j).toStringUtf8());
            }
            if (families.size() > 0) {
                tableCFsMap.put(ProtobufUtil.toTableName(tableCF.getTableName()), families);
                continue;
            }
            tableCFsMap.put(ProtobufUtil.toTableName(tableCF.getTableName()), null);
        }
        return tableCFsMap;
    }

    public static ReplicationPeerConfig parsePeerFrom(byte[] bytes) throws DeserializationException {
        if (ProtobufUtil.isPBMagicPrefix(bytes)) {
            ReplicationProtos.ReplicationPeer peer;
            int pbLen = ProtobufUtil.lengthOfPBMagic();
            ReplicationProtos.ReplicationPeer.Builder builder = ReplicationProtos.ReplicationPeer.newBuilder();
            try {
                ProtobufUtil.mergeFrom(builder, bytes, pbLen, bytes.length - pbLen);
                peer = builder.build();
            }
            catch (IOException e) {
                throw new DeserializationException(e);
            }
            return ReplicationPeerConfigUtil.convert(peer);
        }
        if (bytes == null || bytes.length <= 0) {
            throw new DeserializationException("Bytes to deserialize should not be empty.");
        }
        return ReplicationPeerConfig.newBuilder().setClusterKey(Bytes.toString(bytes)).build();
    }

    public static ReplicationPeerConfig convert(ReplicationProtos.ReplicationPeer peer) {
        List<ByteString> excludeNamespacesList;
        Map<TableName, List<String>> excludeTableCFsMap;
        List<ByteString> list;
        ReplicationPeerConfigBuilder builder = ReplicationPeerConfig.newBuilder();
        if (peer.hasClusterkey()) {
            builder.setClusterKey(peer.getClusterkey());
        }
        if (peer.hasReplicationEndpointImpl()) {
            builder.setReplicationEndpointImpl(peer.getReplicationEndpointImpl());
        }
        for (HBaseProtos.BytesBytesPair bytesBytesPair : peer.getDataList()) {
            builder.putPeerData(bytesBytesPair.getFirst().toByteArray(), bytesBytesPair.getSecond().toByteArray());
        }
        for (HBaseProtos.NameStringPair nameStringPair : peer.getConfigurationList()) {
            builder.putConfiguration(nameStringPair.getName(), nameStringPair.getValue());
        }
        Map<TableName, List<String>> tableCFsMap = ReplicationPeerConfigUtil.convert2Map(peer.getTableCfsList().toArray(new ReplicationProtos.TableCF[peer.getTableCfsCount()]));
        if (tableCFsMap != null) {
            builder.setTableCFsMap(tableCFsMap);
        }
        if ((list = peer.getNamespacesList()) != null && list.size() != 0) {
            builder.setNamespaces(list.stream().map(ByteString::toStringUtf8).collect(Collectors.toSet()));
        }
        if (peer.hasBandwidth()) {
            builder.setBandwidth(peer.getBandwidth());
        }
        if (peer.hasReplicateAll()) {
            builder.setReplicateAllUserTables(peer.getReplicateAll());
        }
        if (peer.hasSerial()) {
            builder.setSerial(peer.getSerial());
        }
        if ((excludeTableCFsMap = ReplicationPeerConfigUtil.convert2Map(peer.getExcludeTableCfsList().toArray(new ReplicationProtos.TableCF[peer.getExcludeTableCfsCount()]))) != null) {
            builder.setExcludeTableCFsMap(excludeTableCFsMap);
        }
        if ((excludeNamespacesList = peer.getExcludeNamespacesList()) != null && excludeNamespacesList.size() != 0) {
            builder.setExcludeNamespaces(excludeNamespacesList.stream().map(ByteString::toStringUtf8).collect(Collectors.toSet()));
        }
        if (peer.hasRemoteWALDir()) {
            builder.setRemoteWALDir(peer.getRemoteWALDir());
        }
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public static ReplicationProtos.ReplicationPeer convert(ReplicationPeerConfig peerConfig) {
        Set<String> excludeNamespaces;
        Set<String> set;
        ReplicationProtos.ReplicationPeer.Builder builder = ReplicationProtos.ReplicationPeer.newBuilder();
        builder.setClusterkey(peerConfig.getClusterKey() != null ? peerConfig.getClusterKey() : "");
        if (peerConfig.getReplicationEndpointImpl() != null) {
            builder.setReplicationEndpointImpl(peerConfig.getReplicationEndpointImpl());
        }
        for (Map.Entry<byte[], byte[]> entry : peerConfig.getPeerData().entrySet()) {
            builder.addData(HBaseProtos.BytesBytesPair.newBuilder().setFirst(UnsafeByteOperations.unsafeWrap(entry.getKey())).setSecond(UnsafeByteOperations.unsafeWrap(entry.getValue())).build());
        }
        for (Map.Entry<Object, Object> entry : peerConfig.getConfiguration().entrySet()) {
            builder.addConfiguration(HBaseProtos.NameStringPair.newBuilder().setName((String)entry.getKey()).setValue((String)entry.getValue()).build());
        }
        ReplicationProtos.TableCF[] tableCFs = ReplicationPeerConfigUtil.convert(peerConfig.getTableCFsMap());
        if (tableCFs != null) {
            void var3_7;
            boolean bl = false;
            while (var3_7 < tableCFs.length) {
                builder.addTableCfs(tableCFs[var3_7]);
                ++var3_7;
            }
        }
        if ((set = peerConfig.getNamespaces()) != null) {
            for (String namespace : set) {
                builder.addNamespaces(ByteString.copyFromUtf8(namespace));
            }
        }
        builder.setBandwidth(peerConfig.getBandwidth());
        builder.setReplicateAll(peerConfig.replicateAllUserTables());
        builder.setSerial(peerConfig.isSerial());
        ReplicationProtos.TableCF[] excludeTableCFs = ReplicationPeerConfigUtil.convert(peerConfig.getExcludeTableCFsMap());
        if (excludeTableCFs != null) {
            for (int i = 0; i < excludeTableCFs.length; ++i) {
                builder.addExcludeTableCfs(excludeTableCFs[i]);
            }
        }
        if ((excludeNamespaces = peerConfig.getExcludeNamespaces()) != null) {
            for (String namespace : excludeNamespaces) {
                builder.addExcludeNamespaces(ByteString.copyFromUtf8(namespace));
            }
        }
        if (peerConfig.getRemoteWALDir() != null) {
            builder.setRemoteWALDir(peerConfig.getRemoteWALDir());
        }
        return builder.build();
    }

    public static byte[] toByteArray(ReplicationPeerConfig peerConfig) {
        byte[] bytes = ReplicationPeerConfigUtil.convert(peerConfig).toByteArray();
        return ProtobufUtil.prependPBMagic(bytes);
    }

    public static ReplicationPeerDescription toReplicationPeerDescription(ReplicationProtos.ReplicationPeerDescription desc) {
        boolean enabled = ReplicationProtos.ReplicationState.State.ENABLED == desc.getState().getState();
        ReplicationPeerConfig config = ReplicationPeerConfigUtil.convert(desc.getConfig());
        return new ReplicationPeerDescription(desc.getId(), enabled, config, ReplicationPeerConfigUtil.toSyncReplicationState(desc.getSyncReplicationState()));
    }

    public static ReplicationProtos.ReplicationPeerDescription toProtoReplicationPeerDescription(ReplicationPeerDescription desc) {
        ReplicationProtos.ReplicationPeerDescription.Builder builder = ReplicationProtos.ReplicationPeerDescription.newBuilder();
        builder.setId(desc.getPeerId());
        ReplicationProtos.ReplicationState.Builder stateBuilder = ReplicationProtos.ReplicationState.newBuilder();
        stateBuilder.setState(desc.isEnabled() ? ReplicationProtos.ReplicationState.State.ENABLED : ReplicationProtos.ReplicationState.State.DISABLED);
        builder.setState(stateBuilder.build());
        builder.setConfig(ReplicationPeerConfigUtil.convert(desc.getPeerConfig()));
        builder.setSyncReplicationState(ReplicationPeerConfigUtil.toSyncReplicationState(desc.getSyncReplicationState()));
        return builder.build();
    }

    public static ReplicationProtos.SyncReplicationState toSyncReplicationState(SyncReplicationState state) {
        ReplicationProtos.SyncReplicationState.Builder syncReplicationStateBuilder = ReplicationProtos.SyncReplicationState.newBuilder();
        syncReplicationStateBuilder.setState(ReplicationProtos.SyncReplicationState.State.forNumber(state.ordinal()));
        return syncReplicationStateBuilder.build();
    }

    public static SyncReplicationState toSyncReplicationState(ReplicationProtos.SyncReplicationState state) {
        return SyncReplicationState.valueOf(state.getState().getNumber());
    }

    public static ReplicationPeerConfig appendTableCFsToReplicationPeerConfig(Map<TableName, List<String>> tableCfs, ReplicationPeerConfig peerConfig) {
        ReplicationPeerConfigBuilder builder = ReplicationPeerConfig.newBuilder(peerConfig);
        Map<TableName, List<String>> preTableCfs = peerConfig.getTableCFsMap();
        if (preTableCfs == null) {
            builder.setTableCFsMap(tableCfs);
        } else {
            builder.setTableCFsMap(ReplicationPeerConfigUtil.mergeTableCFs(preTableCfs, tableCfs));
        }
        return builder.build();
    }

    public static ReplicationPeerConfig updateReplicationBasePeerConfigs(Configuration conf, ReplicationPeerConfig receivedPeerConfig) {
        ReplicationPeerConfigBuilder copiedPeerConfigBuilder = ReplicationPeerConfig.newBuilder(receivedPeerConfig);
        Map<String, String> receivedPeerConfigMap = receivedPeerConfig.getConfiguration();
        String basePeerConfigs = conf.get(HBASE_REPLICATION_PEER_BASE_CONFIG, "");
        if (basePeerConfigs.length() != 0) {
            Map<String, String> basePeerConfigMap = Splitter.on(';').trimResults().omitEmptyStrings().withKeyValueSeparator("=").split(basePeerConfigs);
            for (Map.Entry<String, String> entry : basePeerConfigMap.entrySet()) {
                String configName = entry.getKey();
                String configValue = entry.getValue();
                if (Strings.isNullOrEmpty(configValue)) {
                    copiedPeerConfigBuilder.removeConfiguration(configName);
                    continue;
                }
                if (receivedPeerConfigMap.getOrDefault(configName, "").equals(configValue)) continue;
                copiedPeerConfigBuilder.putConfiguration(configName, configValue);
            }
        }
        return copiedPeerConfigBuilder.build();
    }

    public static ReplicationPeerConfig appendExcludeTableCFsToReplicationPeerConfig(Map<TableName, List<String>> excludeTableCfs, ReplicationPeerConfig peerConfig) throws ReplicationException {
        if (excludeTableCfs == null) {
            throw new ReplicationException("exclude tableCfs is null");
        }
        ReplicationPeerConfigBuilder builder = ReplicationPeerConfig.newBuilder(peerConfig);
        Map<TableName, List<String>> preExcludeTableCfs = peerConfig.getExcludeTableCFsMap();
        if (preExcludeTableCfs == null) {
            builder.setExcludeTableCFsMap(excludeTableCfs);
        } else {
            builder.setExcludeTableCFsMap(ReplicationPeerConfigUtil.mergeTableCFs(preExcludeTableCfs, excludeTableCfs));
        }
        return builder.build();
    }

    private static Map<TableName, List<String>> mergeTableCFs(Map<TableName, List<String>> preTableCfs, Map<TableName, List<String>> tableCfs) {
        Map<TableName, List<String>> newTableCfs = ReplicationPeerConfigUtil.copyTableCFsMap(preTableCfs);
        for (Map.Entry<TableName, List<String>> entry : tableCfs.entrySet()) {
            TableName table = entry.getKey();
            Collection appendCfs = entry.getValue();
            if (newTableCfs.containsKey(table)) {
                List<String> cfs = newTableCfs.get(table);
                if (cfs == null || appendCfs == null || appendCfs.isEmpty()) {
                    newTableCfs.put(table, null);
                    continue;
                }
                HashSet<String> cfSet = new HashSet<String>(cfs);
                cfSet.addAll(appendCfs);
                newTableCfs.put(table, Lists.newArrayList(cfSet));
                continue;
            }
            if (appendCfs == null || appendCfs.isEmpty()) {
                newTableCfs.put(table, null);
                continue;
            }
            newTableCfs.put(table, Lists.newArrayList(appendCfs));
        }
        return newTableCfs;
    }

    private static Map<TableName, List<String>> copyTableCFsMap(Map<TableName, List<String>> preTableCfs) {
        HashMap<TableName, List<String>> newTableCfs = new HashMap<TableName, List<String>>();
        preTableCfs.forEach((table, cfs) -> {
            List cfr_ignored_0 = newTableCfs.put((TableName)table, cfs != null ? Lists.newArrayList(cfs) : null);
        });
        return newTableCfs;
    }

    public static ReplicationPeerConfig removeTableCFsFromReplicationPeerConfig(Map<TableName, List<String>> tableCfs, ReplicationPeerConfig peerConfig, String id) throws ReplicationException {
        Map<TableName, List<String>> preTableCfs = peerConfig.getTableCFsMap();
        if (preTableCfs == null) {
            throw new ReplicationException("Table-Cfs for peer: " + id + " is null");
        }
        Map<TableName, List<String>> newTableCfs = ReplicationPeerConfigUtil.copyTableCFsMap(preTableCfs);
        for (Map.Entry<TableName, List<String>> entry : tableCfs.entrySet()) {
            TableName table = entry.getKey();
            Collection removeCfs = entry.getValue();
            if (newTableCfs.containsKey(table)) {
                List<String> cfs = newTableCfs.get(table);
                if (cfs == null && (removeCfs == null || removeCfs.isEmpty())) {
                    newTableCfs.remove(table);
                    continue;
                }
                if (cfs != null && removeCfs != null && !removeCfs.isEmpty()) {
                    HashSet<String> cfSet = new HashSet<String>(cfs);
                    cfSet.removeAll(removeCfs);
                    if (cfSet.isEmpty()) {
                        newTableCfs.remove(table);
                        continue;
                    }
                    newTableCfs.put(table, Lists.newArrayList(cfSet));
                    continue;
                }
                if (cfs == null && removeCfs != null && !removeCfs.isEmpty()) {
                    throw new ReplicationException("Cannot remove cf of table: " + table + " which doesn't specify cfs from table-cfs config in peer: " + id);
                }
                if (cfs == null || removeCfs != null && !removeCfs.isEmpty()) continue;
                throw new ReplicationException("Cannot remove table: " + table + " which has specified cfs from table-cfs config in peer: " + id);
            }
            throw new ReplicationException("No table: " + table + " in table-cfs config of peer: " + id);
        }
        ReplicationPeerConfigBuilder builder = ReplicationPeerConfig.newBuilder(peerConfig);
        builder.setTableCFsMap(newTableCfs);
        return builder.build();
    }

    public static ReplicationPeerConfig removeExcludeTableCFsFromReplicationPeerConfig(Map<TableName, List<String>> excludeTableCfs, ReplicationPeerConfig peerConfig, String id) throws ReplicationException {
        if (excludeTableCfs == null) {
            throw new ReplicationException("exclude tableCfs is null");
        }
        Map<TableName, List<String>> preExcludeTableCfs = peerConfig.getExcludeTableCFsMap();
        if (preExcludeTableCfs == null) {
            throw new ReplicationException("exclude-Table-Cfs for peer: " + id + " is null");
        }
        Map<TableName, List<String>> newExcludeTableCfs = ReplicationPeerConfigUtil.copyTableCFsMap(preExcludeTableCfs);
        for (Map.Entry<TableName, List<String>> entry : excludeTableCfs.entrySet()) {
            TableName table = entry.getKey();
            Collection removeCfs = entry.getValue();
            if (newExcludeTableCfs.containsKey(table)) {
                List<String> cfs = newExcludeTableCfs.get(table);
                if (cfs == null && (removeCfs == null || removeCfs.isEmpty())) {
                    newExcludeTableCfs.remove(table);
                    continue;
                }
                if (cfs != null && removeCfs != null && !removeCfs.isEmpty()) {
                    HashSet<String> cfSet = new HashSet<String>(cfs);
                    cfSet.removeAll(removeCfs);
                    if (cfSet.isEmpty()) {
                        newExcludeTableCfs.remove(table);
                        continue;
                    }
                    newExcludeTableCfs.put(table, Lists.newArrayList(cfSet));
                    continue;
                }
                if (cfs == null && removeCfs != null && !removeCfs.isEmpty()) {
                    throw new ReplicationException("Cannot remove cf of table: " + table + " which doesn't specify cfs from exclude-table-cfs config in peer: " + id);
                }
                if (cfs == null || removeCfs != null && !removeCfs.isEmpty()) continue;
                throw new ReplicationException("Cannot remove table: " + table + " which has specified cfs from exclude-table-cfs config in peer: " + id);
            }
            throw new ReplicationException("No table: " + table + " in exclude-table-cfs config of peer: " + id);
        }
        ReplicationPeerConfigBuilder builder = ReplicationPeerConfig.newBuilder(peerConfig);
        builder.setExcludeTableCFsMap(newExcludeTableCfs);
        return builder.build();
    }

    public static Configuration getPeerClusterConfiguration(Configuration conf, ReplicationPeerDescription peer) throws IOException {
        Configuration otherConf;
        ReplicationPeerConfig peerConfig = peer.getPeerConfig();
        try {
            otherConf = HBaseConfiguration.createClusterConf(conf, peerConfig.getClusterKey());
        }
        catch (IOException e) {
            throw new IOException("Can't get peer configuration for peerId=" + peer.getPeerId(), e);
        }
        if (!peerConfig.getConfiguration().isEmpty()) {
            CompoundConfiguration compound = new CompoundConfiguration();
            compound.add(otherConf);
            compound.addStringMap(peerConfig.getConfiguration());
            return compound;
        }
        return otherConf;
    }
}

