/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.AsyncClusterConnection;
import org.apache.hadoop.hbase.client.AsyncClusterConnectionImpl;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.ConnectionRegistryEndpoint;
import org.apache.hadoop.hbase.client.ConnectionRegistryFactory;
import org.apache.hadoop.hbase.client.ShortCircuitConnectionRegistry;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class ClusterConnectionFactory {
    public static final String HBASE_SERVER_CLUSTER_CONNECTION_IMPL = "hbase.server.cluster.connection.impl";

    private ClusterConnectionFactory() {
    }

    private static AsyncClusterConnection createAsyncClusterConnection(Configuration conf, ConnectionRegistry registry, SocketAddress localAddress, User user) throws IOException {
        String clusterId = FutureUtils.get(registry.getClusterId());
        Class clazz = conf.getClass(HBASE_SERVER_CLUSTER_CONNECTION_IMPL, AsyncClusterConnectionImpl.class, AsyncClusterConnection.class);
        try {
            return user.runAs(() -> (AsyncClusterConnection)ReflectionUtils.newInstance(clazz, conf, registry, clusterId, localAddress, user));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static AsyncClusterConnection createAsyncClusterConnection(Configuration conf, SocketAddress localAddress, User user) throws IOException {
        return ClusterConnectionFactory.createAsyncClusterConnection(conf, ConnectionRegistryFactory.getRegistry(conf), localAddress, user);
    }

    public static AsyncClusterConnection createAsyncClusterConnection(ConnectionRegistryEndpoint endpoint, Configuration conf, SocketAddress localAddress, User user) throws IOException {
        ShortCircuitConnectionRegistry registry = new ShortCircuitConnectionRegistry(endpoint);
        return ClusterConnectionFactory.createAsyncClusterConnection(conf, registry, localAddress, user);
    }
}

