/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.backup.impl.BackupManager;
import org.apache.hadoop.hbase.backup.util.BackupUtils;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.cleaner.BaseLogCleanerDelegate;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.IterableUtils;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.MapUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class BackupLogCleaner
extends BaseLogCleanerDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(BackupLogCleaner.class);
    private boolean stopped = false;
    private Connection conn;

    public void init(Map<String, Object> params) {
        MasterServices master = (MasterServices)MapUtils.getObject(params, (Object)"master");
        if (master != null) {
            this.conn = master.getConnection();
            if (this.getConf() == null) {
                super.setConf(this.conn.getConfiguration());
            }
        }
        if (this.conn == null) {
            try {
                this.conn = ConnectionFactory.createConnection((Configuration)this.getConf());
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to create connection", ioe);
            }
        }
    }

    private Map<Address, Long> getServersToOldestBackupMapping(List<BackupInfo> backups) throws IOException {
        HashMap<Address, Long> serverAddressToLastBackupMap = new HashMap<Address, Long>();
        HashMap<TableName, Long> tableNameBackupInfoMap = new HashMap<TableName, Long>();
        for (BackupInfo backupInfo : backups) {
            for (TableName table : backupInfo.getTables()) {
                tableNameBackupInfoMap.putIfAbsent(table, backupInfo.getStartTs());
                if ((Long)tableNameBackupInfoMap.get(table) > backupInfo.getStartTs()) continue;
                tableNameBackupInfoMap.put(table, backupInfo.getStartTs());
                for (Map.Entry<String, Long> entry : backupInfo.getTableSetTimestampMap().get(table).entrySet()) {
                    serverAddressToLastBackupMap.put(Address.fromString((String)entry.getKey()), entry.getValue());
                }
            }
        }
        return serverAddressToLastBackupMap;
    }

    public Iterable<FileStatus> getDeletableFiles(Iterable<FileStatus> files) {
        Map<Address, Long> addressToLastBackupMap;
        ArrayList<FileStatus> filteredFiles = new ArrayList<FileStatus>();
        if (this.getConf() == null || !BackupManager.isBackupEnabled(this.getConf())) {
            LOG.debug("Backup is not enabled. Check your {} setting", (Object)"hbase.backup.enable");
            return files;
        }
        try (BackupManager backupManager = new BackupManager(this.conn, this.getConf());){
            addressToLastBackupMap = this.getServersToOldestBackupMapping(backupManager.getBackupHistory(true));
        }
        catch (IOException ex) {
            LOG.error("Failed to analyse backup history with exception: {}. Retaining all logs", (Object)ex.getMessage(), (Object)ex);
            return Collections.emptyList();
        }
        for (FileStatus file : files) {
            String fn = file.getPath().getName();
            if (fn.startsWith("pv2-")) {
                filteredFiles.add(file);
                continue;
            }
            try {
                Address walServerAddress = Address.fromString((String)BackupUtils.parseHostNameFromLogFile(file.getPath()));
                long walTimestamp = AbstractFSWALProvider.getTimestamp((String)file.getPath().getName());
                if (addressToLastBackupMap.containsKey(walServerAddress) && addressToLastBackupMap.get(walServerAddress) < walTimestamp) continue;
                filteredFiles.add(file);
            }
            catch (Exception ex) {
                LOG.warn("Error occurred while filtering file: {} with error: {}. Ignoring cleanup of this log", (Object)file.getPath(), (Object)ex.getMessage());
            }
        }
        LOG.info("Total files: {}, Filtered Files: {}", (Object)IterableUtils.size(files), (Object)filteredFiles.size());
        return filteredFiles;
    }

    public void setConf(Configuration config) {
        super.setConf(config);
        if (!config.getBoolean("hbase.backup.enable", false)) {
            LOG.warn("Backup is disabled - allowing all wals to be deleted");
        }
    }

    public void stop(String why) {
        if (!this.stopped) {
            this.stopped = true;
            LOG.info("Stopping BackupLogCleaner");
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }
}

