/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.mapreduce;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupCopyJob;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.backup.BackupType;
import org.apache.hadoop.hbase.backup.impl.BackupManager;
import org.apache.hadoop.hbase.backup.util.BackupUtils;
import org.apache.hadoop.hbase.snapshot.ExportSnapshot;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MapReduceBackupCopyJob
implements BackupCopyJob {
    public static final String NUMBER_OF_LEVELS_TO_PRESERVE_KEY = "num.levels.preserve";
    private static final Logger LOG = LoggerFactory.getLogger(MapReduceBackupCopyJob.class);
    private Configuration conf;
    private float progressDone = 0.1f;
    private long bytesCopied = 0L;
    private static float INIT_PROGRESS = 0.1f;
    private float subTaskPercntgInWholeTask = 1.0f;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public float getSubTaskPercntgInWholeTask() {
        return this.subTaskPercntgInWholeTask;
    }

    public void setSubTaskPercntgInWholeTask(float subTaskPercntgInWholeTask) {
        this.subTaskPercntgInWholeTask = subTaskPercntgInWholeTask;
    }

    static void updateProgress(BackupInfo backupInfo, BackupManager backupManager, int newProgress, long bytesCopied) throws IOException {
        String backupProgressData = newProgress + "%";
        backupInfo.setProgress(newProgress);
        backupManager.updateBackupInfo(backupInfo);
        LOG.debug("Backup progress data \"" + backupProgressData + "\" has been updated to backup system table for " + backupInfo.getBackupId());
    }

    @Override
    public int copy(BackupInfo context, BackupManager backupManager, Configuration conf, BackupType copyType, String[] options) throws IOException {
        int res = 0;
        try {
            if (copyType == BackupType.FULL) {
                SnapshotCopy snapshotCp = new SnapshotCopy(context, context.getTableBySnapshot(options[1]));
                LOG.debug("Doing SNAPSHOT_COPY");
                snapshotCp.setConf(new Configuration(conf));
                res = snapshotCp.run(options);
            } else if (copyType == BackupType.INCREMENTAL) {
                LOG.debug("Doing COPY_TYPE_DISTCP");
                this.setSubTaskPercntgInWholeTask(1.0f);
                BackupDistCp distcp = new BackupDistCp(new Configuration(conf), null, context, backupManager);
                LOG.debug("DistCp options: " + Arrays.toString(options));
                Path dest = new Path(options[options.length - 1]);
                String[] newOptions = new String[options.length + 1];
                System.arraycopy(options, 0, newOptions, 1, options.length);
                newOptions[0] = "-async";
                FileSystem destfs = dest.getFileSystem(conf);
                if (!destfs.exists(dest)) {
                    destfs.mkdirs(dest);
                }
                res = distcp.run(newOptions);
            }
            return res;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void cancel(String jobId) throws IOException {
        JobID id = JobID.forName((String)jobId);
        Cluster cluster = new Cluster(this.getConf());
        try {
            Job job = cluster.getJob(id);
            if (job == null) {
                LOG.error("No job found for " + id);
                return;
            }
            if (job.isComplete() || job.isRetired()) {
                return;
            }
            job.killJob();
            LOG.debug("Killed copy job " + id);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    class BackupDistCp
    extends DistCp {
        private BackupInfo backupInfo;
        private BackupManager backupManager;

        public BackupDistCp(Configuration conf, DistCpOptions options, BackupInfo backupInfo, BackupManager backupManager) throws Exception {
            super(conf, options);
            this.backupInfo = backupInfo;
            this.backupManager = backupManager;
        }

        public Job execute() throws Exception {
            Class<DistCp> classDistCp = DistCp.class;
            Method methodCleanup = classDistCp.getDeclaredMethod("cleanup", new Class[0]);
            Field fieldInputOptions = this.getInputOptionsField(classDistCp);
            Field fieldSubmitted = classDistCp.getDeclaredField("submitted");
            methodCleanup.setAccessible(true);
            fieldInputOptions.setAccessible(true);
            fieldSubmitted.setAccessible(true);
            assert (fieldInputOptions.get((Object)this) != null);
            Job job = null;
            try {
                String newProgressStr;
                BigDecimal progressData;
                float newProgress;
                List<Path> srcs = this.getSourcePaths(fieldInputOptions);
                long totalSrcLgth = 0L;
                for (Path aSrc : srcs) {
                    totalSrcLgth += BackupUtils.getFilesLength(aSrc.getFileSystem(super.getConf()), aSrc);
                }
                job = super.execute();
                int progressReportFreq = MapReduceBackupCopyJob.this.getConf().getInt("hbase.backup.progressreport.frequency", 500);
                float lastProgress = MapReduceBackupCopyJob.this.progressDone;
                while (!job.isComplete()) {
                    newProgress = MapReduceBackupCopyJob.this.progressDone + job.mapProgress() * MapReduceBackupCopyJob.this.subTaskPercntgInWholeTask * (1.0f - INIT_PROGRESS);
                    if (newProgress > lastProgress) {
                        progressData = new BigDecimal(newProgress * 100.0f).setScale(1, 4);
                        newProgressStr = progressData + "%";
                        LOG.info("Progress: " + newProgressStr);
                        MapReduceBackupCopyJob.updateProgress(this.backupInfo, this.backupManager, progressData.intValue(), MapReduceBackupCopyJob.this.bytesCopied);
                        LOG.debug("Backup progress data updated to backup system table: \"Progress: " + newProgressStr + ".\"");
                        lastProgress = newProgress;
                    }
                    Thread.sleep(progressReportFreq);
                }
                newProgress = MapReduceBackupCopyJob.this.progressDone + job.mapProgress() * MapReduceBackupCopyJob.this.subTaskPercntgInWholeTask * (1.0f - INIT_PROGRESS);
                progressData = new BigDecimal(newProgress * 100.0f).setScale(1, 4);
                newProgressStr = progressData + "%";
                LOG.info("Progress: " + newProgressStr + " subTask: " + MapReduceBackupCopyJob.this.subTaskPercntgInWholeTask + " mapProgress: " + job.mapProgress());
                MapReduceBackupCopyJob.this.progressDone = newProgress;
                MapReduceBackupCopyJob.this.bytesCopied = MapReduceBackupCopyJob.this.bytesCopied + totalSrcLgth;
                MapReduceBackupCopyJob.updateProgress(this.backupInfo, this.backupManager, progressData.intValue(), MapReduceBackupCopyJob.this.bytesCopied);
                LOG.debug("Backup progress data updated to backup system table: \"Progress: " + newProgressStr + " - " + MapReduceBackupCopyJob.this.bytesCopied + " bytes copied.\"");
            }
            catch (Throwable t) {
                LOG.error(t.toString(), t);
                throw t;
            }
            String jobID = job.getJobID().toString();
            job.getConfiguration().set("distcp.job.id", jobID);
            LOG.debug("DistCp job-id: " + jobID + " completed: " + job.isComplete() + " " + job.isSuccessful());
            Counters ctrs = job.getCounters();
            LOG.debug(Objects.toString(ctrs));
            if (job.isComplete() && !job.isSuccessful()) {
                throw new Exception("DistCp job-id: " + jobID + " failed");
            }
            return job;
        }

        private Field getInputOptionsField(Class<?> classDistCp) throws IOException {
            Field f = null;
            try {
                f = classDistCp.getDeclaredField("inputOptions");
            }
            catch (Exception e) {
                try {
                    f = classDistCp.getDeclaredField("context");
                }
                catch (NoSuchFieldException | SecurityException e1) {
                    throw new IOException(e1);
                }
            }
            return f;
        }

        private List<Path> getSourcePaths(Field fieldInputOptions) throws IOException {
            try {
                Object options = fieldInputOptions.get((Object)this);
                if (options instanceof DistCpOptions) {
                    return ((DistCpOptions)options).getSourcePaths();
                }
                Class<?> classContext = Class.forName("org.apache.hadoop.tools.DistCpContext");
                Method methodGetSourcePaths = classContext.getDeclaredMethod("getSourcePaths", new Class[0]);
                methodGetSourcePaths.setAccessible(true);
                return (List)methodGetSourcePaths.invoke(options, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IOException(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Path createInputFileListing(Job job) throws IOException {
            if (MapReduceBackupCopyJob.this.conf.get(MapReduceBackupCopyJob.NUMBER_OF_LEVELS_TO_PRESERVE_KEY) == null) {
                return super.createInputFileListing(job);
            }
            long totalBytesExpected = 0L;
            int totalRecords = 0;
            Path fileListingPath = this.getFileListingPath();
            try (SequenceFile.Writer writer = this.getWriter(fileListingPath);){
                List<Path> srcFiles = this.getSourceFiles();
                if (srcFiles.size() == 0) {
                    Path path = fileListingPath;
                    return path;
                }
                totalRecords = srcFiles.size();
                FileSystem fs = srcFiles.get(0).getFileSystem(MapReduceBackupCopyJob.this.conf);
                for (Path path : srcFiles) {
                    FileStatus fst = fs.getFileStatus(path);
                    totalBytesExpected += fst.getLen();
                    Text key = this.getKey(path);
                    writer.append((Writable)key, (Writable)new CopyListingFileStatus(fst));
                }
                writer.close();
                Configuration cfg = job.getConfiguration();
                cfg.setLong("mapred.total.bytes.expected", totalBytesExpected);
                cfg.set("distcp.listing.file.path", fileListingPath.toString());
                cfg.setLong("mapred.number.of.records", (long)totalRecords);
                return fileListingPath;
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IOException(e);
            }
        }

        private Text getKey(Path path) {
            int level = MapReduceBackupCopyJob.this.conf.getInt(MapReduceBackupCopyJob.NUMBER_OF_LEVELS_TO_PRESERVE_KEY, 1);
            int count = 0;
            String relPath = "";
            while (count++ < level) {
                relPath = "/" + path.getName() + relPath;
                path = path.getParent();
            }
            return new Text(relPath);
        }

        private List<Path> getSourceFiles() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IOException {
            Field options = null;
            try {
                options = DistCp.class.getDeclaredField("inputOptions");
            }
            catch (NoSuchFieldException | SecurityException e) {
                options = DistCp.class.getDeclaredField("context");
            }
            options.setAccessible(true);
            return this.getSourcePaths(options);
        }

        private SequenceFile.Writer getWriter(Path pathToListFile) throws IOException {
            FileSystem fs = pathToListFile.getFileSystem(MapReduceBackupCopyJob.this.conf);
            fs.delete(pathToListFile, false);
            return SequenceFile.createWriter((Configuration)MapReduceBackupCopyJob.this.conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)pathToListFile), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(CopyListingFileStatus.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.NONE)});
        }
    }

    static class SnapshotCopy
    extends ExportSnapshot {
        private BackupInfo backupInfo;
        private TableName table;

        public SnapshotCopy(BackupInfo backupInfo, TableName table) {
            this.backupInfo = backupInfo;
            this.table = table;
        }

        public TableName getTable() {
            return this.table;
        }

        public BackupInfo getBackupInfo() {
            return this.backupInfo;
        }
    }
}

