/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.impl;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupAdmin;
import org.apache.hadoop.hbase.backup.BackupClientFactory;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.backup.BackupMergeJob;
import org.apache.hadoop.hbase.backup.BackupRequest;
import org.apache.hadoop.hbase.backup.BackupRestoreFactory;
import org.apache.hadoop.hbase.backup.BackupType;
import org.apache.hadoop.hbase.backup.HBackupFileSystem;
import org.apache.hadoop.hbase.backup.RestoreRequest;
import org.apache.hadoop.hbase.backup.impl.BackupManifest;
import org.apache.hadoop.hbase.backup.impl.BackupSystemTable;
import org.apache.hadoop.hbase.backup.impl.RestoreTablesClient;
import org.apache.hadoop.hbase.backup.impl.TableBackupClient;
import org.apache.hadoop.hbase.backup.util.BackupSet;
import org.apache.hadoop.hbase.backup.util.BackupUtils;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class BackupAdminImpl
implements BackupAdmin {
    public static final String CHECK_OK = "Checking backup images: OK";
    public static final String CHECK_FAILED = "Checking backup images: Failed. Some dependencies are missing for restore";
    private static final Logger LOG = LoggerFactory.getLogger(BackupAdminImpl.class);
    private final Connection conn;

    public BackupAdminImpl(Connection conn) {
        this.conn = conn;
    }

    @Override
    public void close() {
    }

    @Override
    public BackupInfo getBackupInfo(String backupId) throws IOException {
        try (BackupSystemTable table = new BackupSystemTable(this.conn);){
            BackupInfo backupInfo;
            if (backupId == null) {
                ArrayList<BackupInfo> recentSessions = table.getBackupInfos(BackupInfo.BackupState.RUNNING);
                if (recentSessions.isEmpty()) {
                    LOG.warn("No ongoing sessions found.");
                    BackupInfo backupInfo2 = null;
                    return backupInfo2;
                }
                BackupInfo backupInfo3 = recentSessions.get(0);
                return backupInfo3;
            }
            BackupInfo backupInfo4 = backupInfo = table.readBackupInfo(backupId);
            return backupInfo4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteBackups(String[] backupIds) throws IOException {
        int totalDeleted = 0;
        HashMap<String, HashSet<TableName>> allTablesMap = new HashMap<String, HashSet<TableName>>();
        try (BackupSystemTable sysTable = new BackupSystemTable(this.conn);){
            boolean deleteSessionStarted;
            try {
                sysTable.startBackupExclusiveOperation();
                deleteSessionStarted = true;
            }
            catch (IOException e) {
                LOG.warn("You can not run delete command while active backup session is in progress. \nIf there is no active backup session running, run backup repair utility to restore \nbackup system integrity.");
                int n = -1;
                if (sysTable != null) {
                    if (var7_5 != null) {
                        try {
                            sysTable.close();
                        }
                        catch (Throwable throwable) {
                            var7_5.addSuppressed(throwable);
                        }
                    } else {
                        sysTable.close();
                    }
                }
                return n;
            }
            ArrayList<BackupInfo> list = sysTable.getBackupInfos(BackupInfo.BackupState.RUNNING);
            if (list.size() != 0) {
                LOG.warn("Failed backup session found. Run backup repair tool first.");
                int n = -1;
                return n;
            }
            sysTable.startDeleteOperation(backupIds);
            if (!BackupSystemTable.snapshotExists(this.conn)) {
                BackupSystemTable.snapshot(this.conn);
            } else {
                LOG.warn("Backup system table snapshot exists");
            }
            boolean snapshotDone = true;
            try {
                for (int i = 0; i < backupIds.length; ++i) {
                    BackupInfo info = sysTable.readBackupInfo(backupIds[i]);
                    if (info == null) continue;
                    String rootDir = info.getBackupRootDir();
                    HashSet<TableName> allTables = (HashSet<TableName>)allTablesMap.get(rootDir);
                    if (allTables == null) {
                        allTables = new HashSet<TableName>();
                        allTablesMap.put(rootDir, allTables);
                    }
                    allTables.addAll(info.getTableNames());
                    totalDeleted += this.deleteBackup(backupIds[i], sysTable);
                }
                this.finalizeDelete(allTablesMap, sysTable);
                sysTable.finishDeleteOperation();
                BackupSystemTable.deleteSnapshot(this.conn);
            }
            catch (IOException e) {
                if (snapshotDone) {
                    if (BackupSystemTable.snapshotExists(this.conn)) {
                        BackupSystemTable.restoreFromSnapshot(this.conn);
                        BackupSystemTable.deleteSnapshot(this.conn);
                        LOG.error("Delete operation failed, please run backup repair utility to restore backup system integrity", (Throwable)e);
                        throw e;
                    }
                    LOG.warn("Delete operation succeeded, there were some errors: ", (Throwable)e);
                }
            }
            finally {
                if (deleteSessionStarted) {
                    sysTable.finishBackupExclusiveOperation();
                }
            }
        }
        return totalDeleted;
    }

    private void finalizeDelete(Map<String, HashSet<TableName>> tablesMap, BackupSystemTable table) throws IOException {
        for (String backupRoot : tablesMap.keySet()) {
            Set<TableName> incrTableSet = table.getIncrementalBackupTableSet(backupRoot);
            Map<TableName, ArrayList<BackupInfo>> tableMap = table.getBackupHistoryForTableSet(incrTableSet, backupRoot);
            for (Map.Entry<TableName, ArrayList<BackupInfo>> entry : tableMap.entrySet()) {
                if (entry.getValue() != null) continue;
                incrTableSet.remove(entry.getKey());
            }
            if (!incrTableSet.isEmpty()) {
                table.addIncrementalBackupTableSet(incrTableSet, backupRoot);
                continue;
            }
            table.deleteIncrementalBackupTableSet(backupRoot);
        }
    }

    private int deleteBackup(String backupId, BackupSystemTable sysTable) throws IOException {
        BackupInfo backupInfo = sysTable.readBackupInfo(backupId);
        int totalDeleted = 0;
        if (backupInfo != null) {
            LOG.info("Deleting backup " + backupInfo.getBackupId() + " ...");
            BackupUtils.cleanupBackupData(backupInfo, this.conn.getConfiguration());
            List<TableName> tables = backupInfo.getTableNames();
            long startTime = backupInfo.getStartTs();
            for (TableName tn : tables) {
                boolean isLastBackupSession = this.isLastBackupSession(sysTable, tn, startTime);
                if (isLastBackupSession) continue;
                List<BackupInfo> affectedBackups = this.getAffectedBackupSessions(backupInfo, tn, sysTable);
                for (BackupInfo info : affectedBackups) {
                    if (info.equals(backupInfo)) continue;
                    this.removeTableFromBackupImage(info, tn, sysTable);
                }
            }
            Map<byte[], String> map = sysTable.readBulkLoadedFiles(backupId);
            FileSystem fs = FileSystem.get((Configuration)this.conn.getConfiguration());
            boolean success = true;
            int numDeleted = 0;
            for (String f : map.values()) {
                Path p = new Path(f);
                try {
                    LOG.debug("Delete backup info " + p + " for " + backupInfo.getBackupId());
                    if (!fs.delete(p)) {
                        if (!fs.exists(p)) continue;
                        LOG.warn(f + " was not deleted");
                        success = false;
                        continue;
                    }
                    ++numDeleted;
                }
                catch (IOException ioe) {
                    LOG.warn(f + " was not deleted", (Throwable)ioe);
                    success = false;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(numDeleted + " bulk loaded files out of " + map.size() + " were deleted");
            }
            if (success) {
                sysTable.deleteBulkLoadedRows(new ArrayList<byte[]>(map.keySet()));
            }
            sysTable.deleteBackupInfo(backupInfo.getBackupId());
            LOG.info("Delete backup " + backupInfo.getBackupId() + " completed.");
            ++totalDeleted;
        } else {
            LOG.warn("Delete backup failed: no information found for backupID=" + backupId);
        }
        return totalDeleted;
    }

    private void removeTableFromBackupImage(BackupInfo info, TableName tn, BackupSystemTable sysTable) throws IOException {
        List<TableName> tables = info.getTableNames();
        LOG.debug("Remove " + tn + " from " + info.getBackupId() + " tables=" + info.getTableListAsString());
        if (tables.contains(tn)) {
            tables.remove(tn);
            if (tables.isEmpty()) {
                LOG.debug("Delete backup info " + info.getBackupId());
                sysTable.deleteBackupInfo(info.getBackupId());
                BackupUtils.cleanupBackupData(info, this.conn.getConfiguration());
            } else {
                info.setTables(tables);
                sysTable.updateBackupInfo(info);
                this.cleanupBackupDir(info, tn, this.conn.getConfiguration());
            }
        }
    }

    private List<BackupInfo> getAffectedBackupSessions(BackupInfo backupInfo, TableName tn, BackupSystemTable table) throws IOException {
        LOG.debug("GetAffectedBackupInfos for: " + backupInfo.getBackupId() + " table=" + tn);
        long ts = backupInfo.getStartTs();
        ArrayList<BackupInfo> list = new ArrayList<BackupInfo>();
        List<BackupInfo> history = table.getBackupHistory(backupInfo.getBackupRootDir());
        for (BackupInfo info : history) {
            if (info.getStartTs() == ts) break;
            List<TableName> tables = info.getTableNames();
            if (!tables.contains(tn)) continue;
            BackupType bt = info.getType();
            if (bt == BackupType.FULL) {
                list.clear();
                continue;
            }
            LOG.debug("GetAffectedBackupInfos for: " + backupInfo.getBackupId() + " table=" + tn + " added " + info.getBackupId() + " tables=" + info.getTableListAsString());
            list.add(info);
        }
        return list;
    }

    private void cleanupBackupDir(BackupInfo backupInfo, TableName table, Configuration conf) throws IOException {
        try {
            Path targetDirPath;
            String targetDir = backupInfo.getBackupRootDir();
            if (targetDir == null) {
                LOG.warn("No target directory specified for " + backupInfo.getBackupId());
                return;
            }
            FileSystem outputFs = FileSystem.get((URI)new Path(backupInfo.getBackupRootDir()).toUri(), (Configuration)conf);
            if (outputFs.delete(targetDirPath = new Path(BackupUtils.getTableBackupDir(backupInfo.getBackupRootDir(), backupInfo.getBackupId(), table)), true)) {
                LOG.info("Cleaning up backup data at " + targetDirPath.toString() + " done.");
            } else {
                LOG.info("No data has been found in " + targetDirPath.toString() + ".");
            }
        }
        catch (IOException e1) {
            LOG.error("Cleaning up backup data of " + backupInfo.getBackupId() + " for table " + table + "at " + backupInfo.getBackupRootDir() + " failed due to " + e1.getMessage() + ".");
            throw e1;
        }
    }

    private boolean isLastBackupSession(BackupSystemTable table, TableName tn, long startTime) throws IOException {
        List<BackupInfo> history = table.getBackupHistory();
        for (BackupInfo info : history) {
            List<TableName> tables = info.getTableNames();
            if (!tables.contains(tn)) continue;
            return info.getStartTs() <= startTime;
        }
        return false;
    }

    @Override
    public List<BackupInfo> getHistory(int n) throws IOException {
        try (BackupSystemTable table = new BackupSystemTable(this.conn);){
            List<BackupInfo> history = table.getBackupHistory();
            if (history.size() <= n) {
                List<BackupInfo> list = history;
                return list;
            }
            ArrayList<BackupInfo> list = new ArrayList<BackupInfo>();
            for (int i = 0; i < n; ++i) {
                list.add(history.get(i));
            }
            ArrayList<BackupInfo> arrayList = list;
            return arrayList;
        }
    }

    @Override
    public List<BackupInfo> getHistory(int n, BackupInfo.Filter ... filters) throws IOException {
        if (filters.length == 0) {
            return this.getHistory(n);
        }
        try (BackupSystemTable table = new BackupSystemTable(this.conn);){
            List<BackupInfo> history = table.getBackupHistory();
            ArrayList<BackupInfo> result = new ArrayList<BackupInfo>();
            for (BackupInfo bi : history) {
                if (result.size() == n) break;
                boolean passed = true;
                for (int i = 0; i < filters.length; ++i) {
                    if (filters[i].apply(bi)) continue;
                    passed = false;
                    break;
                }
                if (!passed) continue;
                result.add(bi);
            }
            ArrayList<BackupInfo> arrayList = result;
            return arrayList;
        }
    }

    @Override
    public List<BackupSet> listBackupSets() throws IOException {
        try (BackupSystemTable table = new BackupSystemTable(this.conn);){
            List<String> list = table.listBackupSets();
            ArrayList<BackupSet> bslist = new ArrayList<BackupSet>();
            for (String s : list) {
                List<TableName> tables = table.describeBackupSet(s);
                if (tables == null) continue;
                bslist.add(new BackupSet(s, tables));
            }
            ArrayList<BackupSet> arrayList = bslist;
            return arrayList;
        }
    }

    @Override
    public BackupSet getBackupSet(String name) throws IOException {
        try (BackupSystemTable table = new BackupSystemTable(this.conn);){
            List<TableName> list = table.describeBackupSet(name);
            if (list == null) {
                BackupSet backupSet = null;
                return backupSet;
            }
            BackupSet backupSet = new BackupSet(name, list);
            return backupSet;
        }
    }

    @Override
    public boolean deleteBackupSet(String name) throws IOException {
        try (BackupSystemTable table = new BackupSystemTable(this.conn);){
            if (table.describeBackupSet(name) == null) {
                boolean bl = false;
                return bl;
            }
            table.deleteBackupSet(name);
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public void addToBackupSet(String name, TableName[] tables) throws IOException {
        Object[] tableNames = new String[tables.length];
        try (BackupSystemTable table = new BackupSystemTable(this.conn);
             Admin admin = this.conn.getAdmin();){
            for (int i = 0; i < tables.length; ++i) {
                tableNames[i] = tables[i].getNameAsString();
                if (admin.tableExists(TableName.valueOf((String)tableNames[i]))) continue;
                throw new IOException("Cannot add " + (String)tableNames[i] + " because it doesn't exist");
            }
            table.addToBackupSet(name, (String[])tableNames);
            LOG.info("Added tables [" + org.apache.commons.lang3.StringUtils.join((Object[])tableNames, (String)" ") + "] to '" + name + "' backup set");
        }
    }

    @Override
    public void removeFromBackupSet(String name, TableName[] tables) throws IOException {
        LOG.info("Removing tables [" + org.apache.commons.lang3.StringUtils.join((Object[])tables, (String)" ") + "] from '" + name + "'");
        try (BackupSystemTable table = new BackupSystemTable(this.conn);){
            table.removeFromBackupSet(name, this.toStringArray(tables));
            LOG.info("Removing tables [" + org.apache.commons.lang3.StringUtils.join((Object[])tables, (String)" ") + "] from '" + name + "' completed.");
        }
    }

    private String[] toStringArray(TableName[] list) {
        String[] arr = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            arr[i] = list[i].toString();
        }
        return arr;
    }

    @Override
    public void restore(RestoreRequest request) throws IOException {
        if (request.isCheck()) {
            HashMap<TableName, BackupManifest> backupManifestMap = new HashMap<TableName, BackupManifest>();
            Path rootPath = new Path(request.getBackupRootDir());
            String backupId = request.getBackupId();
            TableName[] sTableArray = request.getFromTables();
            HBackupFileSystem.checkImageManifestExist(backupManifestMap, sTableArray, this.conn.getConfiguration(), rootPath, backupId);
            if (BackupUtils.validate(backupManifestMap, this.conn.getConfiguration())) {
                LOG.info(CHECK_OK);
            } else {
                LOG.error(CHECK_FAILED);
            }
            return;
        }
        new RestoreTablesClient(this.conn, request).execute();
    }

    @Override
    public String backupTables(BackupRequest request) throws IOException {
        TableBackupClient client;
        BackupType type = request.getBackupType();
        String targetRootDir = request.getTargetRootDir();
        List<Object> tableList = request.getTableList();
        String backupId = "backup_" + EnvironmentEdgeManager.currentTime();
        if (type == BackupType.INCREMENTAL) {
            Set<TableName> incrTableSet;
            try (BackupSystemTable table = new BackupSystemTable(this.conn);){
                incrTableSet = table.getIncrementalBackupTableSet(targetRootDir);
            }
            if (incrTableSet.isEmpty()) {
                String msg = "Incremental backup table set contains no tables. You need to run full backup first " + (tableList != null ? "on " + org.apache.commons.lang3.StringUtils.join((Iterable)tableList, (String)",") : "");
                throw new IOException(msg);
            }
            if (tableList != null) {
                tableList.removeAll(incrTableSet);
                if (!tableList.isEmpty()) {
                    String extraTables = org.apache.commons.lang3.StringUtils.join((Iterable)tableList, (String)",");
                    String msg = "Some tables (" + extraTables + ") haven't gone through full backup. Perform full backup on " + extraTables + " first, then retry the command";
                    throw new IOException(msg);
                }
            }
            tableList = Lists.newArrayList((Iterable)incrTableSet);
        }
        if (tableList != null && !tableList.isEmpty()) {
            Object targetTableBackupDir;
            for (BackupSystemTable table : tableList) {
                targetTableBackupDir = HBackupFileSystem.getTableBackupDir(targetRootDir, backupId, (TableName)table);
                Path targetTableBackupDirPath = new Path((String)targetTableBackupDir);
                FileSystem outputFs = FileSystem.get((URI)targetTableBackupDirPath.toUri(), (Configuration)this.conn.getConfiguration());
                if (outputFs.exists(targetTableBackupDirPath)) {
                    throw new IOException("Target backup directory " + (String)targetTableBackupDir + " exists already.");
                }
                outputFs.mkdirs(targetTableBackupDirPath);
            }
            ArrayList<TableName> nonExistingTableList = null;
            Admin admin = this.conn.getAdmin();
            targetTableBackupDir = null;
            try {
                for (TableName tableName : tableList) {
                    if (admin.tableExists(tableName)) continue;
                    if (nonExistingTableList == null) {
                        nonExistingTableList = new ArrayList<TableName>();
                    }
                    nonExistingTableList.add(tableName);
                }
            }
            catch (Throwable throwable) {
                targetTableBackupDir = throwable;
                throw throwable;
            }
            finally {
                if (admin != null) {
                    if (targetTableBackupDir != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)targetTableBackupDir).addSuppressed(throwable);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
            if (nonExistingTableList != null) {
                if (type == BackupType.INCREMENTAL) {
                    tableList = this.excludeNonExistingTables(tableList, nonExistingTableList);
                } else {
                    throw new IOException("Non-existing tables found in the table list: " + nonExistingTableList);
                }
            }
        }
        BackupRequest.Builder builder = new BackupRequest.Builder();
        request = builder.withBackupType(request.getBackupType()).withTableList(tableList).withTargetRootDir(request.getTargetRootDir()).withBackupSetName(request.getBackupSetName()).withTotalTasks(request.getTotalTasks()).withBandwidthPerTasks((int)request.getBandwidth()).build();
        try {
            client = BackupClientFactory.create(this.conn, backupId, request);
        }
        catch (IOException e) {
            LOG.error("There is an active session already running");
            throw e;
        }
        client.execute();
        return backupId;
    }

    private List<TableName> excludeNonExistingTables(List<TableName> tableList, List<TableName> nonExistingTableList) {
        for (TableName table : nonExistingTableList) {
            tableList.remove(table);
        }
        return tableList;
    }

    @Override
    public void mergeBackups(String[] backupIds) throws IOException {
        try (BackupSystemTable sysTable = new BackupSystemTable(this.conn);){
            this.checkIfValidForMerge(backupIds, sysTable);
            BackupMergeJob job = BackupRestoreFactory.getBackupMergeJob(this.conn.getConfiguration());
            job.run(backupIds);
        }
    }

    private void checkIfValidForMerge(String[] backupIds, BackupSystemTable table) throws IOException {
        String backupRoot = null;
        HashSet<TableName> allTables = new HashSet<TableName>();
        HashSet<String> allBackups = new HashSet<String>();
        long minTime = Long.MAX_VALUE;
        long maxTime = Long.MIN_VALUE;
        for (String backupId : backupIds) {
            BackupInfo bInfo = table.readBackupInfo(backupId);
            if (bInfo == null) {
                String msg = "Backup session " + backupId + " not found";
                throw new IOException(msg);
            }
            if (backupRoot == null) {
                backupRoot = bInfo.getBackupRootDir();
            } else if (!bInfo.getBackupRootDir().equals(backupRoot)) {
                throw new IOException("Found different backup destinations in a list of a backup sessions \n1. " + backupRoot + "\n2. " + bInfo.getBackupRootDir());
            }
            if (bInfo.getType() == BackupType.FULL) {
                throw new IOException("FULL backup image can not be merged for: \n" + bInfo);
            }
            if (bInfo.getState() != BackupInfo.BackupState.COMPLETE) {
                throw new IOException("Backup image " + backupId + " can not be merged becuase of its state: " + (Object)((Object)bInfo.getState()));
            }
            allBackups.add(backupId);
            allTables.addAll(bInfo.getTableNames());
            long time = bInfo.getStartTs();
            if (time < minTime) {
                minTime = time;
            }
            if (time <= maxTime) continue;
            maxTime = time;
        }
        long startRangeTime = minTime;
        long endRangeTime = maxTime;
        String backupDest = backupRoot;
        BackupInfo.Filter destinationFilter = info -> info.getBackupRootDir().equals(backupDest);
        BackupInfo.Filter timeRangeFilter = info -> {
            long time = info.getStartTs();
            return time >= startRangeTime && time <= endRangeTime;
        };
        BackupInfo.Filter tableFilter = info -> {
            List<TableName> tables = info.getTableNames();
            return !Collections.disjoint(allTables, tables);
        };
        BackupInfo.Filter typeFilter = info -> info.getType() == BackupType.INCREMENTAL;
        BackupInfo.Filter stateFilter = info -> info.getState() == BackupInfo.BackupState.COMPLETE;
        List<BackupInfo> allInfos = table.getBackupHistory(-1, destinationFilter, timeRangeFilter, tableFilter, typeFilter, stateFilter);
        if (allInfos.size() != allBackups.size()) {
            ArrayList<String> missingIds = new ArrayList<String>();
            for (BackupInfo info2 : allInfos) {
                if (allBackups.contains(info2.getBackupId())) continue;
                missingIds.add(info2.getBackupId());
            }
            String errMsg = "Sequence of backup ids has 'holes'. The following backup images must be added:" + StringUtils.join((CharSequence)",", missingIds);
            throw new IOException(errMsg);
        }
    }
}

