/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTests.class})
public class IntegrationTestManyRegions {
    private static final String CLASS_NAME = IntegrationTestManyRegions.class.getSimpleName();
    protected static final Logger LOG = LoggerFactory.getLogger(IntegrationTestManyRegions.class);
    protected static final TableName TABLE_NAME = TableName.valueOf((String)CLASS_NAME);
    protected static final String REGION_COUNT_KEY = String.format("hbase.%s.regions", CLASS_NAME);
    protected static final String REGIONSERVER_COUNT_KEY = String.format("hbase.%s.regionServers", CLASS_NAME);
    protected static final String TIMEOUT_MINUTES_KEY = String.format("hbase.%s.timeoutMinutes", CLASS_NAME);
    protected static final IntegrationTestingUtility UTIL = new IntegrationTestingUtility();
    protected static final int DEFAULT_REGION_COUNT = 1000;
    protected static final int REGION_COUNT = UTIL.getConfiguration().getInt(REGION_COUNT_KEY, 1000);
    protected static final int DEFAULT_REGIONSERVER_COUNT = 1;
    protected static final int REGION_SERVER_COUNT = UTIL.getConfiguration().getInt(REGIONSERVER_COUNT_KEY, 1);
    protected static final int DEFAULT_TIMEOUT_MINUTES = 5;
    protected static final int TIMEOUT_MINUTES = UTIL.getConfiguration().getInt(TIMEOUT_MINUTES_KEY, 5);
    @ClassRule
    public static final TestRule timeout = Timeout.builder().withTimeout((long)TIMEOUT_MINUTES, TimeUnit.MINUTES).withLookingForStuckThread(true).build();
    private Admin admin;

    @Before
    public void setUp() throws Exception {
        LOG.info(String.format("Initializing cluster with %d region servers.", REGION_SERVER_COUNT));
        UTIL.initializeCluster(REGION_SERVER_COUNT);
        LOG.info("Cluster initialized");
        this.admin = UTIL.getAdmin();
        if (this.admin.tableExists(TABLE_NAME)) {
            LOG.info(String.format("Deleting existing table %s.", TABLE_NAME));
            if (this.admin.isTableEnabled(TABLE_NAME)) {
                this.admin.disableTable(TABLE_NAME);
            }
            this.admin.deleteTable(TABLE_NAME);
            LOG.info(String.format("Existing table %s deleted.", TABLE_NAME));
        }
        LOG.info("Cluster ready");
    }

    @After
    public void tearDown() throws IOException {
        LOG.info("Cleaning up after test.");
        if (this.admin.tableExists(TABLE_NAME)) {
            if (this.admin.isTableEnabled(TABLE_NAME)) {
                this.admin.disableTable(TABLE_NAME);
            }
            this.admin.deleteTable(TABLE_NAME);
        }
        LOG.info("Restoring cluster.");
        UTIL.restoreCluster();
        LOG.info("Cluster restored.");
    }

    @Test
    public void testCreateTableWithRegions() throws Exception {
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"cf")).build();
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(columnFamilyDescriptor).build();
        RegionSplitter.HexStringSplit algo = new RegionSplitter.HexStringSplit();
        byte[][] splits = algo.split(REGION_COUNT);
        LOG.info(String.format("Creating table %s with %d splits.", TABLE_NAME, REGION_COUNT));
        long startTime = EnvironmentEdgeManager.currentTime();
        try {
            this.admin.createTable(tableDescriptor, splits);
            LOG.info(String.format("Pre-split table created successfully in %dms.", EnvironmentEdgeManager.currentTime() - startTime));
        }
        catch (IOException e) {
            LOG.error("Failed to create table", (Throwable)e);
        }
    }
}

