/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClusterInterface;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.IntegrationTestBase;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTests.class})
public class IntegrationTestDDLMasterFailover
extends IntegrationTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationTestDDLMasterFailover.class);
    private static final int SERVER_COUNT = 1;
    protected static final long DEFAULT_RUN_TIME = 1200000L;
    protected static final int DEFAULT_NUM_THREADS = 20;
    protected static final int DEFAULT_NUM_REGIONS = 50;
    private boolean keepObjectsAtTheEnd = false;
    protected HBaseClusterInterface cluster;
    protected Connection connection;
    protected static final String RUN_TIME_KEY = "hbase.%s.runtime";
    protected static final String NUM_THREADS_KEY = "hbase.%s.numThreads";
    protected static final String NUM_REGIONS_KEY = "hbase.%s.numRegions";
    protected AtomicBoolean running = new AtomicBoolean(true);
    protected AtomicBoolean create_table = new AtomicBoolean(true);
    protected int numThreads;
    protected int numRegions;
    ConcurrentHashMap<String, NamespaceDescriptor> namespaceMap = new ConcurrentHashMap();
    ConcurrentHashMap<TableName, TableDescriptor> enabledTables = new ConcurrentHashMap();
    ConcurrentHashMap<TableName, TableDescriptor> disabledTables = new ConcurrentHashMap();
    ConcurrentHashMap<TableName, TableDescriptor> deletedTables = new ConcurrentHashMap();

    @Override
    public void setUpCluster() throws Exception {
        this.util = this.getTestingUtil(this.getConf());
        LOG.debug("Initializing/checking cluster has 1 servers");
        this.util.initializeCluster(this.getMinServerCount());
        LOG.debug("Done initializing/checking cluster");
        this.cluster = this.util.getHBaseClusterInterface();
    }

    @Override
    public void cleanUpCluster() throws Exception {
        if (!this.keepObjectsAtTheEnd) {
            NamespaceDescriptor[] nsds;
            Admin admin = this.util.getAdmin();
            for (TableName tableName : admin.listTableNames(Pattern.compile("ittable-\\d+"))) {
                admin.disableTable(tableName);
                admin.deleteTable(tableName);
            }
            for (NamespaceDescriptor nsd : nsds = admin.listNamespaceDescriptors()) {
                if (!nsd.getName().matches("itnamespace\\d+")) continue;
                LOG.info("Removing namespace=" + nsd.getName());
                admin.deleteNamespace(nsd.getName());
            }
        }
        this.enabledTables.clear();
        this.disabledTables.clear();
        this.deletedTables.clear();
        this.namespaceMap.clear();
        Connection connection = this.getConnection();
        connection.close();
        super.cleanUpCluster();
    }

    protected int getMinServerCount() {
        return 1;
    }

    protected synchronized void setConnection(Connection connection) {
        this.connection = connection;
    }

    protected synchronized Connection getConnection() {
        if (this.connection == null) {
            try {
                Connection connection = ConnectionFactory.createConnection((Configuration)this.getConf());
                this.setConnection(connection);
            }
            catch (IOException e) {
                LOG.error(HBaseMarkers.FATAL, "Failed to establish connection.", (Throwable)e);
            }
        }
        return this.connection;
    }

    protected void verifyNamespaces() throws IOException {
        Connection connection = this.getConnection();
        Admin admin = connection.getAdmin();
        for (String nsName : this.namespaceMap.keySet()) {
            try {
                Assert.assertTrue((String)("Namespace: " + nsName + " in namespaceMap does not exist"), (admin.getNamespaceDescriptor(nsName) != null ? 1 : 0) != 0);
            }
            catch (NamespaceNotFoundException nsnfe) {
                Assert.fail((String)("Namespace: " + nsName + " in namespaceMap does not exist: " + nsnfe.getMessage()));
            }
        }
        admin.close();
    }

    protected void verifyTables() throws IOException {
        Connection connection = this.getConnection();
        Admin admin = connection.getAdmin();
        for (TableName tableName : this.enabledTables.keySet()) {
            Assert.assertTrue((String)("Table: " + tableName + " in enabledTables is not enabled"), (boolean)admin.isTableEnabled(tableName));
        }
        for (TableName tableName : this.disabledTables.keySet()) {
            Assert.assertTrue((String)("Table: " + tableName + " in disabledTables is not disabled"), (boolean)admin.isTableDisabled(tableName));
        }
        for (TableName tableName : this.deletedTables.keySet()) {
            Assert.assertFalse((String)("Table: " + tableName + " in deletedTables is not deleted"), (boolean)admin.tableExists(tableName));
        }
        admin.close();
    }

    @Test
    public void testAsUnitTest() throws Exception {
        this.runTest();
    }

    @Override
    public int runTestFromCommandLine() throws Exception {
        int ret = this.runTest();
        return ret;
    }

    private void checkException(List<Worker> workers) {
        if (workers == null || workers.isEmpty()) {
            return;
        }
        for (Worker worker : workers) {
            Exception e = worker.getSavedException();
            if (e != null) {
                LOG.error("Found exception in thread: " + worker.getName());
                e.printStackTrace();
            }
            Assert.assertNull((String)("Action failed: " + (Object)((Object)worker.getAction()) + " in thread: " + worker.getName()), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runTest() throws Exception {
        LOG.info("Starting the test");
        String runtimeKey = String.format(RUN_TIME_KEY, ((Object)((Object)this)).getClass().getSimpleName());
        long runtime = this.util.getConfiguration().getLong(runtimeKey, 1200000L);
        String numThreadKey = String.format(NUM_THREADS_KEY, ((Object)((Object)this)).getClass().getSimpleName());
        this.numThreads = this.util.getConfiguration().getInt(numThreadKey, 20);
        ArrayList<Worker> workers = new ArrayList<Worker>(this.numThreads);
        for (int i = 0; i < this.numThreads; ++i) {
            this.checkException(workers);
            Worker worker = new Worker();
            LOG.info("Launching worker thread " + worker.getName());
            workers.add(worker);
            worker.start();
        }
        Threads.sleep((long)(runtime / 2L));
        LOG.info("Stopping creating new tables");
        this.create_table.set(false);
        Threads.sleep((long)(runtime / 2L));
        LOG.info("Runtime is up");
        this.running.set(false);
        this.checkException(workers);
        for (Worker worker : workers) {
            worker.join();
        }
        LOG.info("All Worker threads stopped");
        LOG.info("Verify actions of all threads succeeded");
        this.checkException(workers);
        LOG.info("Verify namespaces");
        this.verifyNamespaces();
        LOG.info("Verify states of all tables");
        this.verifyTables();
        try (HBaseFsck hbck = null;){
            LOG.info("Running hbck");
            hbck = HbckTestingUtil.doFsck((Configuration)this.util.getConfiguration(), (boolean)false);
            if (HbckTestingUtil.inconsistencyFound((HBaseFsck)hbck)) {
                this.keepObjectsAtTheEnd = true;
            }
            HbckTestingUtil.assertNoErrors((HBaseFsck)hbck);
            LOG.info("Finished hbck");
        }
        return 0;
    }

    @Override
    public TableName getTablename() {
        return null;
    }

    @Override
    protected Set<String> getColumnFamilies() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        IntegrationTestDDLMasterFailover masterFailover = new IntegrationTestDDLMasterFailover();
        Connection connection = null;
        int ret = 1;
        try {
            LOG.debug("Setting up connection ...");
            connection = ConnectionFactory.createConnection((Configuration)conf);
            masterFailover.setConnection(connection);
            ret = ToolRunner.run((Configuration)conf, (Tool)masterFailover, (String[])args);
        }
        catch (IOException e) {
            LOG.error(HBaseMarkers.FATAL, "Failed to establish connection. Aborting test ...", (Throwable)e);
        }
        finally {
            connection = masterFailover.getConnection();
            if (connection != null) {
                connection.close();
            }
            System.exit(ret);
        }
    }

    private class Worker
    extends Thread {
        private Exception savedException;
        private ACTION action;

        private Worker() {
        }

        @Override
        public void run() {
            while (IntegrationTestDDLMasterFailover.this.running.get()) {
                ACTION selectedAction;
                this.action = selectedAction = ACTION.values()[ThreadLocalRandom.current().nextInt(ACTION.values().length)];
                LOG.info("Performing Action: " + (Object)((Object)selectedAction));
                try {
                    switch (selectedAction) {
                        case CREATE_NAMESPACE: {
                            new CreateNamespaceAction().perform();
                            break;
                        }
                        case MODIFY_NAMESPACE: {
                            new ModifyNamespaceAction().perform();
                            break;
                        }
                        case DELETE_NAMESPACE: {
                            new DeleteNamespaceAction().perform();
                            break;
                        }
                        case CREATE_TABLE: {
                            if (!IntegrationTestDDLMasterFailover.this.create_table.get()) break;
                            new CreateTableAction().perform();
                            break;
                        }
                        case ADD_ROW: {
                            new AddRowAction().perform();
                            break;
                        }
                        case DISABLE_TABLE: {
                            new DisableTableAction().perform();
                            break;
                        }
                        case ENABLE_TABLE: {
                            new EnableTableAction().perform();
                            break;
                        }
                        case DELETE_TABLE: {
                            if (ThreadLocalRandom.current().nextInt(100) >= 20) break;
                            new DeleteTableAction().perform();
                            break;
                        }
                        case ADD_COLUMNFAMILY: {
                            new AddColumnFamilyAction().perform();
                            break;
                        }
                        case DELETE_COLUMNFAMILY: {
                            if (ThreadLocalRandom.current().nextInt(100) >= 20) break;
                            new DeleteColumnFamilyAction().perform();
                            break;
                        }
                        case ALTER_FAMILYVERSIONS: {
                            new AlterFamilyVersionsAction().perform();
                            break;
                        }
                        case ALTER_FAMILYENCODING: {
                            new AlterFamilyEncodingAction().perform();
                        }
                    }
                }
                catch (Exception ex) {
                    this.savedException = ex;
                    return;
                }
            }
            LOG.info(this.getName() + " stopped");
        }

        public Exception getSavedException() {
            return this.savedException;
        }

        public ACTION getAction() {
            return this.action;
        }
    }

    private static enum ACTION {
        CREATE_NAMESPACE,
        MODIFY_NAMESPACE,
        DELETE_NAMESPACE,
        CREATE_TABLE,
        DISABLE_TABLE,
        ENABLE_TABLE,
        DELETE_TABLE,
        ADD_COLUMNFAMILY,
        DELETE_COLUMNFAMILY,
        ALTER_FAMILYVERSIONS,
        ALTER_FAMILYENCODING,
        ADD_ROW;

    }

    private class AddRowAction
    extends ColumnAction {
        private AddRowAction() {
        }

        @Override
        void perform() throws IOException {
            TableDescriptor selected = this.selectTable(IntegrationTestDDLMasterFailover.this.enabledTables);
            if (selected == null) {
                return;
            }
            TableName tableName = selected.getTableName();
            try (Admin admin = this.connection.getAdmin();
                 Table table = this.connection.getTable(tableName);){
                ArrayList regionInfos = new ArrayList(admin.getRegions(selected.getTableName()));
                int numRegions = regionInfos.size();
                int average_rows = 1;
                int numRows = average_rows * numRegions;
                LOG.info("Adding " + numRows + " rows to table: " + selected);
                byte[] value = new byte[10];
                for (int i = 0; i < numRows; ++i) {
                    byte[] rowKey = Bytes.toBytes((String)("row-" + String.format("%010d", ThreadLocalRandom.current().nextInt())));
                    ColumnFamilyDescriptor cfd = this.selectFamily(selected);
                    if (cfd == null) {
                        return;
                    }
                    byte[] family = cfd.getName();
                    byte[] qualifier = Bytes.toBytes((String)("col-" + ThreadLocalRandom.current().nextInt(10)));
                    Bytes.random((byte[])value);
                    Put put = new Put(rowKey);
                    put.addColumn(family, qualifier, value);
                    table.put(put);
                }
                TableDescriptor freshTableDesc = admin.getDescriptor(tableName);
                Assert.assertTrue((String)("After insert, Table: " + tableName + " in not enabled"), (boolean)admin.isTableEnabled(tableName));
                IntegrationTestDDLMasterFailover.this.enabledTables.put(tableName, freshTableDesc);
                LOG.info("Added " + numRows + " rows to table: " + selected);
            }
        }
    }

    private class DeleteColumnFamilyAction
    extends ColumnAction {
        private DeleteColumnFamilyAction() {
        }

        @Override
        void perform() throws IOException {
            TableDescriptor selected = this.selectTable(IntegrationTestDDLMasterFailover.this.disabledTables);
            ColumnFamilyDescriptor cfd = this.selectFamily(selected);
            if (selected == null || cfd == null) {
                return;
            }
            try (Admin admin = this.connection.getAdmin();){
                if (selected.getColumnFamilyCount() < 2) {
                    LOG.info("No enough column families to delete in table " + selected.getTableName());
                    return;
                }
                TableName tableName = selected.getTableName();
                LOG.info("Deleting column family: " + cfd + " from table: " + tableName);
                admin.deleteColumnFamily(tableName, cfd.getName());
                TableDescriptor freshTableDesc = admin.getDescriptor(tableName);
                Assert.assertFalse((String)("Column family: " + cfd + " was not added"), (boolean)freshTableDesc.hasColumnFamily(cfd.getName()));
                Assert.assertTrue((String)("After delete column family, Table: " + tableName + " is not disabled"), (boolean)admin.isTableDisabled(tableName));
                IntegrationTestDDLMasterFailover.this.disabledTables.put(tableName, freshTableDesc);
                LOG.info("Deleted column family: " + cfd + " from table: " + tableName);
            }
        }
    }

    private class AlterFamilyEncodingAction
    extends ColumnAction {
        private AlterFamilyEncodingAction() {
        }

        @Override
        void perform() throws IOException {
            TableDescriptor selected = this.selectTable(IntegrationTestDDLMasterFailover.this.disabledTables);
            if (selected == null) {
                return;
            }
            ColumnFamilyDescriptor columnDesc = this.selectFamily(selected);
            if (columnDesc == null) {
                return;
            }
            try (Admin admin = this.connection.getAdmin();){
                TableName tableName = selected.getTableName();
                DataBlockEncoding[] possibleIds = new DataBlockEncoding[]{DataBlockEncoding.NONE, DataBlockEncoding.PREFIX, DataBlockEncoding.DIFF, DataBlockEncoding.FAST_DIFF, DataBlockEncoding.ROW_INDEX_V1};
                short id = possibleIds[ThreadLocalRandom.current().nextInt(possibleIds.length)].getId();
                LOG.info("Altering encoding of column family: " + columnDesc + " to: " + id + " in table: " + tableName);
                ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)columnDesc).setDataBlockEncoding(DataBlockEncoding.getEncodingById((short)id)).build();
                TableDescriptor td = TableDescriptorBuilder.newBuilder((TableDescriptor)selected).modifyColumnFamily(cfd).build();
                admin.modifyTable(td);
                TableDescriptor freshTableDesc = admin.getDescriptor(tableName);
                ColumnFamilyDescriptor freshColumnDesc = freshTableDesc.getColumnFamily(columnDesc.getName());
                Assert.assertEquals((String)("Encoding of column family: " + columnDesc + " was not altered"), (long)freshColumnDesc.getDataBlockEncoding().getId(), (long)id);
                Assert.assertTrue((String)("After alter encoding of column family, Table: " + tableName + " is not disabled"), (boolean)admin.isTableDisabled(tableName));
                IntegrationTestDDLMasterFailover.this.disabledTables.put(tableName, freshTableDesc);
                LOG.info("Altered encoding of column family: " + freshColumnDesc + " to: " + id + " in table: " + tableName);
            }
        }
    }

    private class AlterFamilyVersionsAction
    extends ColumnAction {
        private AlterFamilyVersionsAction() {
        }

        @Override
        void perform() throws IOException {
            TableDescriptor selected = this.selectTable(IntegrationTestDDLMasterFailover.this.disabledTables);
            if (selected == null) {
                return;
            }
            ColumnFamilyDescriptor columnDesc = this.selectFamily(selected);
            if (columnDesc == null) {
                return;
            }
            int versions = ThreadLocalRandom.current().nextInt(10) + 3;
            try (Admin admin = this.connection.getAdmin();){
                TableName tableName = selected.getTableName();
                LOG.info("Altering versions of column family: " + columnDesc + " to: " + versions + " in table: " + tableName);
                ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)columnDesc).setMinVersions(versions).setMaxVersions(versions).build();
                TableDescriptor td = TableDescriptorBuilder.newBuilder((TableDescriptor)selected).modifyColumnFamily(cfd).build();
                admin.modifyTable(td);
                TableDescriptor freshTableDesc = admin.getDescriptor(tableName);
                ColumnFamilyDescriptor freshColumnDesc = freshTableDesc.getColumnFamily(columnDesc.getName());
                Assert.assertEquals((String)("Column family: " + columnDesc + " was not altered"), (long)freshColumnDesc.getMaxVersions(), (long)versions);
                Assert.assertEquals((String)("Column family: " + freshColumnDesc + " was not altered"), (long)freshColumnDesc.getMinVersions(), (long)versions);
                Assert.assertTrue((String)("After alter versions of column family, Table: " + tableName + " is not disabled"), (boolean)admin.isTableDisabled(tableName));
                IntegrationTestDDLMasterFailover.this.disabledTables.put(tableName, freshTableDesc);
                LOG.info("Altered versions of column family: " + columnDesc + " to: " + versions + " in table: " + tableName);
            }
        }
    }

    private class AddColumnFamilyAction
    extends ColumnAction {
        private AddColumnFamilyAction() {
        }

        @Override
        void perform() throws IOException {
            TableDescriptor selected = this.selectTable(IntegrationTestDDLMasterFailover.this.disabledTables);
            if (selected == null) {
                return;
            }
            try (Admin admin = this.connection.getAdmin();){
                ColumnFamilyDescriptor cfd = this.createFamilyDesc();
                if (selected.hasColumnFamily(cfd.getName())) {
                    LOG.info(Bytes.toString((byte[])cfd.getName()) + " already exists in table " + selected.getTableName());
                    return;
                }
                TableName tableName = selected.getTableName();
                LOG.info("Adding column family: " + cfd + " to table: " + tableName);
                admin.addColumnFamily(tableName, cfd);
                TableDescriptor freshTableDesc = admin.getDescriptor(tableName);
                Assert.assertTrue((String)("Column family: " + cfd + " was not added"), (boolean)freshTableDesc.hasColumnFamily(cfd.getName()));
                Assert.assertTrue((String)("After add column family, Table: " + tableName + " is not disabled"), (boolean)admin.isTableDisabled(tableName));
                IntegrationTestDDLMasterFailover.this.disabledTables.put(tableName, freshTableDesc);
                LOG.info("Added column family: " + cfd + " to table: " + tableName);
            }
        }

        private ColumnFamilyDescriptor createFamilyDesc() {
            String familyName = String.format("cf-%010d", ThreadLocalRandom.current().nextInt());
            return ColumnFamilyDescriptorBuilder.of((String)familyName);
        }
    }

    private abstract class ColumnAction
    extends TableAction {
        private ColumnAction() {
        }

        protected ColumnFamilyDescriptor selectFamily(TableDescriptor td) {
            if (td == null) {
                return null;
            }
            ColumnFamilyDescriptor[] families = td.getColumnFamilies();
            if (families.length == 0) {
                LOG.info("No column families in table: " + td);
                return null;
            }
            return families[ThreadLocalRandom.current().nextInt(families.length)];
        }
    }

    private class DeleteTableAction
    extends TableAction {
        private DeleteTableAction() {
        }

        @Override
        void perform() throws IOException {
            TableDescriptor selected = this.selectTable(IntegrationTestDDLMasterFailover.this.disabledTables);
            if (selected == null) {
                return;
            }
            try (Admin admin = this.connection.getAdmin();){
                TableName tableName = selected.getTableName();
                LOG.info("Deleting table :" + selected);
                admin.deleteTable(tableName);
                Assert.assertFalse((String)("Table: " + selected + " was not deleted"), (boolean)admin.tableExists(tableName));
                IntegrationTestDDLMasterFailover.this.deletedTables.put(tableName, selected);
                LOG.info("Deleted table :" + selected);
            }
        }
    }

    private class EnableTableAction
    extends TableAction {
        private EnableTableAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void perform() throws IOException {
            block7: {
                TableDescriptor selected = this.selectTable(IntegrationTestDDLMasterFailover.this.disabledTables);
                if (selected == null) {
                    return;
                }
                try (Admin admin = this.connection.getAdmin();){
                    TableName tableName = selected.getTableName();
                    LOG.info("Enabling table :" + selected);
                    admin.enableTable(tableName);
                    Assert.assertTrue((String)("Table: " + selected + " was not enabled"), (boolean)admin.isTableEnabled(tableName));
                    TableDescriptor freshTableDesc = admin.getDescriptor(tableName);
                    Assert.assertTrue((String)("After enable, Table: " + tableName + " in not enabled"), (boolean)admin.isTableEnabled(tableName));
                    IntegrationTestDDLMasterFailover.this.enabledTables.put(tableName, freshTableDesc);
                    LOG.info("Enabled table :" + freshTableDesc);
                }
            }
        }
    }

    private class DisableTableAction
    extends TableAction {
        private DisableTableAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void perform() throws IOException {
            block7: {
                TableDescriptor selected = this.selectTable(IntegrationTestDDLMasterFailover.this.enabledTables);
                if (selected == null) {
                    return;
                }
                try (Admin admin = this.connection.getAdmin();){
                    TableName tableName = selected.getTableName();
                    LOG.info("Disabling table :" + selected);
                    admin.disableTable(tableName);
                    Assert.assertTrue((String)("Table: " + selected + " was not disabled"), (boolean)admin.isTableDisabled(tableName));
                    TableDescriptor freshTableDesc = admin.getDescriptor(tableName);
                    Assert.assertTrue((String)("After disable, Table: " + tableName + " is not disabled"), (boolean)admin.isTableDisabled(tableName));
                    IntegrationTestDDLMasterFailover.this.disabledTables.put(tableName, freshTableDesc);
                    LOG.info("Disabled table :" + freshTableDesc);
                }
            }
        }
    }

    private class CreateTableAction
    extends TableAction {
        private CreateTableAction() {
        }

        @Override
        void perform() throws IOException {
            try (Admin admin = this.connection.getAdmin();){
                TableDescriptor td = this.createTableDesc();
                TableName tableName = td.getTableName();
                if (admin.tableExists(tableName)) {
                    return;
                }
                String numRegionKey = String.format(IntegrationTestDDLMasterFailover.NUM_REGIONS_KEY, this.getClass().getSimpleName());
                IntegrationTestDDLMasterFailover.this.numRegions = IntegrationTestDDLMasterFailover.this.getConf().getInt(numRegionKey, 50);
                byte[] startKey = Bytes.toBytes((String)"row-0000000000");
                byte[] endKey = Bytes.toBytes((String)"row-2147483647");
                LOG.info("Creating table:" + td);
                admin.createTable(td, startKey, endKey, IntegrationTestDDLMasterFailover.this.numRegions);
                Assert.assertTrue((String)("Table: " + td + " was not created"), (boolean)admin.tableExists(tableName));
                TableDescriptor freshTableDesc = admin.getDescriptor(tableName);
                Assert.assertTrue((String)("After create, Table: " + tableName + " in not enabled"), (boolean)admin.isTableEnabled(tableName));
                IntegrationTestDDLMasterFailover.this.enabledTables.put(tableName, freshTableDesc);
                LOG.info("Created table:" + freshTableDesc);
            }
        }

        private TableDescriptor createTableDesc() {
            String tableName = String.format("ittable-%010d", ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE));
            String familyName = "cf-" + ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE);
            return TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)tableName)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)familyName)).build();
        }
    }

    private abstract class TableAction
    extends MasterAction {
        private TableAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TableDescriptor selectTable(ConcurrentHashMap<TableName, TableDescriptor> tableMap) {
            ConcurrentHashMap<TableName, TableDescriptor> concurrentHashMap = tableMap;
            synchronized (concurrentHashMap) {
                if (tableMap.isEmpty()) {
                    return null;
                }
                ArrayList tableList = new ArrayList(tableMap.keySet());
                TableName key = (TableName)tableList.get(ThreadLocalRandom.current().nextInt(tableList.size()));
                TableDescriptor randomTd = tableMap.remove(key);
                return randomTd;
            }
        }
    }

    private class DeleteNamespaceAction
    extends NamespaceAction {
        private DeleteNamespaceAction() {
        }

        @Override
        void perform() throws IOException {
            block9: {
                NamespaceDescriptor selected = this.selectNamespace(IntegrationTestDDLMasterFailover.this.namespaceMap);
                if (selected == null) {
                    return;
                }
                try (Admin admin = this.connection.getAdmin();){
                    String namespaceName = selected.getName();
                    LOG.info("Deleting namespace :" + selected);
                    admin.deleteNamespace(namespaceName);
                    try {
                        if (admin.getNamespaceDescriptor(namespaceName) != null) {
                            Assert.assertTrue((String)("Namespace: " + selected + " was not deleted"), (boolean)false);
                            break block9;
                        }
                        LOG.info("Deleted namespace :" + selected);
                    }
                    catch (NamespaceNotFoundException nsnfe) {
                        LOG.info("Deleted namespace :" + selected);
                    }
                }
            }
        }
    }

    private class ModifyNamespaceAction
    extends NamespaceAction {
        private ModifyNamespaceAction() {
        }

        @Override
        void perform() throws IOException {
            NamespaceDescriptor selected = this.selectNamespace(IntegrationTestDDLMasterFailover.this.namespaceMap);
            if (selected == null) {
                return;
            }
            try (Admin admin = this.connection.getAdmin();){
                String nsValueNew;
                String namespaceName = selected.getName();
                LOG.info("Modifying namespace :" + selected);
                NamespaceDescriptor modifiedNsd = NamespaceDescriptor.create((String)namespaceName).build();
                do {
                    nsValueNew = String.format("%010d", ThreadLocalRandom.current().nextInt());
                } while (selected.getConfigurationValue("hbase.namespace.testKey").equals(nsValueNew));
                modifiedNsd.setConfiguration("hbase.namespace.testKey", nsValueNew);
                admin.modifyNamespace(modifiedNsd);
                NamespaceDescriptor freshNamespaceDesc = admin.getNamespaceDescriptor(namespaceName);
                Assert.assertTrue((String)("Namespace: " + selected + " was not modified"), (boolean)freshNamespaceDesc.getConfigurationValue("hbase.namespace.testKey").equals(nsValueNew));
                Assert.assertTrue((String)("Namespace: " + namespaceName + " does not exist"), (admin.getNamespaceDescriptor(namespaceName) != null ? 1 : 0) != 0);
                IntegrationTestDDLMasterFailover.this.namespaceMap.put(namespaceName, freshNamespaceDesc);
                LOG.info("Modified namespace :" + freshNamespaceDesc);
            }
        }
    }

    private class CreateNamespaceAction
    extends NamespaceAction {
        private CreateNamespaceAction() {
        }

        @Override
        void perform() throws IOException {
            try (Admin admin = this.connection.getAdmin();){
                NamespaceDescriptor nsd;
                while (true) {
                    nsd = this.createNamespaceDesc();
                    try {
                        if (admin.getNamespaceDescriptor(nsd.getName()) == null) break;
                    }
                    catch (NamespaceNotFoundException nsnfe) {
                        // empty catch block
                        break;
                    }
                }
                LOG.info("Creating namespace:" + nsd);
                admin.createNamespace(nsd);
                NamespaceDescriptor freshNamespaceDesc = admin.getNamespaceDescriptor(nsd.getName());
                Assert.assertTrue((String)("Namespace: " + nsd + " was not created"), (freshNamespaceDesc != null ? 1 : 0) != 0);
                IntegrationTestDDLMasterFailover.this.namespaceMap.put(nsd.getName(), freshNamespaceDesc);
                LOG.info("Created namespace:" + freshNamespaceDesc);
            }
        }

        private NamespaceDescriptor createNamespaceDesc() {
            String namespaceName = "itnamespace" + String.format("%010d", ThreadLocalRandom.current().nextInt());
            NamespaceDescriptor nsd = NamespaceDescriptor.create((String)namespaceName).build();
            nsd.setConfiguration("hbase.namespace.testKey", String.format("%010d", ThreadLocalRandom.current().nextInt()));
            return nsd;
        }
    }

    private abstract class NamespaceAction
    extends MasterAction {
        final String nsTestConfigKey = "hbase.namespace.testKey";

        private NamespaceAction() {
            this.nsTestConfigKey = "hbase.namespace.testKey";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected NamespaceDescriptor selectNamespace(ConcurrentHashMap<String, NamespaceDescriptor> namespaceMap) {
            ConcurrentHashMap<String, NamespaceDescriptor> concurrentHashMap = namespaceMap;
            synchronized (concurrentHashMap) {
                if (namespaceMap.isEmpty()) {
                    return null;
                }
                ArrayList namespaceList = new ArrayList(namespaceMap.keySet());
                String randomKey = (String)namespaceList.get(ThreadLocalRandom.current().nextInt(namespaceList.size()));
                NamespaceDescriptor randomNsd = namespaceMap.get(randomKey);
                namespaceMap.remove(randomKey);
                return randomNsd;
            }
        }
    }

    private abstract class MasterAction {
        Connection connection;

        private MasterAction() {
            this.connection = IntegrationTestDDLMasterFailover.this.getConnection();
        }

        abstract void perform() throws IOException;
    }
}

