/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.RowSpec;
import org.apache.hadoop.hbase.rest.ScannerInstanceResource;
import org.apache.hadoop.hbase.rest.ScannerResultGenerator;
import org.apache.hadoop.hbase.rest.TableResource;
import org.apache.hadoop.hbase.rest.model.ScannerModel;
import org.apache.hbase.thirdparty.javax.ws.rs.Consumes;
import org.apache.hbase.thirdparty.javax.ws.rs.POST;
import org.apache.hbase.thirdparty.javax.ws.rs.PUT;
import org.apache.hbase.thirdparty.javax.ws.rs.Path;
import org.apache.hbase.thirdparty.javax.ws.rs.PathParam;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Context;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Response;
import org.apache.hbase.thirdparty.javax.ws.rs.core.UriBuilder;
import org.apache.hbase.thirdparty.javax.ws.rs.core.UriInfo;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ScannerResource
extends ResourceBase {
    private static final Logger LOG = LoggerFactory.getLogger(ScannerResource.class);
    static final Map<String, ScannerInstanceResource> scanners = Collections.synchronizedMap(new HashMap());
    TableResource tableResource;

    public ScannerResource(TableResource tableResource) throws IOException {
        this.tableResource = tableResource;
    }

    static boolean delete(String id) {
        ScannerInstanceResource instance = scanners.remove(id);
        if (instance != null) {
            instance.generator.close();
            return true;
        }
        return false;
    }

    Response update(ScannerModel model, boolean replace, UriInfo uriInfo) {
        this.servlet.getMetrics().incrementRequests(1);
        if (this.servlet.isReadOnly()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)"Forbidden\r\n").build();
        }
        byte[] endRow = model.hasEndRow() ? model.getEndRow() : null;
        RowSpec spec = null;
        spec = model.getLabels() != null ? new RowSpec(model.getStartRow(), endRow, model.getColumns(), model.getStartTime(), model.getEndTime(), model.getMaxVersions(), model.getLabels()) : new RowSpec(model.getStartRow(), endRow, model.getColumns(), model.getStartTime(), model.getEndTime(), model.getMaxVersions());
        try {
            Filter filter = ScannerResultGenerator.buildFilterFromModel(model);
            String tableName = this.tableResource.getName();
            ScannerResultGenerator gen = new ScannerResultGenerator(tableName, spec, filter, model.getCaching(), model.getCacheBlocks(), model.getLimit());
            String id = gen.getID();
            ScannerInstanceResource instance = new ScannerInstanceResource(tableName, id, gen, model.getBatch());
            scanners.put(id, instance);
            if (LOG.isTraceEnabled()) {
                LOG.trace("new scanner: " + id);
            }
            UriBuilder builder = uriInfo.getAbsolutePathBuilder();
            URI uri = builder.path(id).build(new Object[0]);
            this.servlet.getMetrics().incrementSucessfulPutRequests(1);
            return Response.created((URI)uri).build();
        }
        catch (Exception e) {
            LOG.error("Exception occurred while processing " + uriInfo.getAbsolutePath() + " : ", (Throwable)e);
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            if (e instanceof TableNotFoundException) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Not found\r\n").build();
            }
            if (e instanceof RuntimeException || e instanceof JsonMappingException | e instanceof JsonParseException) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request\r\n").build();
            }
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)"Unavailable\r\n").build();
        }
    }

    @PUT
    @Consumes(value={"text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response put(ScannerModel model, @Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("PUT " + uriInfo.getAbsolutePath());
        }
        return this.update(model, true, uriInfo);
    }

    @POST
    @Consumes(value={"text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response post(ScannerModel model, @Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("POST " + uriInfo.getAbsolutePath());
        }
        return this.update(model, false, uriInfo);
    }

    @Path(value="{scanner: .+}")
    public ScannerInstanceResource getScannerInstanceResource(@PathParam(value="scanner") String id) throws IOException {
        ScannerInstanceResource instance = scanners.get(id);
        if (instance == null) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            return new ScannerInstanceResource();
        }
        this.servlet.getMetrics().incrementSucessfulGetRequests(1);
        return instance;
    }
}

