/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.CheckAndMutateResult;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.thrift2.ThriftUtilities;
import org.apache.hadoop.hbase.thrift2.generated.TAppend;
import org.apache.hadoop.hbase.thrift2.generated.TDelete;
import org.apache.hadoop.hbase.thrift2.generated.TGet;
import org.apache.hadoop.hbase.thrift2.generated.THBaseService;
import org.apache.hadoop.hbase.thrift2.generated.TIncrement;
import org.apache.hadoop.hbase.thrift2.generated.TPut;
import org.apache.hadoop.hbase.thrift2.generated.TResult;
import org.apache.hadoop.hbase.thrift2.generated.TRowMutations;
import org.apache.hadoop.hbase.thrift2.generated.TScan;
import org.apache.hadoop.hbase.thrift2.generated.TTableDescriptor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.primitives.Booleans;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransport;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ThriftTable
implements Table {
    private TableName tableName;
    private Configuration conf;
    private TTransport tTransport;
    private THBaseService.Client client;
    private ByteBuffer tableNameInBytes;
    private int operationTimeout;
    private final int scannerCaching;

    public ThriftTable(TableName tableName, THBaseService.Client client, TTransport tTransport, Configuration conf) {
        this.tableName = tableName;
        this.tableNameInBytes = ByteBuffer.wrap(tableName.toBytes());
        this.conf = conf;
        this.tTransport = tTransport;
        this.client = client;
        this.scannerCaching = conf.getInt("hbase.thrift.client.scanner.caching", 20);
        this.operationTimeout = conf.getInt("hbase.client.operation.timeout", 1200000);
    }

    public TableName getName() {
        return this.tableName;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public TableDescriptor getDescriptor() throws IOException {
        try {
            TTableDescriptor tableDescriptor = this.client.getTableDescriptor(ThriftUtilities.tableNameFromHBase(this.tableName));
            return ThriftUtilities.tableDescriptorFromThrift(tableDescriptor);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public boolean exists(Get get2) throws IOException {
        TGet tGet = ThriftUtilities.getFromHBase(get2);
        try {
            return this.client.exists(this.tableNameInBytes, tGet);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public boolean[] exists(List<Get> gets) throws IOException {
        ArrayList<TGet> tGets = new ArrayList<TGet>();
        for (Get get2 : gets) {
            tGets.add(ThriftUtilities.getFromHBase(get2));
        }
        try {
            List<Boolean> results = this.client.existsAll(this.tableNameInBytes, tGets);
            return Booleans.toArray(results);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void batch(List<? extends Row> actions, Object[] results) throws IOException {
        throw new IOException("Batch not supported in ThriftTable, use put(List<Put> puts), get(List<Get> gets) or delete(List<Delete> deletes) respectively");
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException {
        throw new IOException("BatchCallback not supported in ThriftTable, use put(List<Put> puts), get(List<Get> gets) or delete(List<Delete> deletes) respectively");
    }

    public Result get(Get get2) throws IOException {
        TGet tGet = ThriftUtilities.getFromHBase(get2);
        try {
            TResult tResult = this.client.get(this.tableNameInBytes, tGet);
            return ThriftUtilities.resultFromThrift(tResult);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public Result[] get(List<Get> gets) throws IOException {
        List<TGet> tGets = ThriftUtilities.getsFromHBase(gets);
        try {
            List<TResult> results = this.client.getMultiple(this.tableNameInBytes, tGets);
            return ThriftUtilities.resultsFromThrift(results);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        return new Scanner(scan);
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.getScanner(scan);
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.getScanner(scan);
    }

    public void put(Put put2) throws IOException {
        TPut tPut = ThriftUtilities.putFromHBase(put2);
        try {
            this.client.put(this.tableNameInBytes, tPut);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void put(List<Put> puts) throws IOException {
        List<TPut> tPuts = ThriftUtilities.putsFromHBase(puts);
        try {
            this.client.putMultiple(this.tableNameInBytes, tPuts);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void delete(Delete delete) throws IOException {
        TDelete tDelete = ThriftUtilities.deleteFromHBase(delete);
        try {
            this.client.deleteSingle(this.tableNameInBytes, tDelete);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void delete(List<Delete> deletes) throws IOException {
        List<TDelete> tDeletes = ThriftUtilities.deletesFromHBase(deletes);
        try {
            this.client.deleteMultiple(this.tableNameInBytes, tDeletes);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    private boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, RowMutations mutation) throws IOException {
        try {
            ByteBuffer valueBuffer = value == null ? null : ByteBuffer.wrap(value);
            return this.client.checkAndMutate(this.tableNameInBytes, ByteBuffer.wrap(row), ByteBuffer.wrap(family), ByteBuffer.wrap(qualifier), ThriftUtilities.compareOpFromHBase(op), valueBuffer, ThriftUtilities.rowMutationsFromHBase(mutation));
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public Table.CheckAndMutateBuilder checkAndMutate(byte[] row, byte[] family) {
        return new CheckAndMutateBuilderImpl(row, family);
    }

    public Table.CheckAndMutateWithFilterBuilder checkAndMutate(byte[] row, Filter filter) {
        throw new NotImplementedException("Implement later");
    }

    public CheckAndMutateResult checkAndMutate(CheckAndMutate checkAndMutate2) {
        throw new NotImplementedException("Implement later");
    }

    public List<CheckAndMutateResult> checkAndMutate(List<CheckAndMutate> checkAndMutates) {
        throw new NotImplementedException("Implement later");
    }

    public Result mutateRow(RowMutations rm) throws IOException {
        TRowMutations tRowMutations = ThriftUtilities.rowMutationsFromHBase(rm);
        try {
            this.client.mutateRow(this.tableNameInBytes, tRowMutations);
            return Result.EMPTY_RESULT;
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public Result append(Append append2) throws IOException {
        TAppend tAppend = ThriftUtilities.appendFromHBase(append2);
        try {
            TResult tResult = this.client.append(this.tableNameInBytes, tAppend);
            return ThriftUtilities.resultFromThrift(tResult);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public Result increment(Increment increment2) throws IOException {
        TIncrement tIncrement = ThriftUtilities.incrementFromHBase(increment2);
        try {
            TResult tResult = this.client.increment(this.tableNameInBytes, tIncrement);
            return ThriftUtilities.resultFromThrift(tResult);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void close() throws IOException {
        this.tTransport.close();
    }

    public long getRpcTimeout(TimeUnit unit) {
        return unit.convert(this.operationTimeout, TimeUnit.MILLISECONDS);
    }

    public long getReadRpcTimeout(TimeUnit unit) {
        return unit.convert(this.operationTimeout, TimeUnit.MILLISECONDS);
    }

    public long getWriteRpcTimeout(TimeUnit unit) {
        return unit.convert(this.operationTimeout, TimeUnit.MILLISECONDS);
    }

    public long getOperationTimeout(TimeUnit unit) {
        return unit.convert(this.operationTimeout, TimeUnit.MILLISECONDS);
    }

    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        throw new NotImplementedException("coprocessorService not supported in ThriftTable");
    }

    public RegionLocator getRegionLocator() throws IOException {
        throw new NotImplementedException("getRegionLocator not supported in ThriftTable");
    }

    private class CheckAndMutateBuilderImpl
    implements Table.CheckAndMutateBuilder {
        private final byte[] row;
        private final byte[] family;
        private byte[] qualifier;
        private CompareOperator op;
        private byte[] value;

        CheckAndMutateBuilderImpl(byte[] row, byte[] family) {
            this.row = (byte[])Preconditions.checkNotNull((Object)row, (Object)"row is null");
            this.family = (byte[])Preconditions.checkNotNull((Object)family, (Object)"family is null");
        }

        public Table.CheckAndMutateBuilder qualifier(byte[] qualifier) {
            this.qualifier = (byte[])Preconditions.checkNotNull((Object)qualifier, (Object)"qualifier is null. Consider using an empty byte array, or just do not call this method if you want a null qualifier");
            return this;
        }

        public Table.CheckAndMutateBuilder timeRange(TimeRange timeRange) {
            throw new NotImplementedException("timeRange not supported in ThriftTable");
        }

        public Table.CheckAndMutateBuilder ifNotExists() {
            this.op = CompareOperator.EQUAL;
            this.value = null;
            return this;
        }

        public Table.CheckAndMutateBuilder ifMatches(CompareOperator compareOp, byte[] value) {
            this.op = (CompareOperator)Preconditions.checkNotNull((Object)compareOp, (Object)"compareOp is null");
            this.value = (byte[])Preconditions.checkNotNull((Object)value, (Object)"value is null");
            return this;
        }

        private void preCheck() {
            Preconditions.checkNotNull((Object)this.op, (Object)"condition is null. You need to specify the condition by calling ifNotExists/ifEquals/ifMatches before executing the request");
        }

        public boolean thenPut(Put put2) throws IOException {
            this.preCheck();
            RowMutations rowMutations = new RowMutations(put2.getRow());
            rowMutations.add((Mutation)put2);
            return ThriftTable.this.checkAndMutate(this.row, this.family, this.qualifier, this.op, this.value, rowMutations);
        }

        public boolean thenDelete(Delete delete) throws IOException {
            this.preCheck();
            RowMutations rowMutations = new RowMutations(delete.getRow());
            rowMutations.add((Mutation)delete);
            return ThriftTable.this.checkAndMutate(this.row, this.family, this.qualifier, this.op, this.value, rowMutations);
        }

        public boolean thenMutate(RowMutations mutation) throws IOException {
            this.preCheck();
            return ThriftTable.this.checkAndMutate(this.row, this.family, this.qualifier, this.op, this.value, mutation);
        }
    }

    private class Scanner
    implements ResultScanner {
        protected TScan scan;
        protected Result lastResult = null;
        protected final Queue<Result> cache = new ArrayDeque<Result>();

        public Scanner(Scan scan) throws IOException {
            if (scan.getBatch() > 0) {
                throw new IOException("Batch is not supported in Scanner");
            }
            if (scan.getCaching() <= 0) {
                scan.setCaching(ThriftTable.this.scannerCaching);
            } else if (scan.getCaching() == 1 && scan.isReversed()) {
                scan.setCaching(scan.getCaching() + 1);
            }
            this.scan = ThriftUtilities.scanFromHBase(scan);
        }

        public Result next() throws IOException {
            if (this.cache.size() == 0) {
                this.setupNextScanner();
                try {
                    List<TResult> tResults = ThriftTable.this.client.getScannerResults(ThriftTable.this.tableNameInBytes, this.scan, this.scan.getCaching());
                    Result[] results = ThriftUtilities.resultsFromThrift(tResults);
                    boolean firstKey = true;
                    for (Result result : results) {
                        if (firstKey) {
                            firstKey = false;
                            if (this.scan.isReversed() && this.lastResult != null && Bytes.equals((byte[])this.lastResult.getRow(), (byte[])result.getRow())) continue;
                        }
                        this.cache.add(result);
                        this.lastResult = result;
                    }
                }
                catch (TException e) {
                    throw new IOException(e);
                }
            }
            if (this.cache.size() > 0) {
                return this.cache.poll();
            }
            return null;
        }

        public void close() {
        }

        public boolean renewLease() {
            throw new RuntimeException("renewLease() not supported");
        }

        public ScanMetrics getScanMetrics() {
            throw new RuntimeException("getScanMetrics() not supported");
        }

        private void setupNextScanner() {
            if (this.lastResult != null) {
                byte[] lastRow = this.lastResult.getRow();
                if (this.scan.isReversed()) {
                    this.scan.setStartRow(lastRow);
                } else {
                    this.scan.setStartRow(this.createClosestRowAfter(lastRow));
                }
            }
        }

        protected byte[] createClosestRowAfter(byte[] row) {
            if (row == null) {
                throw new RuntimeException("The passed row is null");
            }
            return Arrays.copyOf(row, row.length + 1);
        }
    }
}

