/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.types.OrderedInt8;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={MiscTests.class, SmallTests.class})
public class TestOrderedInt8 {
    private static final Byte[] VALUES = new Byte[]{(byte)1, (byte)22};
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestOrderedInt8.class);
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testIsNullableIsFalse() {
        OrderedInt8 type = new OrderedInt8(Order.ASCENDING);
        Assert.assertFalse((boolean)type.isNullable());
    }

    @Test
    public void testEncodedClassIsByte() {
        OrderedInt8 type = new OrderedInt8(Order.ASCENDING);
        Assert.assertEquals(Byte.class, (Object)type.encodedClass());
    }

    @Test
    public void testEncodedLength() {
        SimplePositionedMutableByteRange buffer = new SimplePositionedMutableByteRange(20);
        for (OrderedInt8 type : new OrderedInt8[]{new OrderedInt8(Order.ASCENDING), new OrderedInt8(Order.DESCENDING)}) {
            for (Byte val : VALUES) {
                buffer.setPosition(0);
                type.encode((PositionedByteRange)buffer, (Object)val);
                Assert.assertEquals((String)("encodedLength does not match actual, " + val), (long)buffer.getPosition(), (long)type.encodedLength((Object)val));
            }
        }
    }

    @Test
    public void testEncodeNoSupportForNull() {
        this.exception.expect(IllegalArgumentException.class);
        OrderedInt8 type = new OrderedInt8(Order.ASCENDING);
        type.encode((PositionedByteRange)new SimplePositionedMutableByteRange(20), null);
    }

    @Test
    public void testEncodedFloatLength() {
        SimplePositionedMutableByteRange buffer = new SimplePositionedMutableByteRange(20);
        for (OrderedInt8 type : new OrderedInt8[]{new OrderedInt8(Order.ASCENDING), new OrderedInt8(Order.DESCENDING)}) {
            for (Byte val : VALUES) {
                buffer.setPosition(0);
                type.encodeByte((PositionedByteRange)buffer, val.byteValue());
                Assert.assertEquals((String)("encodedLength does not match actual, " + val), (long)buffer.getPosition(), (long)type.encodedLength(val));
            }
        }
    }
}

