/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.types.OrderedFloat64;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={MiscTests.class, SmallTests.class})
public class TestOrderedFloat64 {
    private static final Double[] VALUES = new Double[]{Double.NaN, 1.1, 22.2, 333.3, 4444.4, 55555.5, 666666.6, 7777777.7, 8.88888888E7, 9.999999999E8};
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestOrderedFloat64.class);
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testIsNullableIsFalse() {
        OrderedFloat64 type = new OrderedFloat64(Order.ASCENDING);
        Assert.assertFalse((boolean)type.isNullable());
    }

    @Test
    public void testEncodedClassIsDouble() {
        OrderedFloat64 type = new OrderedFloat64(Order.ASCENDING);
        Assert.assertEquals(Double.class, (Object)type.encodedClass());
    }

    @Test
    public void testEncodedLength() {
        SimplePositionedMutableByteRange buffer = new SimplePositionedMutableByteRange(20);
        for (OrderedFloat64 type : new OrderedFloat64[]{new OrderedFloat64(Order.ASCENDING), new OrderedFloat64(Order.DESCENDING)}) {
            for (Double val : VALUES) {
                buffer.setPosition(0);
                type.encode((PositionedByteRange)buffer, (Object)val);
                Assert.assertEquals((String)("encodedLength does not match actual, " + val), (long)buffer.getPosition(), (long)type.encodedLength((Object)val));
            }
        }
    }

    @Test
    public void testEncodeNoSupportForNull() {
        this.exception.expect(IllegalArgumentException.class);
        OrderedFloat64 type = new OrderedFloat64(Order.ASCENDING);
        type.encode((PositionedByteRange)new SimplePositionedMutableByteRange(20), null);
    }

    @Test
    public void testEncodedFloatLength() {
        SimplePositionedMutableByteRange buffer = new SimplePositionedMutableByteRange(20);
        for (OrderedFloat64 type : new OrderedFloat64[]{new OrderedFloat64(Order.ASCENDING), new OrderedFloat64(Order.DESCENDING)}) {
            for (Double val : VALUES) {
                buffer.setPosition(0);
                type.encodeDouble((PositionedByteRange)buffer, val.doubleValue());
                Assert.assertEquals((String)("encodedLength does not match actual, " + val), (long)buffer.getPosition(), (long)type.encodedLength(val));
            }
        }
    }
}

