/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.HashSet;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestServerName {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestServerName.class);

    @Test
    public void testHash() {
        ServerName sn1 = ServerName.parseServerName((String)"asf903.gq1.ygridcore.net,52690,1517835491385");
        ServerName sn2 = ServerName.parseServerName((String)"asf903.gq1.ygridcore.net,42231,1517835491329");
        HashSet<ServerName> sns = new HashSet<ServerName>();
        sns.add(sn2);
        sns.add(sn1);
        sns.add(sn1);
        Assert.assertEquals((long)2L, (long)sns.size());
    }

    @Test
    public void testShortString() {
        ServerName sn = ServerName.valueOf((String)"asf000.sp2.ygridcore.net", (int)1, (long)1L);
        Assert.assertEquals((Object)"asf000:1", (Object)sn.toShortString());
        sn = ServerName.valueOf((String)"2607:f0d0:1002:0051:0000:0000:0000:0004", (int)1, (long)1L);
        Assert.assertEquals((Object)"2607:f0d0:1002:0051:0000:0000:0000:0004:1", (Object)sn.toShortString());
        sn = ServerName.valueOf((String)"1.1.1.1", (int)1, (long)1L);
        Assert.assertEquals((Object)"1.1.1.1:1", (Object)sn.toShortString());
    }

    @Test
    public void testRegexPatterns() {
        Assert.assertTrue((boolean)Pattern.matches("[\\d]+", "123"));
        Assert.assertFalse((boolean)Pattern.matches("[\\d]+", ""));
        Assert.assertTrue((boolean)ServerName.SERVERNAME_PATTERN.matcher("www1.example.org,1234,567").matches());
        ServerName.parseServerName((String)"a.b.c,58102,1319771740322");
        ServerName.parseServerName((String)"192.168.1.199,58102,1319771740322");
        ServerName.parseServerName((String)"a.b.c:58102");
        ServerName.parseServerName((String)"192.168.1.199:58102");
    }

    @Test
    public void testParseOfBytes() {
        String snStr = "www.EXAMPLE.org,1234,5678";
        ServerName sn = ServerName.valueOf((String)"www.EXAMPLE.org,1234,5678");
        byte[] versionedBytes = sn.getVersionedBytes();
        ServerName parsedSn = ServerName.parseVersionedServerName((byte[])versionedBytes);
        Assert.assertEquals((Object)sn.toString(), (Object)parsedSn.toString());
        Assert.assertEquals((Object)sn.getHostnameLowerCase(), (Object)parsedSn.getHostnameLowerCase());
        Assert.assertEquals((long)sn.getPort(), (long)parsedSn.getPort());
        Assert.assertEquals((long)sn.getStartCode(), (long)parsedSn.getStartCode());
        String hostnamePortStr = sn.getAddress().toString();
        byte[] bytes = Bytes.toBytes((String)hostnamePortStr);
        parsedSn = ServerName.parseVersionedServerName((byte[])bytes);
        Assert.assertEquals((Object)sn.getHostnameLowerCase(), (Object)parsedSn.getHostnameLowerCase());
        Assert.assertEquals((long)sn.getPort(), (long)parsedSn.getPort());
        Assert.assertEquals((long)-1L, (long)parsedSn.getStartCode());
    }

    @Test
    public void testServerName() {
        ServerName sn = ServerName.valueOf((String)"www.example.org", (int)1234, (long)5678L);
        ServerName sn2 = ServerName.valueOf((String)"www.example.org", (int)1234, (long)5678L);
        ServerName sn3 = ServerName.valueOf((String)"www.example.org", (int)1234, (long)56789L);
        Assert.assertTrue((boolean)sn.equals((Object)sn2));
        Assert.assertFalse((boolean)sn.equals((Object)sn3));
        Assert.assertEquals((long)sn.hashCode(), (long)sn2.hashCode());
        Assert.assertNotSame((Object)sn.hashCode(), (Object)sn3.hashCode());
        Assert.assertEquals((Object)sn.toString(), (Object)ServerName.valueOf((String)"www.example.org", (int)1234, (long)5678L).toString());
        Assert.assertEquals((Object)sn.toString(), (Object)ServerName.valueOf((String)"www.example.org:1234", (long)5678L).toString());
        Assert.assertEquals((Object)"www.example.org,1234,5678", (Object)sn.toString());
    }

    @Test
    public void testHostNameCaseSensitivity() {
        ServerName lower = ServerName.valueOf((String)"www.example.org", (int)1234, (long)5678L);
        ServerName upper = ServerName.valueOf((String)"www.EXAMPLE.org", (int)1234, (long)5678L);
        Assert.assertEquals((long)0L, (long)lower.compareTo(upper));
        Assert.assertEquals((long)0L, (long)upper.compareTo(lower));
        Assert.assertEquals((long)lower.hashCode(), (long)upper.hashCode());
        Assert.assertTrue((boolean)lower.equals((Object)upper));
        Assert.assertTrue((boolean)upper.equals((Object)lower));
        Assert.assertTrue((boolean)ServerName.isSameAddress((ServerName)lower, (ServerName)upper));
    }

    @Test
    public void testInterning() {
        ServerName sn1 = ServerName.valueOf((String)"www.example.org", (int)1234, (long)5671L);
        Assert.assertSame((Object)sn1, (Object)ServerName.valueOf((String)"www.example.org", (int)1234, (long)5671L));
    }

    @Test
    public void testInterningDoesWeakReferences() {
        for (int i = 0; i < 5000; ++i) {
            int startcode = i++;
            ServerName sn1 = ServerName.valueOf((String)"www.example.org", (int)1234, (long)startcode);
            Assert.assertSame((Object)sn1, (Object)ServerName.valueOf((String)"www.example.org", (int)1234, (long)startcode));
        }
    }
}

