/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.XAttrFormat;

@InterfaceAudience.Private
public class XAttrFeature
implements INode.Feature {
    static final int PACK_THRESHOLD = 1024;
    private byte[] attrs;
    private ImmutableList<XAttr> xAttrs;

    public XAttrFeature(List<XAttr> xAttrs) {
        if (xAttrs != null && !xAttrs.isEmpty()) {
            ArrayList<XAttr> toPack = new ArrayList<XAttr>();
            ImmutableList.Builder b = null;
            for (XAttr attr : xAttrs) {
                if (attr.getValue() == null || attr.getValue().length <= 1024) {
                    toPack.add(attr);
                    continue;
                }
                if (b == null) {
                    b = ImmutableList.builder();
                }
                b.add((Object)attr);
            }
            this.attrs = XAttrFormat.toBytes(toPack);
            if (b != null) {
                this.xAttrs = b.build();
            }
        }
    }

    public List<XAttr> getXAttrs() {
        if (this.xAttrs == null) {
            return XAttrFormat.toXAttrs(this.attrs);
        }
        if (this.attrs == null) {
            return this.xAttrs;
        }
        ArrayList<XAttr> result = new ArrayList<XAttr>();
        result.addAll(XAttrFormat.toXAttrs(this.attrs));
        result.addAll((Collection<XAttr>)this.xAttrs);
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return this.getXAttrs().equals(((XAttrFeature)o).getXAttrs());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getXAttrs().toArray());
    }

    public XAttr getXAttr(String prefixedName) {
        XAttr attr = XAttrFormat.getXAttr(this.attrs, prefixedName);
        if (attr == null && this.xAttrs != null) {
            XAttr toFind = XAttrHelper.buildXAttr((String)prefixedName);
            for (XAttr a : this.xAttrs) {
                if (!a.equalsIgnoreValue((Object)toFind)) continue;
                attr = a;
                break;
            }
        }
        return attr;
    }
}

