/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.queuemanagement;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractAutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueueConfig;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedQueueManagementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueManagementChange;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.MonotonicClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuaranteedOrZeroCapacityOverTimePolicy
implements AutoCreatedQueueManagementPolicy {
    private CapacitySchedulerContext scheduler;
    private ManagedParentQueue managedParentQueue;
    private static final Logger LOG = LoggerFactory.getLogger(GuaranteedOrZeroCapacityOverTimePolicy.class);
    private ReentrantReadWriteLock.WriteLock writeLock;
    private ReentrantReadWriteLock.ReadLock readLock;
    private ParentQueueState parentQueueState = new ParentQueueState();
    private AutoCreatedLeafQueueConfig leafQueueTemplate;
    private QueueCapacities leafQueueTemplateCapacities;
    private Set<String> leafQueueTemplateNodeLabels;
    private LeafQueueState leafQueueState = new LeafQueueState();
    private Clock clock = new MonotonicClock();
    private PendingApplicationComparator applicationComparator = new PendingApplicationComparator();

    @Override
    public void init(CapacitySchedulerContext schedulerContext, ParentQueue parentQueue) throws IOException {
        this.scheduler = schedulerContext;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        if (!(parentQueue instanceof ManagedParentQueue)) {
            throw new IllegalArgumentException("Expected instance of type " + ManagedParentQueue.class);
        }
        this.managedParentQueue = (ManagedParentQueue)parentQueue;
        this.initializeLeafQueueTemplate(this.managedParentQueue);
        LOG.info("Initialized queue management policy for parent queue " + parentQueue.getQueueName() + " with leaf queue template capacities : [" + this.leafQueueTemplate.getQueueCapacities() + "]");
    }

    private void initializeLeafQueueTemplate(ManagedParentQueue parentQueue) throws IOException {
        this.leafQueueTemplate = parentQueue.getLeafQueueTemplate();
        this.leafQueueTemplateCapacities = this.leafQueueTemplate.getQueueCapacities();
        Set<String> parentQueueLabels = parentQueue.getNodeLabelsForQueue();
        for (String nodeLabel : this.leafQueueTemplateCapacities.getExistingNodeLabels()) {
            if (parentQueueLabels.contains(nodeLabel)) continue;
            LOG.error("Invalid node label " + nodeLabel + " on configured leaf template on parent queue " + parentQueue.getQueueName());
            throw new IOException("Invalid node label " + nodeLabel + " on configured leaf template on parent queue " + parentQueue.getQueueName());
        }
        this.leafQueueTemplateNodeLabels = this.leafQueueTemplateCapacities.getExistingNodeLabels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QueueManagementChange> computeQueueManagementChanges() throws SchedulerDynamicEditException {
        this.updateLeafQueueState();
        try {
            this.readLock.lock();
            ArrayList<QueueManagementChange.UpdateQueue> queueManagementChanges = new ArrayList<QueueManagementChange.UpdateQueue>();
            List<FiCaSchedulerApp> pendingApps = this.getSortedPendingApplications();
            HashMap<String, QueueCapacities> leafQueueEntitlements = new HashMap<String, QueueCapacities>();
            for (String nodeLabel : this.leafQueueTemplateNodeLabels) {
                float parentAbsoluteCapacity = this.managedParentQueue.getQueueCapacities().getAbsoluteCapacity(nodeLabel);
                float leafQueueTemplateAbsoluteCapacity = this.leafQueueTemplateCapacities.getAbsoluteCapacity(nodeLabel);
                Map<String, QueueCapacities> deactivatedLeafQueues = this.deactivateLeafQueuesIfInActive(this.managedParentQueue, nodeLabel, leafQueueEntitlements);
                if (LOG.isDebugEnabled() && deactivatedLeafQueues.size() > 0) {
                    LOG.debug("Parent queue = {},  , nodeLabel = {}, deactivated leaf queues = [{}] ", new Object[]{this.managedParentQueue.getQueueName(), nodeLabel, deactivatedLeafQueues.size() > 25 ? Integer.valueOf(deactivatedLeafQueues.size()) : deactivatedLeafQueues});
                }
                float deactivatedCapacity = this.getTotalDeactivatedCapacity(deactivatedLeafQueues, nodeLabel);
                float sumOfChildQueueActivatedCapacity = this.parentQueueState.getAbsoluteActivatedChildQueueCapacity(nodeLabel);
                float availableCapacity = parentAbsoluteCapacity - sumOfChildQueueActivatedCapacity + deactivatedCapacity + 1.0E-4f;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Parent queue = " + this.managedParentQueue.getQueueName() + ", nodeLabel = " + nodeLabel + ", absCapacity = " + parentAbsoluteCapacity + ", leafQueueAbsoluteCapacity = " + leafQueueTemplateAbsoluteCapacity + ", deactivatedCapacity = " + deactivatedCapacity + " , absChildActivatedCapacity = " + sumOfChildQueueActivatedCapacity + ", availableCapacity = " + availableCapacity);
                }
                if (!(availableCapacity >= leafQueueTemplateAbsoluteCapacity) || pendingApps.size() <= 0) continue;
                int maxLeafQueuesTobeActivated = this.getMaxLeavesToBeActivated(availableCapacity, leafQueueTemplateAbsoluteCapacity, pendingApps.size());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Parent queue = " + this.managedParentQueue.getQueueName() + " : Found " + maxLeafQueuesTobeActivated + " leaf queues to be activated with " + pendingApps.size() + " apps ");
                }
                LinkedHashSet<String> leafQueuesToBeActivated = this.getSortedLeafQueues(nodeLabel, pendingApps, maxLeafQueuesTobeActivated, deactivatedLeafQueues.keySet());
                this.updateLeafQueueCapacitiesByLabel(nodeLabel, leafQueuesToBeActivated, leafQueueEntitlements);
                if (!LOG.isDebugEnabled() || leafQueuesToBeActivated.size() <= 0) continue;
                LOG.debug("Activated leaf queues : [{}]", leafQueuesToBeActivated.size() < 25 ? leafQueuesToBeActivated : Integer.valueOf(leafQueuesToBeActivated.size()));
            }
            for (Map.Entry queueCapacities : leafQueueEntitlements.entrySet()) {
                String leafQueueName = (String)queueCapacities.getKey();
                AutoCreatedLeafQueue leafQueue = (AutoCreatedLeafQueue)this.scheduler.getCapacitySchedulerQueueManager().getQueue(leafQueueName);
                AutoCreatedLeafQueueConfig newTemplate = this.buildTemplate((QueueCapacities)queueCapacities.getValue());
                queueManagementChanges.add(new QueueManagementChange.UpdateQueue((CSQueue)leafQueue, newTemplate));
            }
            ArrayList<QueueManagementChange.UpdateQueue> arrayList = queueManagementChanges;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private float getTotalDeactivatedCapacity(Map<String, QueueCapacities> deactivatedLeafQueues, String nodeLabel) {
        float deactivatedCapacity = 0.0f;
        for (Map.Entry<String, QueueCapacities> deactivatedQueueCapacity : deactivatedLeafQueues.entrySet()) {
            deactivatedCapacity += deactivatedQueueCapacity.getValue().getAbsoluteCapacity(nodeLabel);
        }
        return deactivatedCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void updateLeafQueueState() {
        try {
            this.writeLock.lock();
            HashSet<String> newPartitions = new HashSet<String>();
            HashSet<String> newQueues = new HashSet<String>();
            for (CSQueue newQueue : this.managedParentQueue.getChildQueues()) {
                if (!(newQueue instanceof LeafQueue)) continue;
                for (String nodeLabel : this.leafQueueTemplateNodeLabels) {
                    this.leafQueueState.createLeafQueueStateIfNotExists((LeafQueue)newQueue, nodeLabel);
                    newPartitions.add(nodeLabel);
                }
                newQueues.add(newQueue.getQueueName());
            }
            Iterator<Map.Entry<String, Map<String, LeafQueueStatePerPartition>>> itr = this.leafQueueState.getLeafQueueStateMap().entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<String, Map<String, LeafQueueStatePerPartition>> e = itr.next();
                String partition = e.getKey();
                if (!newPartitions.contains(partition)) {
                    itr.remove();
                    LOG.info(this.managedParentQueue.getQueueName() + " : Removed partition " + partition + " from leaf queue state");
                    continue;
                }
                Map<String, LeafQueueStatePerPartition> queues = e.getValue();
                Iterator<Map.Entry<String, LeafQueueStatePerPartition>> queueItr = queues.entrySet().iterator();
                while (queueItr.hasNext()) {
                    String queue = queueItr.next().getKey();
                    if (newQueues.contains(queue)) continue;
                    queueItr.remove();
                    LOG.info(this.managedParentQueue.getQueueName() + " : Removed queue" + queue + " from leaf queue state from partition " + partition);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private LinkedHashSet<String> getSortedLeafQueues(String nodeLabel, List<FiCaSchedulerApp> pendingApps, int leafQueuesNeeded, Set<String> deactivatedQueues) throws SchedulerDynamicEditException {
        LinkedHashSet<String> leafQueues = new LinkedHashSet<String>(leafQueuesNeeded);
        int ctr = 0;
        for (FiCaSchedulerApp app : pendingApps) {
            AutoCreatedLeafQueue leafQueue = (AutoCreatedLeafQueue)app.getCSLeafQueue();
            String leafQueueName = leafQueue.getQueueName();
            if (ctr >= leafQueuesNeeded) break;
            if (this.isActive(leafQueue, nodeLabel) || deactivatedQueues.contains(leafQueueName) || !this.addLeafQueueIfNotExists(leafQueues, leafQueueName)) continue;
            ++ctr;
        }
        return leafQueues;
    }

    private boolean addLeafQueueIfNotExists(Set<String> leafQueues, String leafQueueName) {
        boolean ret = false;
        if (!leafQueues.contains(leafQueueName)) {
            ret = leafQueues.add(leafQueueName);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean isActive(AutoCreatedLeafQueue leafQueue, String nodeLabel) throws SchedulerDynamicEditException {
        try {
            this.readLock.lock();
            LeafQueueStatePerPartition leafQueueStatus = this.getLeafQueueState(leafQueue, nodeLabel);
            boolean bl = leafQueueStatus.isActive();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Map<String, QueueCapacities> deactivateLeafQueuesIfInActive(ParentQueue parentQueue, String nodeLabel, Map<String, QueueCapacities> leafQueueEntitlements) throws SchedulerDynamicEditException {
        HashMap<String, QueueCapacities> deactivatedQueues = new HashMap<String, QueueCapacities>();
        for (CSQueue childQueue : parentQueue.getChildQueues()) {
            AutoCreatedLeafQueue leafQueue = (AutoCreatedLeafQueue)childQueue;
            if (leafQueue != null) {
                if (!this.isActive(leafQueue, nodeLabel) || this.hasPendingApps(leafQueue)) continue;
                if (!leafQueueEntitlements.containsKey(leafQueue.getQueueName())) {
                    leafQueueEntitlements.put(leafQueue.getQueueName(), new QueueCapacities(false));
                }
                QueueCapacities capacities = leafQueueEntitlements.get(leafQueue.getQueueName());
                this.updateToZeroCapacity(capacities, nodeLabel);
                deactivatedQueues.put(leafQueue.getQueueName(), this.leafQueueTemplateCapacities);
                continue;
            }
            LOG.warn("Could not find queue in scheduler while trying to deactivate for " + parentQueue);
        }
        return deactivatedQueues;
    }

    private void updateLeafQueueCapacitiesByLabel(String nodeLabel, Set<String> leafQueuesToBeActivated, Map<String, QueueCapacities> leafQueueEntitlements) {
        for (String curLeafQueue : leafQueuesToBeActivated) {
            if (!leafQueueEntitlements.containsKey(curLeafQueue)) {
                leafQueueEntitlements.put(curLeafQueue, new QueueCapacities(false));
            }
            QueueCapacities capacities = leafQueueEntitlements.get(curLeafQueue);
            this.updateCapacityFromTemplate(capacities, nodeLabel);
        }
    }

    @VisibleForTesting
    public int getMaxLeavesToBeActivated(float availableCapacity, float childQueueAbsoluteCapacity, int numPendingApps) throws SchedulerDynamicEditException {
        if (childQueueAbsoluteCapacity > 0.0f) {
            int numLeafQueuesNeeded = (int)Math.floor(availableCapacity / childQueueAbsoluteCapacity);
            return Math.min(numLeafQueuesNeeded, numPendingApps);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitQueueManagementChanges(List<QueueManagementChange> queueManagementChanges) throws SchedulerDynamicEditException {
        try {
            this.writeLock.lock();
            for (QueueManagementChange queueManagementChange : queueManagementChanges) {
                AutoCreatedLeafQueueConfig updatedQueueTemplate = queueManagementChange.getUpdatedQueueTemplate();
                CSQueue queue = queueManagementChange.getQueue();
                if (!(queue instanceof AutoCreatedLeafQueue)) {
                    throw new SchedulerDynamicEditException("Expected queue management change for AutoCreatedLeafQueue. Found " + queue.getClass().getName());
                }
                AutoCreatedLeafQueue leafQueue = (AutoCreatedLeafQueue)queue;
                for (String nodeLabel : updatedQueueTemplate.getQueueCapacities().getExistingNodeLabels()) {
                    if (updatedQueueTemplate.getQueueCapacities().getCapacity(nodeLabel) > 0.0f) {
                        if (this.isActive(leafQueue, nodeLabel)) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug("Queue is already active. Skipping activation : " + leafQueue.getQueueName());
                            continue;
                        }
                        this.activate(leafQueue, nodeLabel);
                        continue;
                    }
                    if (!this.isActive(leafQueue, nodeLabel)) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Queue is already de-activated. Skipping de-activation : " + leafQueue.getQueueName());
                        continue;
                    }
                    this.deactivate(leafQueue, nodeLabel);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void activate(AbstractAutoCreatedLeafQueue leafQueue, String nodeLabel) throws SchedulerDynamicEditException {
        try {
            this.writeLock.lock();
            this.getLeafQueueState(leafQueue, nodeLabel).activate();
            this.parentQueueState.incAbsoluteActivatedChildCapacity(nodeLabel, this.leafQueueTemplateCapacities.getAbsoluteCapacity(nodeLabel));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void deactivate(AbstractAutoCreatedLeafQueue leafQueue, String nodeLabel) throws SchedulerDynamicEditException {
        try {
            this.writeLock.lock();
            this.getLeafQueueState(leafQueue, nodeLabel).deactivate();
            this.parentQueueState.decAbsoluteActivatedChildCapacity(nodeLabel, this.leafQueueTemplateCapacities.getAbsoluteCapacity(nodeLabel));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean hasPendingApps(AutoCreatedLeafQueue leafQueue) {
        return leafQueue.getNumApplications() > 0;
    }

    @Override
    public void reinitialize(CapacitySchedulerContext schedulerContext, ParentQueue parentQueue) throws IOException {
        if (!(parentQueue instanceof ManagedParentQueue)) {
            throw new IllegalStateException("Expected instance of type " + ManagedParentQueue.class + " found   : " + parentQueue.getClass());
        }
        if (this.managedParentQueue != null && !parentQueue.getQueuePath().equals(this.managedParentQueue.getQueuePath())) {
            throw new IllegalStateException("Expected parent queue path to match " + this.managedParentQueue.getQueuePath() + " found : " + parentQueue.getQueuePath());
        }
        this.managedParentQueue = (ManagedParentQueue)parentQueue;
        this.initializeLeafQueueTemplate(this.managedParentQueue);
        this.parentQueueState.clear();
        this.leafQueueState.clear();
        LOG.info("Reinitialized queue management policy for parent queue " + parentQueue.getQueueName() + " with leaf queue template capacities : [" + this.leafQueueTemplate.getQueueCapacities() + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AutoCreatedLeafQueueConfig getInitialLeafQueueConfiguration(AbstractAutoCreatedLeafQueue leafQueue) throws SchedulerDynamicEditException {
        AutoCreatedLeafQueueConfig template;
        if (!(leafQueue instanceof AutoCreatedLeafQueue)) {
            throw new SchedulerDynamicEditException("Not an instance of AutoCreatedLeafQueue : " + leafQueue.getClass());
        }
        try {
            this.writeLock.lock();
            QueueCapacities capacities = new QueueCapacities(false);
            for (String nodeLabel : this.leafQueueTemplateNodeLabels) {
                float availableCapacity;
                if (!this.leafQueueState.createLeafQueueStateIfNotExists(leafQueue, nodeLabel)) {
                    String message = "Leaf queue already exists in state : " + this.getLeafQueueState(leafQueue, nodeLabel);
                    LOG.error(message);
                }
                if ((availableCapacity = this.managedParentQueue.getQueueCapacities().getAbsoluteCapacity(nodeLabel) - this.parentQueueState.getAbsoluteActivatedChildQueueCapacity(nodeLabel) + 1.0E-4f) >= this.leafQueueTemplateCapacities.getAbsoluteCapacity(nodeLabel)) {
                    this.updateCapacityFromTemplate(capacities, nodeLabel);
                    this.activate(leafQueue, nodeLabel);
                    continue;
                }
                this.updateToZeroCapacity(capacities, nodeLabel);
            }
            template = this.buildTemplate(capacities);
        }
        finally {
            this.writeLock.unlock();
        }
        return template;
    }

    private void updateToZeroCapacity(QueueCapacities capacities, String nodeLabel) {
        capacities.setCapacity(nodeLabel, 0.0f);
        capacities.setMaximumCapacity(nodeLabel, this.leafQueueTemplateCapacities.getMaximumCapacity(nodeLabel));
    }

    private void updateCapacityFromTemplate(QueueCapacities capacities, String nodeLabel) {
        capacities.setCapacity(nodeLabel, this.leafQueueTemplateCapacities.getCapacity(nodeLabel));
        capacities.setMaximumCapacity(nodeLabel, this.leafQueueTemplateCapacities.getMaximumCapacity(nodeLabel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    LeafQueueStatePerPartition getLeafQueueState(LeafQueue queue, String partition) throws SchedulerDynamicEditException {
        try {
            this.readLock.lock();
            String queueName = queue.getQueueName();
            if (!this.leafQueueState.containsLeafQueue(queueName, partition)) {
                throw new SchedulerDynamicEditException("Could not find leaf queue in state " + queueName);
            }
            LeafQueueStatePerPartition leafQueueStatePerPartition = this.leafQueueState.getLeafQueueStatePerPartition(queueName, partition);
            return leafQueueStatePerPartition;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @VisibleForTesting
    public float getAbsoluteActivatedChildQueueCapacity(String nodeLabel) {
        return this.parentQueueState.getAbsoluteActivatedChildQueueCapacity(nodeLabel);
    }

    private List<FiCaSchedulerApp> getSortedPendingApplications() {
        ArrayList<FiCaSchedulerApp> apps = new ArrayList<FiCaSchedulerApp>(this.managedParentQueue.getAllApplications());
        Collections.sort(apps, this.applicationComparator);
        return apps;
    }

    private AutoCreatedLeafQueueConfig buildTemplate(QueueCapacities capacities) {
        AutoCreatedLeafQueueConfig.Builder templateBuilder = new AutoCreatedLeafQueueConfig.Builder();
        templateBuilder.capacities(capacities);
        return new AutoCreatedLeafQueueConfig(templateBuilder);
    }

    private class PendingApplicationComparator
    implements Comparator<FiCaSchedulerApp> {
        private PendingApplicationComparator() {
        }

        @Override
        public int compare(FiCaSchedulerApp app1, FiCaSchedulerApp app2) {
            RMApp rmApp1 = (RMApp)GuaranteedOrZeroCapacityOverTimePolicy.this.scheduler.getRMContext().getRMApps().get(app1.getApplicationId());
            RMApp rmApp2 = (RMApp)GuaranteedOrZeroCapacityOverTimePolicy.this.scheduler.getRMContext().getRMApps().get(app2.getApplicationId());
            if (rmApp1 != null && rmApp2 != null) {
                return Long.compare(rmApp1.getSubmitTime(), rmApp2.getSubmitTime());
            }
            if (rmApp1 != null) {
                return -1;
            }
            if (rmApp2 != null) {
                return 1;
            }
            return 0;
        }
    }

    private class ParentQueueState {
        private Map<String, Float> totalAbsoluteActivatedChildQueueCapacityByLabel = new HashMap<String, Float>();

        private ParentQueueState() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private float getAbsoluteActivatedChildQueueCapacity(String nodeLabel) {
            try {
                GuaranteedOrZeroCapacityOverTimePolicy.this.readLock.lock();
                Float totalActivatedCapacity = this.getAbsActivatedChildQueueCapacityByLabel(nodeLabel);
                if (totalActivatedCapacity != null) {
                    float f = totalActivatedCapacity.floatValue();
                    return f;
                }
                float f = 0.0f;
                return f;
            }
            finally {
                GuaranteedOrZeroCapacityOverTimePolicy.this.readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void incAbsoluteActivatedChildCapacity(String nodeLabel, float childQueueCapacity) {
            try {
                GuaranteedOrZeroCapacityOverTimePolicy.this.writeLock.lock();
                Float activatedChildCapacity = this.getAbsActivatedChildQueueCapacityByLabel(nodeLabel);
                if (activatedChildCapacity != null) {
                    this.setAbsActivatedChildQueueCapacityByLabel(nodeLabel, activatedChildCapacity.floatValue() + childQueueCapacity);
                } else {
                    this.setAbsActivatedChildQueueCapacityByLabel(nodeLabel, childQueueCapacity);
                }
            }
            finally {
                GuaranteedOrZeroCapacityOverTimePolicy.this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decAbsoluteActivatedChildCapacity(String nodeLabel, float childQueueCapacity) {
            try {
                GuaranteedOrZeroCapacityOverTimePolicy.this.writeLock.lock();
                Float activatedChildCapacity = this.getAbsActivatedChildQueueCapacityByLabel(nodeLabel);
                if (activatedChildCapacity != null) {
                    this.setAbsActivatedChildQueueCapacityByLabel(nodeLabel, activatedChildCapacity.floatValue() - childQueueCapacity);
                } else {
                    this.setAbsActivatedChildQueueCapacityByLabel(nodeLabel, childQueueCapacity);
                }
            }
            finally {
                GuaranteedOrZeroCapacityOverTimePolicy.this.writeLock.unlock();
            }
        }

        Float getAbsActivatedChildQueueCapacityByLabel(String label) {
            return this.totalAbsoluteActivatedChildQueueCapacityByLabel.get(label);
        }

        Float setAbsActivatedChildQueueCapacityByLabel(String label, float val) {
            return this.totalAbsoluteActivatedChildQueueCapacityByLabel.put(label, Float.valueOf(val));
        }

        void clear() {
            this.totalAbsoluteActivatedChildQueueCapacityByLabel.clear();
        }
    }

    private class LeafQueueStatePerPartition {
        private AtomicBoolean isActive = new AtomicBoolean(false);
        private long mostRecentActivationTime;
        private long mostRecentDeactivationTime;

        private LeafQueueStatePerPartition() {
        }

        public long getMostRecentActivationTime() {
            return this.mostRecentActivationTime;
        }

        public long getMostRecentDeactivationTime() {
            return this.mostRecentDeactivationTime;
        }

        public boolean isActive() {
            return this.isActive.get();
        }

        private boolean activate() {
            boolean ret = this.isActive.compareAndSet(false, true);
            this.mostRecentActivationTime = GuaranteedOrZeroCapacityOverTimePolicy.this.clock.getTime();
            return ret;
        }

        private boolean deactivate() {
            boolean ret = this.isActive.compareAndSet(true, false);
            this.mostRecentDeactivationTime = GuaranteedOrZeroCapacityOverTimePolicy.this.clock.getTime();
            return ret;
        }
    }

    private class LeafQueueState {
        private Map<String, Map<String, LeafQueueStatePerPartition>> leafQueueStateMap = new HashMap<String, Map<String, LeafQueueStatePerPartition>>();

        private LeafQueueState() {
        }

        public boolean containsLeafQueue(String leafQueueName, String partition) {
            if (this.leafQueueStateMap.containsKey(partition)) {
                return this.leafQueueStateMap.get(partition).containsKey(leafQueueName);
            }
            return false;
        }

        private boolean containsPartition(String partition) {
            return this.leafQueueStateMap.containsKey(partition);
        }

        private boolean addLeafQueueStateIfNotExists(String leafQueueName, String partition, LeafQueueStatePerPartition leafQueueState) {
            if (!this.containsPartition(partition)) {
                this.leafQueueStateMap.put(partition, new HashMap());
            }
            if (!this.containsLeafQueue(leafQueueName, partition)) {
                this.leafQueueStateMap.get(partition).put(leafQueueName, leafQueueState);
                return true;
            }
            return false;
        }

        public boolean createLeafQueueStateIfNotExists(LeafQueue leafQueue, String partition) {
            return this.addLeafQueueStateIfNotExists(leafQueue.getQueueName(), partition, new LeafQueueStatePerPartition());
        }

        public LeafQueueStatePerPartition getLeafQueueStatePerPartition(String leafQueueName, String partition) {
            if (this.leafQueueStateMap.get(partition) != null) {
                return this.leafQueueStateMap.get(partition).get(leafQueueName);
            }
            return null;
        }

        public Map<String, Map<String, LeafQueueStatePerPartition>> getLeafQueueStateMap() {
            return this.leafQueueStateMap;
        }

        private void clear() {
            this.leafQueueStateMap.clear();
        }
    }
}

