/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.slf4j.Logger;

public class SchedulerAppUtils {
    public static boolean isPlaceBlacklisted(SchedulerApplicationAttempt application, SchedulerNode node, Logger log) {
        if (application.isPlaceBlacklisted(node.getNodeName())) {
            if (log.isDebugEnabled()) {
                log.debug("Skipping 'host' " + node.getNodeName() + " for " + application.getApplicationId() + " since it has been blacklisted");
            }
            return true;
        }
        if (application.isPlaceBlacklisted(node.getRackName())) {
            if (log.isDebugEnabled()) {
                log.debug("Skipping 'rack' " + node.getRackName() + " for " + application.getApplicationId() + " since it has been blacklisted");
            }
            return true;
        }
        return false;
    }
}

