/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.nodemanager.LinuxContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsCpuResourceHandlerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsMountConfig;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerModule;
import org.apache.hadoop.yarn.server.nodemanager.util.LCEResourcesHandler;
import org.apache.hadoop.yarn.server.nodemanager.util.NodeManagerHardwareUtils;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ResourceCalculatorPlugin;
import org.apache.hadoop.yarn.util.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CgroupsLCEResourcesHandler
implements LCEResourcesHandler {
    static final Logger LOG = LoggerFactory.getLogger(CgroupsLCEResourcesHandler.class);
    private Configuration conf;
    private String cgroupPrefix;
    private CGroupsMountConfig cGroupsMountConfig;
    private boolean cpuWeightEnabled = true;
    private boolean strictResourceUsageMode = false;
    private final String MTAB_FILE = "/proc/mounts";
    private final String CGROUPS_FSTYPE = "cgroup";
    private final String CONTROLLER_CPU = "cpu";
    private final String CPU_PERIOD_US = "cfs_period_us";
    private final String CPU_QUOTA_US = "cfs_quota_us";
    private final int CPU_DEFAULT_WEIGHT = 1024;
    private final Map<String, String> controllerPaths = new HashMap<String, String>();
    private long deleteCgroupTimeout;
    private long deleteCgroupDelay;
    @VisibleForTesting
    Clock clock = SystemClock.getInstance();
    private float yarnProcessors;
    private int nodeVCores;
    private static final Pattern MTAB_FILE_FORMAT = Pattern.compile("^[^\\s]+\\s([^\\s]+)\\s([^\\s]+)\\s([^\\s]+)\\s[^\\s]+\\s[^\\s]+$");

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @VisibleForTesting
    void initConfig() throws IOException {
        this.cgroupPrefix = this.conf.get("yarn.nodemanager.linux-container-executor.cgroups.hierarchy", "/hadoop-yarn");
        this.cGroupsMountConfig = new CGroupsMountConfig(this.conf);
        this.deleteCgroupTimeout = this.conf.getLong("yarn.nodemanager.linux-container-executor.cgroups.delete-timeout-ms", 1000L);
        this.deleteCgroupDelay = this.conf.getLong("yarn.nodemanager.linux-container-executor.cgroups.delete-delay-ms", 20L);
        if (this.cgroupPrefix.charAt(0) == '/') {
            this.cgroupPrefix = this.cgroupPrefix.substring(1);
        }
        this.strictResourceUsageMode = this.conf.getBoolean("yarn.nodemanager.linux-container-executor.cgroups.strict-resource-usage", false);
        int len = this.cgroupPrefix.length();
        if (this.cgroupPrefix.charAt(len - 1) == '/') {
            this.cgroupPrefix = this.cgroupPrefix.substring(0, len - 1);
        }
    }

    @Override
    public void init(LinuxContainerExecutor lce) throws IOException {
        this.init(lce, ResourceCalculatorPlugin.getResourceCalculatorPlugin(null, (Configuration)this.conf));
    }

    @VisibleForTesting
    void init(LinuxContainerExecutor lce, ResourceCalculatorPlugin plugin) throws IOException {
        this.initConfig();
        if (this.cGroupsMountConfig.mountEnabledAndMountPathDefined()) {
            ArrayList<String> cgroupKVs = new ArrayList<String>();
            cgroupKVs.add("cpu=" + this.cGroupsMountConfig.getMountPath() + "/" + "cpu");
            lce.mountCgroups(cgroupKVs, this.cgroupPrefix);
        }
        this.initializeControllerPaths();
        this.nodeVCores = NodeManagerHardwareUtils.getVCores(plugin, this.conf);
        this.yarnProcessors = NodeManagerHardwareUtils.getContainersCPUs(plugin, this.conf);
        int systemProcessors = NodeManagerHardwareUtils.getNodeCPUs(plugin, this.conf);
        if (systemProcessors != (int)this.yarnProcessors) {
            LOG.info("YARN containers restricted to " + this.yarnProcessors + " cores");
            int[] limits = this.getOverallLimits(this.yarnProcessors);
            this.updateCgroup("cpu", "", "cfs_period_us", String.valueOf(limits[0]));
            this.updateCgroup("cpu", "", "cfs_quota_us", String.valueOf(limits[1]));
        } else if (CGroupsCpuResourceHandlerImpl.cpuLimitsExist(this.pathForCgroup("cpu", ""))) {
            LOG.info("Removing CPU constraints for YARN containers.");
            this.updateCgroup("cpu", "", "cfs_quota_us", String.valueOf(-1));
        }
    }

    int[] getOverallLimits(float yarnProcessorsArg) {
        return CGroupsCpuResourceHandlerImpl.getOverallLimits(yarnProcessorsArg);
    }

    boolean isCpuWeightEnabled() {
        return this.cpuWeightEnabled;
    }

    private String pathForCgroup(String controller, String groupName) {
        String controllerPath = this.controllerPaths.get(controller);
        return controllerPath + "/" + this.cgroupPrefix + "/" + groupName;
    }

    private void createCgroup(String controller, String groupName) throws IOException {
        String path = this.pathForCgroup(controller, groupName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("createCgroup: " + path);
        }
        if (!new File(path).mkdir()) {
            throw new IOException("Failed to create cgroup at " + path);
        }
    }

    private void updateCgroup(String controller, String groupName, String param, String value) throws IOException {
        String path = this.pathForCgroup(controller, groupName);
        param = controller + "." + param;
        if (LOG.isDebugEnabled()) {
            LOG.debug("updateCgroup: " + path + ": " + param + "=" + value);
        }
        PrintWriter pw = null;
        try {
            File file = new File(path + "/" + param);
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            pw = new PrintWriter(w);
            pw.write(value);
        }
        catch (IOException e) {
            throw new IOException("Unable to set " + param + "=" + value + " for cgroup at: " + path, e);
        }
        finally {
            if (pw != null) {
                boolean hasError = pw.checkError();
                pw.close();
                if (hasError) {
                    throw new IOException("Unable to set " + param + "=" + value + " for cgroup at: " + path);
                }
                if (pw.checkError()) {
                    throw new IOException("Error while closing cgroup file " + path);
                }
            }
        }
    }

    private void logLineFromTasksFile(File cgf) {
        if (LOG.isDebugEnabled()) {
            try (BufferedReader inl = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(cgf + "/tasks"), "UTF-8"));){
                String str = inl.readLine();
                if (str != null) {
                    LOG.debug("First line in cgroup tasks file: " + cgf + " " + str);
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to read cgroup tasks file. ", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    boolean checkAndDeleteCgroup(File cgf) throws InterruptedException {
        boolean deleted = false;
        try (FileInputStream in = new FileInputStream(cgf + "/tasks");){
            if (in.read() == -1) {
                Thread.sleep(this.deleteCgroupDelay);
                deleted = cgf.delete();
                if (!deleted) {
                    LOG.warn("Failed attempt to delete cgroup: " + cgf);
                }
            } else {
                this.logLineFromTasksFile(cgf);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to read cgroup tasks file. ", (Throwable)e);
        }
        return deleted;
    }

    @VisibleForTesting
    boolean deleteCgroup(String cgroupPath) {
        boolean deleted = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("deleteCgroup: " + cgroupPath);
        }
        long start = this.clock.getTime();
        do {
            try {
                deleted = this.checkAndDeleteCgroup(new File(cgroupPath));
                if (deleted) continue;
                Thread.sleep(this.deleteCgroupDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!deleted && this.clock.getTime() - start < this.deleteCgroupTimeout);
        if (!deleted) {
            LOG.warn("Unable to delete cgroup at: " + cgroupPath + ", tried to delete for " + this.deleteCgroupTimeout + "ms");
        }
        return deleted;
    }

    private void setupLimits(ContainerId containerId, Resource containerResource) throws IOException {
        String containerName = containerId.toString();
        if (this.isCpuWeightEnabled()) {
            int containerVCores = containerResource.getVirtualCores();
            this.createCgroup("cpu", containerName);
            int cpuShares = 1024 * containerVCores;
            this.updateCgroup("cpu", containerName, "shares", String.valueOf(cpuShares));
            if (this.strictResourceUsageMode && this.nodeVCores != containerVCores) {
                float containerCPU = (float)containerVCores * this.yarnProcessors / (float)this.nodeVCores;
                int[] limits = this.getOverallLimits(containerCPU);
                this.updateCgroup("cpu", containerName, "cfs_period_us", String.valueOf(limits[0]));
                this.updateCgroup("cpu", containerName, "cfs_quota_us", String.valueOf(limits[1]));
            }
        }
    }

    private void clearLimits(ContainerId containerId) {
        if (this.isCpuWeightEnabled()) {
            this.deleteCgroup(this.pathForCgroup("cpu", containerId.toString()));
        }
    }

    @Override
    public void preExecute(ContainerId containerId, Resource containerResource) throws IOException {
        this.setupLimits(containerId, containerResource);
    }

    @Override
    public void postExecute(ContainerId containerId) {
        this.clearLimits(containerId);
    }

    @Override
    public String getResourcesOption(ContainerId containerId) {
        String containerName = containerId.toString();
        StringBuilder sb = new StringBuilder("cgroups=");
        if (this.isCpuWeightEnabled()) {
            sb.append(this.pathForCgroup("cpu", containerName) + "/tasks");
            sb.append('%');
        }
        if (sb.charAt(sb.length() - 1) == '%') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private Map<String, Set<String>> parseMtab() throws IOException {
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        BufferedReader in = null;
        Set<String> validCgroups = CGroupsHandler.CGroupController.getValidCGroups();
        try {
            FileInputStream fis = new FileInputStream(new File(this.getMtabFileName()));
            in = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            String str = in.readLine();
            while (str != null) {
                Matcher m = MTAB_FILE_FORMAT.matcher(str);
                boolean mat = m.find();
                if (mat) {
                    String path = m.group(1);
                    String type = m.group(2);
                    String options = m.group(3);
                    if (type.equals("cgroup")) {
                        HashSet<String> cgroupList = new HashSet<String>(Arrays.asList(options.split(",")));
                        cgroupList.retainAll(validCgroups);
                        ret.put(path, cgroupList);
                    }
                }
                str = in.readLine();
            }
        }
        catch (IOException e) {
            try {
                throw new IOException("Error while reading " + this.getMtabFileName(), e);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
                throw throwable;
            }
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
        return ret;
    }

    @VisibleForTesting
    String findControllerInMtab(String controller, Map<String, Set<String>> entries) {
        for (Map.Entry<String, Set<String>> e : entries.entrySet()) {
            if (!e.getValue().contains(controller)) continue;
            if (new File(e.getKey()).canRead()) {
                return e.getKey();
            }
            LOG.warn(String.format("Skipping inaccessible cgroup mount point %s", e.getKey()));
        }
        return null;
    }

    private void initializeControllerPaths() throws IOException {
        String controllerPath;
        Map<String, Set<String>> parsedMtab = null;
        if (this.cGroupsMountConfig.mountDisabledButMountPathDefined()) {
            parsedMtab = ResourceHandlerModule.parseConfiguredCGroupPath(this.cGroupsMountConfig.getMountPath());
        }
        if (parsedMtab == null) {
            parsedMtab = this.parseMtab();
        }
        if ((controllerPath = this.findControllerInMtab("cpu", parsedMtab)) != null) {
            File f = new File(controllerPath + "/" + this.cgroupPrefix);
            if (!FileUtil.canWrite((File)f)) {
                throw new IOException("Not able to enforce cpu weights; cannot write to cgroup at: " + f.getPath());
            }
        } else {
            throw new IOException("Not able to enforce cpu weights; cannot find cgroup for cpu controller in " + this.getMtabFileName());
        }
        this.controllerPaths.put("cpu", controllerPath);
    }

    @VisibleForTesting
    String getMtabFileName() {
        return "/proc/mounts";
    }

    @VisibleForTesting
    Map<String, String> getControllerPaths() {
        return Collections.unmodifiableMap(this.controllerPaths);
    }
}

