/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.mapreduce.replication.VerifyReplication;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestVerifyReplicationCrossDiffHdfs {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestVerifyReplicationCrossDiffHdfs.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestVerifyReplicationCrossDiffHdfs.class);
    private static HBaseTestingUtil util1;
    private static HBaseTestingUtil util2;
    private static HBaseTestingUtil mapReduceUtil;
    private static Configuration conf1;
    private static Configuration conf2;
    private static final byte[] FAMILY;
    private static final byte[] QUALIFIER;
    private static final String PEER_ID = "1";
    private static final TableName TABLE_NAME;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf1.set("zookeeper.znode.parent", "/1");
        util1 = new HBaseTestingUtil(conf1);
        util1.startMiniZKCluster();
        MiniZooKeeperCluster miniZK = util1.getZkCluster();
        conf1 = util1.getConfiguration();
        conf2 = HBaseConfiguration.create((Configuration)conf1);
        conf2.set("zookeeper.znode.parent", "/2");
        util2 = new HBaseTestingUtil(conf2);
        util2.setZkCluster(miniZK);
        util1.startMiniCluster();
        util2.startMiniCluster();
        TestVerifyReplicationCrossDiffHdfs.createTestingTable(util1.getAdmin());
        TestVerifyReplicationCrossDiffHdfs.createTestingTable(util2.getAdmin());
        TestVerifyReplicationCrossDiffHdfs.addTestingPeer();
        LOG.info("Start to load some data to source cluster.");
        TestVerifyReplicationCrossDiffHdfs.loadSomeData();
        LOG.info("Start mini MapReduce cluster.");
        mapReduceUtil.setZkCluster(miniZK);
        mapReduceUtil.startMiniMapReduceCluster();
    }

    private static void createTestingTable(Admin admin) throws IOException {
        TableDescriptor table = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).setMaxVersions(100).setScope(1).build()).build();
        admin.createTable(table);
    }

    private static void addTestingPeer() throws IOException {
        ReplicationPeerConfig rpc = ReplicationPeerConfig.newBuilder().setClusterKey(util2.getClusterKey()).setReplicateAllUserTables(false).setTableCFsMap((Map)ImmutableMap.of((Object)TABLE_NAME, (Object)ImmutableList.of())).build();
        util1.getAdmin().addReplicationPeer(PEER_ID, rpc);
    }

    private static void loadSomeData() throws IOException, InterruptedException {
        int numOfRows = 10;
        try (Table table = util1.getConnection().getTable(TABLE_NAME);){
            for (int i = 0; i < numOfRows; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(FAMILY, QUALIFIER, Bytes.toBytes((int)i)));
            }
        }
        Result[] results = null;
        try (Table table = util2.getConnection().getTable(TABLE_NAME);){
            for (int i = 0; i < 100; ++i) {
                try (ResultScanner rs = table.getScanner(new Scan());){
                    results = rs.next(numOfRows);
                    if (results != null && results.length >= numOfRows) continue;
                    LOG.info("Retrying, wait until the peer received all the rows, currentRows:" + (results == null ? 0 : results.length));
                    Thread.sleep(100L);
                    continue;
                }
            }
        }
        Assert.assertNotNull(results);
        Assert.assertEquals((long)10L, (long)results.length);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (mapReduceUtil != null) {
            mapReduceUtil.shutdownMiniCluster();
        }
        if (util2 != null) {
            util2.shutdownMiniCluster();
        }
        if (util1 != null) {
            util1.shutdownMiniCluster();
        }
    }

    @Test
    public void testVerifyRepBySnapshot() throws Exception {
        Path rootDir = CommonFSUtils.getRootDir((Configuration)conf1);
        FileSystem fs = rootDir.getFileSystem(conf1);
        String sourceSnapshotName = "sourceSnapshot-" + EnvironmentEdgeManager.currentTime();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)util1.getAdmin(), (TableName)TABLE_NAME, (String)Bytes.toString((byte[])FAMILY), (String)sourceSnapshotName, (Path)rootDir, (FileSystem)fs, (boolean)true);
        Path peerRootDir = CommonFSUtils.getRootDir((Configuration)conf2);
        FileSystem peerFs = peerRootDir.getFileSystem(conf2);
        String peerSnapshotName = "peerSnapshot-" + EnvironmentEdgeManager.currentTime();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)util2.getAdmin(), (TableName)TABLE_NAME, (String)Bytes.toString((byte[])FAMILY), (String)peerSnapshotName, (Path)peerRootDir, (FileSystem)peerFs, (boolean)true);
        String peerFSAddress = peerFs.getUri().toString();
        String temPath1 = new Path(fs.getUri().toString(), "/tmp1").toString();
        String temPath2 = "/tmp2";
        String[] args = new String[]{"--sourceSnapshotName=" + sourceSnapshotName, "--sourceSnapshotTmpDir=" + temPath1, "--peerSnapshotName=" + peerSnapshotName, "--peerSnapshotTmpDir=" + temPath2, "--peerFSAddress=" + peerFSAddress, "--peerHBaseRootAddress=" + CommonFSUtils.getRootDir((Configuration)conf2), PEER_ID, TABLE_NAME.toString()};
        Configuration newConf = HBaseConfiguration.create((Configuration)conf1);
        HBaseConfiguration.merge((Configuration)newConf, (Configuration)mapReduceUtil.getConfiguration());
        newConf.set("zookeeper.znode.parent", "/1");
        CommonFSUtils.setRootDir((Configuration)newConf, (Path)CommonFSUtils.getRootDir((Configuration)conf1));
        Job job = new VerifyReplication().createSubmittableJob(newConf, args);
        if (job == null) {
            Assert.fail((String)"Job wasn't created, see the log");
        }
        if (!job.waitForCompletion(true)) {
            Assert.fail((String)"Job failed, see the log");
        }
        Assert.assertEquals((long)10L, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.GOODROWS).getValue());
        Assert.assertEquals((long)0L, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.BADROWS).getValue());
    }

    static {
        mapReduceUtil = new HBaseTestingUtil();
        conf1 = HBaseConfiguration.create();
        FAMILY = Bytes.toBytes((String)"f");
        QUALIFIER = Bytes.toBytes((String)"q");
        TABLE_NAME = TableName.valueOf((String)"testVerifyRepCrossDiffHDFS");
    }
}

