/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.SimpleTotalOrderPartitioner;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MapReduceTests.class, SmallTests.class})
public class TestSimpleTotalOrderPartitioner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSimpleTotalOrderPartitioner.class);
    protected static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    Configuration conf = TEST_UTIL.getConfiguration();

    @Test
    public void testSplit() throws Exception {
        String start = "a";
        String end = "{";
        SimpleTotalOrderPartitioner p = new SimpleTotalOrderPartitioner();
        this.conf.set("hbase.simpletotalorder.start", start);
        this.conf.set("hbase.simpletotalorder.end", end);
        p.setConf(this.conf);
        ImmutableBytesWritable c = new ImmutableBytesWritable(Bytes.toBytes((String)"c"));
        int partition = p.getPartition(c, (Object)HConstants.EMPTY_BYTE_ARRAY, 1);
        Assert.assertEquals((long)0L, (long)partition);
        partition = p.getPartition(c, (Object)HConstants.EMPTY_BYTE_ARRAY, 2);
        Assert.assertEquals((long)0L, (long)partition);
        partition = p.getPartition(c, (Object)HConstants.EMPTY_BYTE_ARRAY, 3);
        Assert.assertEquals((long)0L, (long)partition);
        ImmutableBytesWritable q = new ImmutableBytesWritable(Bytes.toBytes((String)"q"));
        partition = p.getPartition(q, (Object)HConstants.EMPTY_BYTE_ARRAY, 2);
        Assert.assertEquals((long)1L, (long)partition);
        partition = p.getPartition(q, (Object)HConstants.EMPTY_BYTE_ARRAY, 3);
        Assert.assertEquals((long)2L, (long)partition);
        ImmutableBytesWritable startBytes = new ImmutableBytesWritable(Bytes.toBytes((String)start));
        partition = p.getPartition(startBytes, (Object)HConstants.EMPTY_BYTE_ARRAY, 2);
        Assert.assertEquals((long)0L, (long)partition);
        partition = p.getPartition(startBytes, (Object)HConstants.EMPTY_BYTE_ARRAY, 3);
        Assert.assertEquals((long)0L, (long)partition);
        ImmutableBytesWritable endBytes = new ImmutableBytesWritable(Bytes.toBytes((String)"z"));
        partition = p.getPartition(endBytes, (Object)HConstants.EMPTY_BYTE_ARRAY, 2);
        Assert.assertEquals((long)1L, (long)partition);
        partition = p.getPartition(endBytes, (Object)HConstants.EMPTY_BYTE_ARRAY, 3);
        Assert.assertEquals((long)2L, (long)partition);
    }
}

