/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.hfile.CorruptHFileException;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionScannerImpl;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.AbstractTestWALReplay;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALSplitUtil;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestWALSplitToHFile {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALSplitToHFile.class);
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTestWALReplay.class);
    static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private final EnvironmentEdge ee = EnvironmentEdgeManager.getDelegate();
    private Path rootDir = null;
    private String logName;
    private Path oldLogDir;
    private Path logDir;
    private FileSystem fs;
    private Configuration conf;
    private WALFactory wals;
    private static final byte[] ROW = Bytes.toBytes((String)"row");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");
    private static final byte[] VALUE1 = Bytes.toBytes((String)"value1");
    private static final byte[] VALUE2 = Bytes.toBytes((String)"value2");
    private static final int countPerFamily = 10;
    @Rule
    public final TestName TEST_NAME = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setBoolean("hbase.wal.split.to.hfile", true);
        UTIL.startMiniCluster(3);
        Path hbaseRootDir = UTIL.getDFSCluster().getFileSystem().makeQualified(new Path("/hbase"));
        LOG.info("hbase.rootdir=" + hbaseRootDir);
        CommonFSUtils.setRootDir((Configuration)conf, (Path)hbaseRootDir);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.conf = HBaseConfiguration.create((Configuration)UTIL.getConfiguration());
        this.conf.setBoolean("hbase.hregion.edits.replay.skip.errors", false);
        this.fs = UTIL.getDFSCluster().getFileSystem();
        this.rootDir = CommonFSUtils.getRootDir((Configuration)this.conf);
        this.oldLogDir = new Path(this.rootDir, "oldWALs");
        String serverName = ServerName.valueOf((String)(this.TEST_NAME.getMethodName() + "-manual"), (int)16010, (long)EnvironmentEdgeManager.currentTime()).toString();
        this.logName = AbstractFSWALProvider.getWALDirectoryName((String)serverName);
        this.logDir = new Path(this.rootDir, this.logName);
        if (UTIL.getDFSCluster().getFileSystem().exists(this.rootDir)) {
            UTIL.getDFSCluster().getFileSystem().delete(this.rootDir, true);
        }
        this.wals = new WALFactory(this.conf, this.TEST_NAME.getMethodName());
    }

    @After
    public void tearDown() throws Exception {
        this.wals.close();
        UTIL.getDFSCluster().getFileSystem().delete(this.rootDir, true);
    }

    private void deleteDir(Path p) throws IOException {
        if (this.fs.exists(p) && !this.fs.delete(p, true)) {
            throw new IOException("Failed remove of " + p);
        }
    }

    private TableDescriptor createBasic3FamilyTD(TableName tableName) throws IOException {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        builder.setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"a")).build());
        builder.setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"b")).build());
        builder.setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"c")).build());
        TableDescriptor td = builder.build();
        UTIL.getAdmin().createTable(td);
        return td;
    }

    private WAL createWAL(Configuration c, Path hbaseRootDir, String logName) throws IOException {
        FSHLog wal = new FSHLog(FileSystem.get((Configuration)c), hbaseRootDir, logName, c);
        wal.init();
        return wal;
    }

    private WAL createWAL(FileSystem fs, Path hbaseRootDir, String logName) throws IOException {
        FSHLog wal = new FSHLog(fs, hbaseRootDir, logName, this.conf);
        wal.init();
        return wal;
    }

    private Pair<TableDescriptor, RegionInfo> setupTableAndRegion() throws IOException {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        TableDescriptor td = this.createBasic3FamilyTD(tableName);
        RegionInfo ri = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        Path tableDir = CommonFSUtils.getTableDir((Path)this.rootDir, (TableName)tableName);
        this.deleteDir(tableDir);
        FSTableDescriptors.createTableDescriptorForTableDirectory((FileSystem)this.fs, (Path)tableDir, (TableDescriptor)td, (boolean)false);
        HRegion region = HBaseTestingUtil.createRegionAndWAL(ri, this.rootDir, this.conf, td);
        HBaseTestingUtil.closeRegionAndWAL(region);
        return new Pair((Object)td, (Object)ri);
    }

    private void writeData(TableDescriptor td, HRegion region) throws IOException {
        long timestamp = this.ee.currentTime();
        for (ColumnFamilyDescriptor cfd : td.getColumnFamilies()) {
            region.put(new Put(ROW).addColumn(cfd.getName(), QUALIFIER, timestamp, VALUE1));
        }
    }

    @Test
    public void testDifferentRootDirAndWALRootDir() throws Exception {
        Path walRootDir = UTIL.createWALRootDir();
        this.conf = HBaseConfiguration.create((Configuration)UTIL.getConfiguration());
        FileSystem walFs = CommonFSUtils.getWALFileSystem((Configuration)this.conf);
        this.oldLogDir = new Path(walRootDir, "oldWALs");
        String serverName = ServerName.valueOf((String)(this.TEST_NAME.getMethodName() + "-manual"), (int)16010, (long)EnvironmentEdgeManager.currentTime()).toString();
        this.logName = AbstractFSWALProvider.getWALDirectoryName((String)serverName);
        this.logDir = new Path(walRootDir, this.logName);
        this.wals = new WALFactory(this.conf, this.TEST_NAME.getMethodName());
        Pair<TableDescriptor, RegionInfo> pair = this.setupTableAndRegion();
        TableDescriptor td = (TableDescriptor)pair.getFirst();
        RegionInfo ri = (RegionInfo)pair.getSecond();
        WAL wal = this.createWAL(walFs, walRootDir, this.logName);
        HRegion region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.rootDir, (RegionInfo)ri, (TableDescriptor)td, (WAL)wal);
        this.writeData(td, region);
        region.close(true);
        wal.shutdown();
        WALSplitter.split((Path)walRootDir, (Path)this.logDir, (Path)this.oldLogDir, (FileSystem)FileSystem.get((Configuration)this.conf), (Configuration)this.conf, (WALFactory)this.wals);
        WAL wal2 = this.createWAL(walFs, walRootDir, this.logName);
        HRegion region2 = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.rootDir, (RegionInfo)ri, (TableDescriptor)td, (WAL)wal2);
        Result result2 = region2.get(new Get(ROW));
        Assert.assertEquals((long)td.getColumnFamilies().length, (long)result2.size());
        for (ColumnFamilyDescriptor cfd : td.getColumnFamilies()) {
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE1, (byte[])result2.getValue(cfd.getName(), QUALIFIER)));
        }
    }

    @Test
    public void testCorruptRecoveredHFile() throws Exception {
        Pair<TableDescriptor, RegionInfo> pair = this.setupTableAndRegion();
        TableDescriptor td = (TableDescriptor)pair.getFirst();
        RegionInfo ri = (RegionInfo)pair.getSecond();
        WAL wal = this.createWAL(this.conf, this.rootDir, this.logName);
        HRegion region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.rootDir, (RegionInfo)ri, (TableDescriptor)td, (WAL)wal);
        this.writeData(td, region);
        region.close(true);
        wal.shutdown();
        WALSplitter.split((Path)this.rootDir, (Path)this.logDir, (Path)this.oldLogDir, (FileSystem)FileSystem.get((Configuration)this.conf), (Configuration)this.conf, (WALFactory)this.wals);
        Path regionDir = new Path(CommonFSUtils.getTableDir((Path)this.rootDir, (TableName)td.getTableName()), ri.getEncodedName());
        for (ColumnFamilyDescriptor cfd : td.getColumnFamilies()) {
            FileStatus[] files = WALSplitUtil.getRecoveredHFiles((FileSystem)this.fs, (Path)regionDir, (String)cfd.getNameAsString());
            Assert.assertNotNull((Object)files);
            Assert.assertTrue((files.length > 0 ? 1 : 0) != 0);
            this.writeCorruptRecoveredHFile(files[0].getPath());
        }
        WAL wal2 = this.createWAL(this.conf, this.rootDir, this.logName);
        try {
            HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.rootDir, (RegionInfo)ri, (TableDescriptor)td, (WAL)wal2);
            Assert.fail((String)"Should fail to open region");
        }
        catch (CorruptHFileException corruptHFileException) {
            // empty catch block
        }
        this.conf.setBoolean("hbase.hregion.edits.replay.skip.errors", true);
        HRegion region2 = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.rootDir, (RegionInfo)ri, (TableDescriptor)td, (WAL)wal2);
        Result result2 = region2.get(new Get(ROW));
        Assert.assertEquals((long)td.getColumnFamilies().length, (long)result2.size());
        for (ColumnFamilyDescriptor cfd : td.getColumnFamilies()) {
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE1, (byte[])result2.getValue(cfd.getName(), QUALIFIER)));
            FileStatus[] files = WALSplitUtil.getRecoveredHFiles((FileSystem)this.fs, (Path)regionDir, (String)cfd.getNameAsString());
            Assert.assertNotNull((Object)files);
            Assert.assertEquals((long)1L, (long)files.length);
            Assert.assertTrue((boolean)files[0].getPath().getName().contains("corrupt"));
        }
    }

    @Test
    public void testPutWithSameTimestamp() throws Exception {
        Pair<TableDescriptor, RegionInfo> pair = this.setupTableAndRegion();
        TableDescriptor td = (TableDescriptor)pair.getFirst();
        RegionInfo ri = (RegionInfo)pair.getSecond();
        WAL wal = this.createWAL(this.conf, this.rootDir, this.logName);
        HRegion region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.rootDir, (RegionInfo)ri, (TableDescriptor)td, (WAL)wal);
        long timestamp = this.ee.currentTime();
        for (ColumnFamilyDescriptor cfd : td.getColumnFamilies()) {
            region.put(new Put(ROW).addColumn(cfd.getName(), QUALIFIER, timestamp, VALUE1));
        }
        region.flush(true);
        for (ColumnFamilyDescriptor cfd : td.getColumnFamilies()) {
            region.put(new Put(ROW).addColumn(cfd.getName(), QUALIFIER, timestamp, VALUE2));
        }
        region.close(true);
        wal.shutdown();
        WALSplitter.split((Path)this.rootDir, (Path)this.logDir, (Path)this.oldLogDir, (FileSystem)FileSystem.get((Configuration)this.conf), (Configuration)this.conf, (WALFactory)this.wals);
        WAL wal2 = this.createWAL(this.conf, this.rootDir, this.logName);
        HRegion region2 = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.rootDir, (RegionInfo)ri, (TableDescriptor)td, (WAL)wal2);
        Result result2 = region2.get(new Get(ROW));
        Assert.assertEquals((long)td.getColumnFamilies().length, (long)result2.size());
        for (ColumnFamilyDescriptor cfd : td.getColumnFamilies()) {
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE2, (byte[])result2.getValue(cfd.getName(), QUALIFIER)));
        }
    }

    @Test
    public void testRecoverSequenceId() throws Exception {
        Pair<TableDescriptor, RegionInfo> pair = this.setupTableAndRegion();
        TableDescriptor td = (TableDescriptor)pair.getFirst();
        RegionInfo ri = (RegionInfo)pair.getSecond();
        WAL wal = this.createWAL(this.conf, this.rootDir, this.logName);
        HRegion region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.rootDir, (RegionInfo)ri, (TableDescriptor)td, (WAL)wal);
        HashMap<Integer, Map> seqIdMap = new HashMap<Integer, Map>();
        for (int i = 0; i < 10; ++i) {
            for (ColumnFamilyDescriptor cfd : td.getColumnFamilies()) {
                region.put(new Put(Bytes.toBytes((int)i)).addColumn(cfd.getName(), QUALIFIER, VALUE1));
                Result result = region.get(new Get(Bytes.toBytes((int)i)).addFamily(cfd.getName()));
                Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE1, (byte[])result.getValue(cfd.getName(), QUALIFIER)));
                List cells = result.listCells();
                Assert.assertEquals((long)1L, (long)cells.size());
                seqIdMap.computeIfAbsent(i, r -> new HashMap()).put(cfd.getNameAsString(), ((Cell)cells.get(0)).getSequenceId());
            }
        }
        region.close(true);
        wal.shutdown();
        WALSplitter.split((Path)this.rootDir, (Path)this.logDir, (Path)this.oldLogDir, (FileSystem)FileSystem.get((Configuration)this.conf), (Configuration)this.conf, (WALFactory)this.wals);
        WAL wal2 = this.createWAL(this.conf, this.rootDir, this.logName);
        HRegion region2 = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.rootDir, (RegionInfo)ri, (TableDescriptor)td, (WAL)wal2);
        for (int i = 0; i < 10; ++i) {
            for (ColumnFamilyDescriptor cfd : td.getColumnFamilies()) {
                Result result = region2.get(new Get(Bytes.toBytes((int)i)).addFamily(cfd.getName()));
                Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE1, (byte[])result.getValue(cfd.getName(), QUALIFIER)));
                List cells = result.listCells();
                Assert.assertEquals((long)1L, (long)cells.size());
                Assert.assertEquals((long)((Long)((Map)seqIdMap.get(i)).get(cfd.getNameAsString())), (long)((Cell)cells.get(0)).getSequenceId());
            }
        }
    }

    @Test
    public void testWrittenViaHRegion() throws IOException, SecurityException, IllegalArgumentException, InterruptedException {
        Pair<TableDescriptor, RegionInfo> pair = this.setupTableAndRegion();
        final TableDescriptor td = (TableDescriptor)pair.getFirst();
        final RegionInfo ri = (RegionInfo)pair.getSecond();
        WAL wal = this.createWAL(this.conf, this.rootDir, this.logName);
        HRegion region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.rootDir, (RegionInfo)ri, (TableDescriptor)td, (WAL)wal);
        long seqid = region.getOpenSeqNum();
        boolean first = true;
        for (ColumnFamilyDescriptor cfd : td.getColumnFamilies()) {
            AbstractTestWALReplay.addRegionEdits(ROW, cfd.getName(), 10, this.ee, (Region)region, "x");
            if (!first) continue;
            region.flush(true);
            first = false;
        }
        final Get g = new Get(ROW);
        Result result = region.get(g);
        Assert.assertEquals((long)(10 * td.getColumnFamilies().length), (long)result.size());
        region.close(true);
        wal.shutdown();
        try {
            WALSplitter.split((Path)this.rootDir, (Path)this.logDir, (Path)this.oldLogDir, (FileSystem)FileSystem.get((Configuration)this.conf), (Configuration)this.conf, (WALFactory)this.wals);
        }
        catch (Exception e) {
            LOG.debug("Got exception", (Throwable)e);
        }
        WAL wal2 = this.createWAL(this.conf, this.rootDir, this.logName);
        HRegion region2 = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.rootDir, (RegionInfo)ri, (TableDescriptor)td, (WAL)wal2);
        long seqid2 = region2.getOpenSeqNum();
        Assert.assertTrue((seqid + (long)result.size() < seqid2 ? 1 : 0) != 0);
        Result result1b = region2.get(g);
        Assert.assertEquals((long)result.size(), (long)result1b.size());
        for (ColumnFamilyDescriptor hcd : td.getColumnFamilies()) {
            AbstractTestWALReplay.addRegionEdits(ROW, hcd.getName(), 10, this.ee, (Region)region2, "y");
        }
        final Result result2 = region2.get(g);
        Assert.assertEquals((long)(2 * result.size()), (long)result2.size());
        wal2.sync();
        final Configuration newConf = HBaseConfiguration.create((Configuration)this.conf);
        User user = HBaseTestingUtil.getDifferentUser(newConf, td.getTableName().getNameAsString());
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                WALSplitter.split((Path)TestWALSplitToHFile.this.rootDir, (Path)TestWALSplitToHFile.this.logDir, (Path)TestWALSplitToHFile.this.oldLogDir, (FileSystem)FileSystem.get((Configuration)TestWALSplitToHFile.this.conf), (Configuration)TestWALSplitToHFile.this.conf, (WALFactory)TestWALSplitToHFile.this.wals);
                FileSystem newFS = FileSystem.get((Configuration)newConf);
                WAL wal3 = TestWALSplitToHFile.this.createWAL(newConf, TestWALSplitToHFile.this.rootDir, TestWALSplitToHFile.this.logName);
                Path tableDir = CommonFSUtils.getTableDir((Path)TestWALSplitToHFile.this.rootDir, (TableName)td.getTableName());
                HRegion region3 = new HRegion(tableDir, wal3, newFS, newConf, ri, td, null);
                long seqid3 = region3.initialize();
                Result result3 = region3.get(g);
                Assert.assertEquals((long)result2.size(), (long)result3.size());
                region3.close();
                wal3.close();
                return null;
            }
        });
    }

    @Test
    public void testAfterPartialFlush() throws IOException, SecurityException, IllegalArgumentException {
        Pair<TableDescriptor, RegionInfo> pair = this.setupTableAndRegion();
        TableDescriptor td = (TableDescriptor)pair.getFirst();
        RegionInfo ri = (RegionInfo)pair.getSecond();
        WAL wal = this.createWAL(this.conf, this.rootDir, this.logName);
        HRegion region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.rootDir, (RegionInfo)ri, (TableDescriptor)td, (WAL)wal);
        long seqid = region.getOpenSeqNum();
        for (ColumnFamilyDescriptor columnFamilyDescriptor : td.getColumnFamilies()) {
            AbstractTestWALReplay.addRegionEdits(ROW, columnFamilyDescriptor.getName(), 10, this.ee, (Region)region, "x");
        }
        Get g = new Get(ROW);
        Result result = region.get(g);
        Assert.assertEquals((long)(10 * td.getColumnFamilies().length), (long)result.size());
        region.flush(true);
        region.close(true);
        wal.shutdown();
        int cf_count = 0;
        for (ColumnFamilyDescriptor cfd : td.getColumnFamilies()) {
            if (++cf_count != 2) continue;
            region.getRegionFileSystem().deleteFamily(cfd.getNameAsString());
        }
        WALSplitter.split((Path)this.rootDir, (Path)this.logDir, (Path)this.oldLogDir, (FileSystem)FileSystem.get((Configuration)this.conf), (Configuration)this.conf, (WALFactory)this.wals);
        WAL wAL = this.createWAL(this.conf, this.rootDir, this.logName);
        HRegion region2 = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.rootDir, (RegionInfo)ri, (TableDescriptor)td, (WAL)wAL);
        long seqid2 = region2.getOpenSeqNum();
        Assert.assertTrue((seqid + (long)result.size() < seqid2 ? 1 : 0) != 0);
        Result result1b = region2.get(g);
        Assert.assertEquals((long)result.size(), (long)result1b.size());
    }

    @Test
    public void testAfterAbortingFlush() throws IOException {
        Pair<TableDescriptor, RegionInfo> pair = this.setupTableAndRegion();
        TableDescriptor td = (TableDescriptor)pair.getFirst();
        RegionInfo ri = (RegionInfo)pair.getSecond();
        WAL wal = this.createWAL(this.conf, this.rootDir, this.logName);
        RegionServerServices rsServices = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        ((RegionServerServices)Mockito.doReturn((Object)false).when((Object)rsServices)).isAborted();
        Mockito.when((Object)rsServices.getServerName()).thenReturn((Object)ServerName.valueOf((String)"foo", (int)10, (long)10L));
        Mockito.when((Object)rsServices.getConfiguration()).thenReturn((Object)this.conf);
        Configuration customConf = new Configuration(this.conf);
        customConf.set("hbase.hstore.defaultengine.storeflusher.class", AbstractTestWALReplay.CustomStoreFlusher.class.getName());
        HRegion region = HRegion.openHRegion((Path)this.rootDir, (RegionInfo)ri, (TableDescriptor)td, (WAL)wal, (Configuration)customConf, (RegionServerServices)rsServices, null);
        int writtenRowCount = 10;
        List<ColumnFamilyDescriptor> families = Arrays.asList(td.getColumnFamilies());
        for (int i = 0; i < writtenRowCount; ++i) {
            Put put = new Put(Bytes.toBytes((String)(td.getTableName() + Integer.toString(i))));
            put.addColumn(families.get(i % families.size()).getName(), Bytes.toBytes((String)"q"), Bytes.toBytes((String)"val"));
            region.put(put);
        }
        RegionScannerImpl scanner = region.getScanner(new Scan());
        Assert.assertEquals((long)writtenRowCount, (long)this.getScannedCount((RegionScanner)scanner));
        AbstractTestWALReplay.CustomStoreFlusher.throwExceptionWhenFlushing.set(true);
        try {
            region.flush(true);
            Assert.fail((String)"Injected exception hasn't been thrown");
        }
        catch (IOException e) {
            LOG.info("Expected simulated exception when flushing region, {}", (Object)e.getMessage());
            ((RegionServerServices)Mockito.doReturn((Object)true).when((Object)rsServices)).isAborted();
            region.setClosing(false);
        }
        int moreRow = 10;
        for (int i = writtenRowCount; i < writtenRowCount + moreRow; ++i) {
            Put put = new Put(Bytes.toBytes((String)(td.getTableName() + Integer.toString(i))));
            put.addColumn(families.get(i % families.size()).getName(), Bytes.toBytes((String)"q"), Bytes.toBytes((String)"val"));
            region.put(put);
        }
        writtenRowCount += moreRow;
        AbstractTestWALReplay.CustomStoreFlusher.throwExceptionWhenFlushing.set(false);
        try {
            region.flush(true);
        }
        catch (IOException t) {
            LOG.info("Expected exception when flushing region because server is stopped," + t.getMessage());
        }
        region.close(true);
        wal.shutdown();
        WALSplitter.split((Path)this.rootDir, (Path)this.logDir, (Path)this.oldLogDir, (FileSystem)FileSystem.get((Configuration)this.conf), (Configuration)this.conf, (WALFactory)this.wals);
        WAL wal2 = this.createWAL(this.conf, this.rootDir, this.logName);
        ((RegionServerServices)Mockito.doReturn((Object)false).when((Object)rsServices)).isAborted();
        HRegion region2 = HRegion.openHRegion((Path)this.rootDir, (RegionInfo)ri, (TableDescriptor)td, (WAL)wal2, (Configuration)this.conf, (RegionServerServices)rsServices, null);
        scanner = region2.getScanner(new Scan());
        Assert.assertEquals((long)writtenRowCount, (long)this.getScannedCount((RegionScanner)scanner));
    }

    private int getScannedCount(RegionScanner scanner) throws IOException {
        int scannedCount = 0;
        ArrayList results = new ArrayList();
        while (true) {
            boolean existMore = scanner.next(results);
            if (!results.isEmpty()) {
                ++scannedCount;
            }
            if (!existMore) break;
            results.clear();
        }
        return scannedCount;
    }

    private void writeCorruptRecoveredHFile(Path recoveredHFile) throws Exception {
        int fileSize = (int)this.fs.listStatus(recoveredHFile)[0].getLen();
        FSDataInputStream in = this.fs.open(recoveredHFile);
        byte[] fileContent = new byte[fileSize];
        in.readFully(0L, fileContent, 0, fileSize);
        in.close();
        Path path = new Path(recoveredHFile.getParent(), recoveredHFile.getName() + ".corrupt");
        FSDataOutputStream out = this.fs.create(path);
        out.write(fileContent);
        out.write(Bytes.toBytes((String)"-----"));
        out.close();
    }
}

