/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.SnapshotScannerHDFSAclController;
import org.apache.hadoop.hbase.security.access.SnapshotScannerHDFSAclHelper;
import org.apache.hadoop.hbase.security.access.TestHDFSAclHelper;
import org.apache.hadoop.hbase.security.access.TestSnapshotScannerHDFSAclController;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SecurityTests.class, LargeTests.class})
public class TestSnapshotScannerHDFSAclController2 {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotScannerHDFSAclController2.class);
    @Rule
    public TestName name = new TestName();
    private static final Logger LOG = LoggerFactory.getLogger(TestSnapshotScannerHDFSAclController2.class);
    private static final String UN_GRANT_USER = "un_grant_user";
    private static HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static Configuration conf = TEST_UTIL.getConfiguration();
    private static Admin admin = null;
    private static SnapshotScannerHDFSAclHelper helper;
    private static Table aclTable;
    private static FileSystem FS;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Path path;
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        conf.set("fs.permissions.umask-mode", "027");
        conf.setBoolean("hbase.acl.sync.to.hdfs.enable", true);
        conf.set("hbase.security.authentication", "simple");
        conf.set("hbase.snapshot.restore.tmp.dir", "/hbase/.tmpdir-to-restore-snapshot");
        SecureTestUtil.enableSecurity(conf);
        conf.set("hbase.coprocessor.master.classes", conf.get("hbase.coprocessor.master.classes") + "," + SnapshotScannerHDFSAclController.class.getName());
        TEST_UTIL.startMiniCluster();
        SnapshotScannerHDFSAclController coprocessor = (SnapshotScannerHDFSAclController)TEST_UTIL.getHBaseCluster().getMaster().getMasterCoprocessorHost().findCoprocessor(SnapshotScannerHDFSAclController.class);
        TEST_UTIL.waitFor(30000L, () -> coprocessor.checkInitialized("check initialized"));
        TEST_UTIL.waitTableAvailable(PermissionStorage.ACL_TABLE_NAME);
        admin = TEST_UTIL.getAdmin();
        Path rootDir = TEST_UTIL.getDefaultRootDirPath();
        FS = rootDir.getFileSystem(conf);
        User unGrantUser = User.createUserForTesting((Configuration)conf, (String)UN_GRANT_USER, (String[])new String[0]);
        helper = new SnapshotScannerHDFSAclHelper(conf, admin.getConnection());
        FsPermission commonDirectoryPermission = new FsPermission(conf.get("hbase.acl.sync.to.hdfs.common.directory.permission", "751"));
        for (path = rootDir; path != null; path = path.getParent()) {
            FS.setPermission(path, commonDirectoryPermission);
        }
        Path restoreDir = new Path("/hbase/.tmpdir-to-restore-snapshot");
        if (!FS.exists(restoreDir)) {
            FS.mkdirs(restoreDir);
            FS.setPermission(restoreDir, new FsPermission(conf.get("hbase.acl.sync.to.hdfs.restore.directory.permission", "753")));
        }
        for (path = restoreDir.getParent(); path != null; path = path.getParent()) {
            FS.setPermission(path, commonDirectoryPermission);
        }
        aclTable = admin.getConnection().getTable(PermissionStorage.ACL_TABLE_NAME);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRestoreSnapshot() throws Exception {
        String grantUserName = this.name.getMethodName();
        User grantUser = User.createUserForTesting((Configuration)conf, (String)grantUserName, (String[])new String[0]);
        String namespace = this.name.getMethodName();
        TableName table = TableName.valueOf((String)namespace, (String)this.name.getMethodName());
        String snapshot = namespace + "s1";
        String snapshot2 = namespace + "s2";
        String snapshot3 = namespace + "s3";
        LOG.info("Create {}", (Object)table);
        try (Table t = TestHDFSAclHelper.createTable(TEST_UTIL, table);){
            TestHDFSAclHelper.put(t);
            LOG.info("Grant {}", (Object)table);
            TestHDFSAclHelper.grantOnTable(TEST_UTIL, grantUserName, table, Permission.Action.READ);
            admin.snapshot(snapshot, table);
            admin.disableTable(table);
            admin.deleteTable(table);
            LOG.info("Before scan of shapshot! {}", (Object)table);
            TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot, -1);
            admin.restoreSnapshot(snapshot, true, true);
            TestHDFSAclHelper.put2(t);
            admin.snapshot(snapshot2, table);
            TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot, 6);
            TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot2, 10);
            Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl((Table)aclTable, (String)grantUserName, (TableName)table));
            TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getTableRootPaths(table, false), grantUserName, true, true);
            admin.disableTable(table);
            admin.deleteTable(table);
            admin.restoreSnapshot(snapshot);
            admin.snapshot(snapshot3, table);
            LOG.info("CHECK");
            TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot, -1);
            TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot2, -1);
            TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot3, -1);
            Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl((Table)aclTable, (String)grantUserName, (TableName)table));
            TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getPathHelper().getDataTableDir(table), grantUserName, false, false);
            TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getPathHelper().getArchiveTableDir(table), grantUserName, true, false);
        }
    }
}

