/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseCommonTestingUtil;
import org.apache.hadoop.hbase.io.crypto.tls.KeyStoreFileType;
import org.apache.hadoop.hbase.io.crypto.tls.X509KeyType;
import org.apache.hadoop.hbase.io.crypto.tls.X509TestContext;
import org.apache.hadoop.hbase.io.crypto.tls.X509TestContextProvider;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.TestProtobufRpcServiceImpl;
import org.apache.hadoop.hbase.security.AbstractTestTlsRejectPlainText;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runners.Parameterized;

public abstract class AbstractTestMutualTls {
    protected static HBaseCommonTestingUtil UTIL;
    protected static File DIR;
    protected static X509TestContextProvider PROVIDER;
    private X509TestContext x509TestContext;
    protected RpcServer rpcServer;
    protected RpcClient rpcClient;
    private TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub;
    @Parameterized.Parameter(value=0)
    public X509KeyType caKeyType;
    @Parameterized.Parameter(value=1)
    public X509KeyType certKeyType;
    @Parameterized.Parameter(value=2)
    public String keyPassword;
    @Parameterized.Parameter(value=3)
    public boolean expectSuccess;
    @Parameterized.Parameter(value=4)
    public boolean validateHostnames;
    @Parameterized.Parameter(value=5)
    public CertConfig certConfig;

    @BeforeClass
    public static void setUpBeforeClass() throws IOException {
        UTIL = new HBaseCommonTestingUtil();
        Security.addProvider((Provider)new BouncyCastleProvider());
        DIR = new File(UTIL.getDataTestDir(AbstractTestTlsRejectPlainText.class.getSimpleName()).toString()).getCanonicalFile();
        FileUtils.forceMkdir((File)DIR);
        Configuration conf = UTIL.getConfiguration();
        conf.setClass("hbase.rpc.client.impl", NettyRpcClient.class, RpcClient.class);
        conf.setClass("hbase.rpc.server.impl", NettyRpcServer.class, RpcServer.class);
        conf.setBoolean("hbase.server.netty.tls.enabled", true);
        conf.setBoolean("hbase.server.netty.tls.supportplaintext", false);
        conf.setBoolean("hbase.client.netty.tls.enabled", true);
        PROVIDER = new X509TestContextProvider(conf, DIR);
    }

    @AfterClass
    public static void cleanUp() {
        Security.removeProvider("BC");
        UTIL.cleanupTestDir();
    }

    protected abstract void initialize(Configuration var1, Configuration var2) throws IOException, GeneralSecurityException, OperatorCreationException;

    @Before
    public void setUp() throws Exception {
        this.x509TestContext = PROVIDER.get(this.caKeyType, this.certKeyType, this.keyPassword.toCharArray());
        this.x509TestContext.setConfigurations(KeyStoreFileType.JKS, KeyStoreFileType.JKS);
        Configuration serverConf = new Configuration(UTIL.getConfiguration());
        Configuration clientConf = new Configuration(UTIL.getConfiguration());
        this.initialize(serverConf, clientConf);
        this.rpcServer = new NettyRpcServer(null, "testRpcServer", (List)Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), new InetSocketAddress("localhost", 0), serverConf, (RpcScheduler)new FifoRpcScheduler(serverConf, 1), true);
        this.rpcServer.start();
        this.rpcClient = new NettyRpcClient(clientConf);
        this.stub = TestProtobufRpcServiceImpl.newBlockingStub(this.rpcClient, this.rpcServer.getListenerAddress());
    }

    protected void handleCertConfig(Configuration confToSet) throws GeneralSecurityException, IOException, OperatorCreationException {
        switch (this.certConfig) {
            case NO_CLIENT_CERT: {
                confToSet.set("hbase.rpc.tls.keystore.location", "");
                break;
            }
            case NON_VERIFIABLE_CERT: {
                X509TestContext context = PROVIDER.get(this.caKeyType, this.certKeyType, "random value".toCharArray());
                context.setKeystoreConfigurations(KeyStoreFileType.JKS, confToSet);
                break;
            }
            case VERIFIABLE_CERT_WITH_BAD_HOST: {
                X509Certificate cert = this.x509TestContext.newCert(new X500NameBuilder(BCStyle.INSTANCE).addRDN(BCStyle.CN, MethodHandles.lookup().lookupClass().getCanonicalName() + " With Bad Host Test").build(), new String[]{"www.example.com"});
                this.x509TestContext.cloneWithNewKeystoreCert(cert).setKeystoreConfigurations(KeyStoreFileType.JKS, confToSet);
                break;
            }
        }
    }

    @After
    public void tearDown() throws IOException {
        if (this.rpcServer != null) {
            this.rpcServer.stop();
        }
        Closeables.close((Closeable)this.rpcClient, (boolean)true);
        this.x509TestContext.clearConfigurations();
        this.x509TestContext.getConf().unset("hbase.rpc.tls.ocsp");
        this.x509TestContext.getConf().unset("hbase.rpc.tls.clr");
        this.x509TestContext.getConf().unset("hbase.rpc.tls.protocol");
        System.clearProperty("com.sun.net.ssl.checkRevocation");
        System.clearProperty("com.sun.security.enableCRLDP");
        Security.setProperty("ocsp.enable", Boolean.FALSE.toString());
        Security.setProperty("com.sun.security.enableCRLDP", Boolean.FALSE.toString());
    }

    @Test
    public void testClientAuth() throws Exception {
        if (this.expectSuccess) {
            this.submitRequest();
        } else {
            ServiceException se = (ServiceException)Assert.assertThrows(ServiceException.class, this::submitRequest);
            MatcherAssert.assertThat((Object)se.getCause(), (Matcher)Matchers.instanceOf(SSLHandshakeException.class));
        }
    }

    private void submitRequest() throws ServiceException {
        this.stub.echo(null, TestProtos.EchoRequestProto.newBuilder().setMessage("hello world").build());
    }

    public static enum CertConfig {
        NO_CLIENT_CERT,
        NON_VERIFIABLE_CERT,
        GOOD_CERT,
        VERIFIABLE_CERT_WITH_BAD_HOST;

    }
}

