/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseClusterInterface;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManagerImpl;
import org.apache.hadoop.hbase.rsgroup.RSGroupUtil;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RSGroupTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RSGroupTests.class, MediumTests.class})
public class TestRSGroupsOfflineMode
extends TestRSGroupsBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSGroupsOfflineMode.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRSGroupsOfflineMode.class);
    private static HMaster master;
    private static Admin hbaseAdmin;
    private static HBaseTestingUtil TEST_UTIL;
    private static HBaseClusterInterface cluster;
    private static final long WAIT_TIMEOUT = 300000L;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL = new HBaseTestingUtil();
        RSGroupUtil.enableRSGroup((Configuration)TEST_UTIL.getConfiguration());
        TEST_UTIL.getConfiguration().set("hbase.master.wait.on.regionservers.mintostart", "1");
        StartTestingClusterOption option = StartTestingClusterOption.builder().numMasters(2).numRegionServers(3).numDataNodes(3).build();
        TEST_UTIL.startMiniCluster(option);
        cluster = TEST_UTIL.getHBaseCluster();
        master = ((SingleProcessHBaseCluster)cluster).getMaster();
        master.balanceSwitch(false);
        hbaseAdmin = TEST_UTIL.getAdmin();
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return master.isInitialized() && master.getLoadBalancer().isOnline() && master.getServerManager().getOnlineServersList().size() >= 3;
            }
        });
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testOffline() throws Exception, InterruptedException {
        final TableName failoverTable = TableName.valueOf((String)TestRSGroupsOfflineMode.getNameWithoutIndex(this.name.getMethodName()));
        TEST_UTIL.createTable(failoverTable, Bytes.toBytes((String)"f"));
        HRegionServer killRS = ((SingleProcessHBaseCluster)cluster).getRegionServer(0);
        final HRegionServer groupRS = ((SingleProcessHBaseCluster)cluster).getRegionServer(1);
        final HRegionServer failoverRS = ((SingleProcessHBaseCluster)cluster).getRegionServer(2);
        String newGroup = "my_group";
        Admin admin = TEST_UTIL.getAdmin();
        admin.addRSGroup(newGroup);
        if (master.getAssignmentManager().getRegionStates().getRegionAssignments().containsValue(failoverRS.getServerName())) {
            for (RegionInfo regionInfo : hbaseAdmin.getRegions(failoverRS.getServerName())) {
                hbaseAdmin.move(regionInfo.getEncodedNameAsBytes(), failoverRS.getServerName());
            }
            LOG.info("Waiting for region unassignments on failover RS...");
            TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return !master.getServerManager().getLoad(failoverRS.getServerName()).getRegionMetrics().isEmpty();
                }
            });
        }
        admin.moveServersToRSGroup((Set)Sets.newHashSet((Object[])new Address[]{groupRS.getServerName().getAddress()}), newGroup);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return groupRS.getNumberOfOnlineRegions() < 1 && master.getAssignmentManager().getRegionStates().getRegionsInTransitionCount() < 1;
            }
        });
        admin.setRSGroup((Set)Sets.newHashSet((Object[])new TableName[]{RSGroupInfoManagerImpl.RSGROUP_TABLE_NAME}), newGroup);
        LOG.info("Waiting for move table...");
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return groupRS.getNumberOfOnlineRegions() == 1;
            }
        });
        groupRS.stop("die");
        TEST_UTIL.getHBaseCluster().getMaster().stopMaster();
        LOG.info("Waiting for offline mode...");
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TEST_UTIL.getHBaseCluster().getMaster() != null && TEST_UTIL.getHBaseCluster().getMaster().isActiveMaster() && TEST_UTIL.getHBaseCluster().getMaster().isInitialized() && TEST_UTIL.getHBaseCluster().getMaster().getServerManager().getOnlineServers().size() <= 3;
            }
        });
        RSGroupInfoManager groupMgr = ((SingleProcessHBaseCluster)cluster).getMaster().getRSGroupInfoManager();
        Assert.assertFalse((boolean)groupMgr.isOnline());
        killRS.stop("die");
        master = TEST_UTIL.getHBaseCluster().getMaster();
        LOG.info("Waiting for new table assignment...");
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return failoverRS.getRegions(failoverTable).size() >= 1;
            }
        });
        Assert.assertEquals((long)0L, (long)failoverRS.getRegions(RSGroupInfoManagerImpl.RSGROUP_TABLE_NAME).size());
        master.stopMaster();
    }
}

