/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RSGroupTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RSGroupTests.class, MediumTests.class})
public class TestRSGroupsCPHookCalled
extends TestRSGroupsBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSGroupsCPHookCalled.class);

    @BeforeClass
    public static void setUp() throws Exception {
        TestRSGroupsCPHookCalled.setUpTestBeforeClass();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestRSGroupsCPHookCalled.tearDownAfterClass();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.setUpBeforeMethod();
    }

    @After
    public void afterMethod() throws Exception {
        this.tearDownAfterMethod();
    }

    @Test
    public void testGetRSGroupInfoCPHookCalled() throws Exception {
        ADMIN.getRSGroup("default");
        Assert.assertTrue((boolean)TestRSGroupsCPHookCalled.OBSERVER.preGetRSGroupInfoCalled);
        Assert.assertTrue((boolean)TestRSGroupsCPHookCalled.OBSERVER.postGetRSGroupInfoCalled);
    }

    @Test
    public void testGetRSGroupInfoOfTableCPHookCalled() throws Exception {
        ADMIN.getRSGroup(TableName.META_TABLE_NAME);
        Assert.assertTrue((boolean)TestRSGroupsCPHookCalled.OBSERVER.preGetRSGroupInfoOfTableCalled);
        Assert.assertTrue((boolean)TestRSGroupsCPHookCalled.OBSERVER.postGetRSGroupInfoOfTableCalled);
    }

    @Test
    public void testListRSGroupsCPHookCalled() throws Exception {
        ADMIN.listRSGroups();
        Assert.assertTrue((boolean)TestRSGroupsCPHookCalled.OBSERVER.preListRSGroupsCalled);
        Assert.assertTrue((boolean)TestRSGroupsCPHookCalled.OBSERVER.postListRSGroupsCalled);
    }

    @Test
    public void testGetRSGroupInfoOfServerCPHookCalled() throws Exception {
        ServerName masterServerName = ((SingleProcessHBaseCluster)CLUSTER).getMaster().getServerName();
        ADMIN.getRSGroup(masterServerName.getAddress());
        Assert.assertTrue((boolean)TestRSGroupsCPHookCalled.OBSERVER.preGetRSGroupInfoOfServerCalled);
        Assert.assertTrue((boolean)TestRSGroupsCPHookCalled.OBSERVER.postGetRSGroupInfoOfServerCalled);
    }
}

