/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RSGroupTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RSGroupTests.class, LargeTests.class})
public class TestRSGroupsAdmin2
extends TestRSGroupsBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSGroupsAdmin2.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRSGroupsAdmin2.class);

    @BeforeClass
    public static void setUp() throws Exception {
        TestRSGroupsAdmin2.setUpTestBeforeClass();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestRSGroupsAdmin2.tearDownAfterClass();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.setUpBeforeMethod();
    }

    @After
    public void afterMethod() throws Exception {
        this.tearDownAfterMethod();
    }

    @Test
    public void testRegionMove() throws Exception {
        Object server;
        RSGroupInfo newGroup = this.addGroup(this.getGroupName(this.name.getMethodName()), 1);
        byte[] familyNameBytes = Bytes.toBytes((String)"f");
        TEST_UTIL.createMultiRegionTable(this.tableName, familyNameBytes, 6);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regions = TestRSGroupsAdmin2.this.getTableRegionMap().get(TestRSGroupsAdmin2.this.tableName);
                if (regions == null) {
                    return false;
                }
                return TestRSGroupsAdmin2.this.getTableRegionMap().get(TestRSGroupsAdmin2.this.tableName).size() >= 6;
            }
        });
        Map<ServerName, List<String>> assignMap = this.getTableServerRegionMap().get(this.tableName);
        String targetRegion = null;
        Iterator<ServerName> iterator = assignMap.keySet().iterator();
        while (iterator.hasNext() && (targetRegion = assignMap.get(server = iterator.next()).size() > 0 ? assignMap.get(server).get(0) : null) == null) {
        }
        ServerName tmpTargetServer = null;
        for (ServerName server2 : ADMIN.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet()) {
            if (newGroup.containsServer(server2.getAddress())) continue;
            tmpTargetServer = server2;
            break;
        }
        final ServerName targetServer = tmpTargetServer;
        ADMIN.moveServersToRSGroup((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}), newGroup.getName());
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBase.ADMIN.getRegions(targetServer).size() <= 0;
            }
        });
        TEST_UTIL.getAdmin().move(Bytes.toBytes((String)RegionInfo.encodeRegionName((byte[])Bytes.toBytes((String)targetRegion))), targetServer);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsAdmin2.this.getTableRegionMap().get(TestRSGroupsAdmin2.this.tableName) != null && TestRSGroupsAdmin2.this.getTableRegionMap().get(TestRSGroupsAdmin2.this.tableName).size() == 6 && TestRSGroupsBase.ADMIN.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.REGIONS_IN_TRANSITION)).getRegionStatesInTransition().size() < 1;
            }
        });
        for (RegionInfo region : ADMIN.getRegions(targetServer)) {
            if (!targetRegion.equals(region.getRegionNameAsString())) continue;
            Assert.fail((String)"Target server opened region");
        }
    }

    @Test
    public void testRegionServerMove() throws IOException, InterruptedException {
        int initNumGroups = ADMIN.listRSGroups().size();
        RSGroupInfo appInfo = this.addGroup(this.getGroupName(this.name.getMethodName()), 1);
        RSGroupInfo adminInfo = this.addGroup(this.getGroupName(this.name.getMethodName()), 1);
        RSGroupInfo dInfo = ADMIN.getRSGroup("default");
        Assert.assertEquals((long)(initNumGroups + 2), (long)ADMIN.listRSGroups().size());
        Assert.assertEquals((long)1L, (long)adminInfo.getServers().size());
        Assert.assertEquals((long)1L, (long)appInfo.getServers().size());
        Assert.assertEquals((long)(this.getNumServers() - 2), (long)dInfo.getServers().size());
        ADMIN.moveServersToRSGroup(appInfo.getServers(), "default");
        ADMIN.removeRSGroup(appInfo.getName());
        ADMIN.moveServersToRSGroup(adminInfo.getServers(), "default");
        ADMIN.removeRSGroup(adminInfo.getName());
        Assert.assertEquals((long)ADMIN.listRSGroups().size(), (long)initNumGroups);
    }

    @Test
    public void testMoveServers() throws Exception {
        this.addGroup("bar", 3);
        ADMIN.addRSGroup("foo");
        RSGroupInfo barGroup = ADMIN.getRSGroup("bar");
        RSGroupInfo fooGroup = ADMIN.getRSGroup("foo");
        Assert.assertEquals((long)3L, (long)barGroup.getServers().size());
        Assert.assertEquals((long)0L, (long)fooGroup.getServers().size());
        try {
            ADMIN.moveServersToRSGroup((Set)Sets.newHashSet((Object[])new Address[]{Address.fromString((String)"foo:9999")}), "foo");
            Assert.fail((String)"Bogus servers shouldn't have been successfully moved.");
        }
        catch (IOException ex) {
            String exp = "Server foo:9999 is either offline or it does not exist.";
            String msg = "Expected '" + exp + "' in exception message: ";
            Assert.assertTrue((String)(msg + " " + ex.getMessage()), (boolean)ex.getMessage().contains(exp));
        }
        LOG.info("moving servers " + barGroup.getServers() + " to group foo");
        ADMIN.moveServersToRSGroup(barGroup.getServers(), fooGroup.getName());
        barGroup = ADMIN.getRSGroup("bar");
        fooGroup = ADMIN.getRSGroup("foo");
        Assert.assertEquals((long)0L, (long)barGroup.getServers().size());
        Assert.assertEquals((long)3L, (long)fooGroup.getServers().size());
        LOG.info("moving servers " + fooGroup.getServers() + " to group default");
        ADMIN.moveServersToRSGroup(fooGroup.getServers(), "default");
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsAdmin2.this.getNumServers() == TestRSGroupsBase.ADMIN.getRSGroup("default").getServers().size();
            }
        });
        fooGroup = ADMIN.getRSGroup("foo");
        Assert.assertEquals((long)0L, (long)fooGroup.getServers().size());
        LOG.info("Remove group " + barGroup.getName());
        ADMIN.removeRSGroup(barGroup.getName());
        Assert.assertEquals(null, (Object)ADMIN.getRSGroup(barGroup.getName()));
        LOG.info("Remove group " + fooGroup.getName());
        ADMIN.removeRSGroup(fooGroup.getName());
        Assert.assertEquals(null, (Object)ADMIN.getRSGroup(fooGroup.getName()));
    }

    @Test
    public void testRemoveServers() throws Exception {
        String msg;
        String exp;
        LOG.info("testRemoveServers");
        RSGroupInfo newGroup = this.addGroup(this.getGroupName(this.name.getMethodName()), 3);
        Iterator iterator = newGroup.getServers().iterator();
        ServerName targetServer = this.getServerName((Address)iterator.next());
        try {
            ADMIN.removeServersFromRSGroup((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}));
            Assert.fail((String)"Online servers shouldn't have been successfully removed.");
        }
        catch (IOException ex) {
            exp = "Server " + targetServer.getAddress() + " is an online server, not allowed to remove.";
            msg = "Expected '" + exp + "' in exception message: ";
            Assert.assertTrue((String)(msg + " " + ex.getMessage()), (boolean)ex.getMessage().contains(exp));
        }
        Assert.assertTrue((boolean)newGroup.getServers().contains(targetServer.getAddress()));
        NUM_DEAD_SERVERS = CLUSTER.getClusterMetrics().getDeadServerNames().size();
        try {
            LOG.info("stopping server " + targetServer.getServerName());
            ADMIN.stopRegionServer(targetServer.getAddress().toString());
            ++NUM_DEAD_SERVERS;
        }
        catch (Exception ex) {
            // empty catch block
        }
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return !TestRSGroupsBase.MASTER.getServerManager().areDeadServersInProgress() && TestRSGroupsBase.CLUSTER.getClusterMetrics().getDeadServerNames().size() == TestRSGroupsBase.NUM_DEAD_SERVERS;
            }
        });
        try {
            ADMIN.removeServersFromRSGroup((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}));
            Assert.fail((String)"Dead servers shouldn't have been successfully removed.");
        }
        catch (IOException ex) {
            exp = "Server " + targetServer.getAddress() + " is on the dead servers list, Maybe it will come back again, not allowed to remove.";
            msg = "Expected '" + exp + "' in exception message: ";
            Assert.assertTrue((String)(msg + " " + ex.getMessage()), (boolean)ex.getMessage().contains(exp));
        }
        Assert.assertTrue((boolean)newGroup.getServers().contains(targetServer.getAddress()));
        ArrayList<ServerName> serversToDecommission = new ArrayList<ServerName>();
        targetServer = this.getServerName((Address)iterator.next());
        Assert.assertTrue((boolean)MASTER.getServerManager().getOnlineServers().containsKey(targetServer));
        serversToDecommission.add(targetServer);
        ADMIN.decommissionRegionServers(serversToDecommission, true);
        Assert.assertEquals((long)1L, (long)ADMIN.listDecommissionedRegionServers().size());
        Assert.assertTrue((boolean)newGroup.getServers().contains(targetServer.getAddress()));
        ADMIN.removeServersFromRSGroup((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}));
        Set newGroupServers = ADMIN.getRSGroup(newGroup.getName()).getServers();
        Assert.assertFalse((boolean)newGroupServers.contains(targetServer.getAddress()));
        Assert.assertEquals((long)2L, (long)newGroupServers.size());
        Assert.assertTrue((boolean)TestRSGroupsAdmin2.OBSERVER.preRemoveServersCalled);
        Assert.assertTrue((boolean)TestRSGroupsAdmin2.OBSERVER.postRemoveServersCalled);
    }

    @Test
    public void testMoveServersAndTables() throws Exception {
        LOG.info("testMoveServersAndTables");
        RSGroupInfo newGroup = this.addGroup(this.getGroupName(this.name.getMethodName()), 1);
        byte[] familyNameBytes = Bytes.toBytes((String)"f");
        TEST_UTIL.createMultiRegionTable(this.tableName, familyNameBytes, 5);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regions = TestRSGroupsAdmin2.this.getTableRegionMap().get(TestRSGroupsAdmin2.this.tableName);
                if (regions == null) {
                    return false;
                }
                return TestRSGroupsAdmin2.this.getTableRegionMap().get(TestRSGroupsAdmin2.this.tableName).size() >= 5;
            }
        });
        ServerName targetServer = null;
        for (ServerName server : ADMIN.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet()) {
            if (newGroup.containsServer(server.getAddress()) || ADMIN.getRSGroup("master").containsServer(server.getAddress())) continue;
            targetServer = server;
            break;
        }
        LOG.debug("Print group info : " + ADMIN.listRSGroups());
        int oldDefaultGroupServerSize = ADMIN.getRSGroup("default").getServers().size();
        int oldDefaultGroupTableSize = ADMIN.listTablesInRSGroup("default").size();
        Assert.assertTrue((boolean)TestRSGroupsAdmin2.OBSERVER.preListTablesInRSGroupCalled);
        Assert.assertTrue((boolean)TestRSGroupsAdmin2.OBSERVER.postListTablesInRSGroupCalled);
        try {
            ADMIN.moveServersToRSGroup((Set)Sets.newHashSet((Object[])new Address[]{Address.fromString((String)"foo:9999")}), newGroup.getName());
            ADMIN.setRSGroup((Set)Sets.newHashSet((Object[])new TableName[]{this.tableName}), newGroup.getName());
            Assert.fail((String)"Bogus servers shouldn't have been successfully moved.");
        }
        catch (IOException ex) {
            String exp = "Server foo:9999 is either offline or it does not exist.";
            String msg = "Expected '" + (String)exp + "' in exception message: ";
            Assert.assertTrue((String)(msg + " " + ex.getMessage()), (boolean)ex.getMessage().contains(exp));
        }
        ADMIN.moveServersToRSGroup((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}), "default");
        ADMIN.setRSGroup((Set)Sets.newHashSet((Object[])new TableName[]{this.tableName}), "default");
        Assert.assertEquals((long)oldDefaultGroupServerSize, (long)ADMIN.getRSGroup("default").getServers().size());
        Assert.assertEquals((long)oldDefaultGroupTableSize, (long)ADMIN.listTablesInRSGroup("default").size());
        Assert.assertEquals((long)1L, (long)ADMIN.getRSGroup(newGroup.getName()).getServers().size());
        Assert.assertEquals((long)0L, (long)((List)ADMIN.getConfiguredNamespacesAndTablesInRSGroup(newGroup.getName()).getSecond()).size());
        Assert.assertTrue((boolean)TestRSGroupsAdmin2.OBSERVER.preGetConfiguredNamespacesAndTablesInRSGroupCalled);
        Assert.assertTrue((boolean)TestRSGroupsAdmin2.OBSERVER.postGetConfiguredNamespacesAndTablesInRSGroupCalled);
        List<String> regionList = this.getTableRegionMap().get(this.tableName);
        for (String region : regionList) {
            TEST_UTIL.getAdmin().move(Bytes.toBytes((String)RegionInfo.encodeRegionName((byte[])Bytes.toBytes((String)region))), targetServer);
        }
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsAdmin2.this.getTableRegionMap().get(TestRSGroupsAdmin2.this.tableName) != null && TestRSGroupsAdmin2.this.getTableRegionMap().get(TestRSGroupsAdmin2.this.tableName).size() == 5 && TestRSGroupsAdmin2.this.getTableServerRegionMap().get(TestRSGroupsAdmin2.this.tableName).size() == 1 && TestRSGroupsBase.ADMIN.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.REGIONS_IN_TRANSITION)).getRegionStatesInTransition().size() < 1;
            }
        });
        Assert.assertEquals((long)5L, (long)this.getTableServerRegionMap().get(this.tableName).get(targetServer).size());
        LOG.info("moving server and table to newGroup");
        ADMIN.moveServersToRSGroup((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}), newGroup.getName());
        ADMIN.setRSGroup((Set)Sets.newHashSet((Object[])new TableName[]{this.tableName}), newGroup.getName());
        Assert.assertEquals((Object)newGroup.getName(), (Object)ADMIN.getRSGroup(this.tableName).getName());
        Set defaultServers = ADMIN.getRSGroup("default").getServers();
        Assert.assertFalse((boolean)defaultServers.contains(targetServer.getAddress()));
        Set newGroupServers = ADMIN.getRSGroup(newGroup.getName()).getServers();
        Assert.assertTrue((boolean)newGroupServers.contains(targetServer.getAddress()));
        HashSet defaultTables = Sets.newHashSet((Iterable)ADMIN.listTablesInRSGroup("default"));
        Assert.assertFalse((boolean)defaultTables.contains(this.tableName));
        HashSet newGroupTables = Sets.newHashSet((Iterable)((Iterable)ADMIN.getConfiguredNamespacesAndTablesInRSGroup(newGroup.getName()).getSecond()));
        Assert.assertTrue((boolean)newGroupTables.contains(this.tableName));
        Assert.assertTrue((boolean)TestRSGroupsAdmin2.OBSERVER.preMoveServersCalled);
        Assert.assertTrue((boolean)TestRSGroupsAdmin2.OBSERVER.postMoveServersCalled);
    }

    @Test
    public void testMoveServersFromDefaultGroup() throws Exception {
        ADMIN.addRSGroup("foo");
        RSGroupInfo fooGroup = ADMIN.getRSGroup("foo");
        Assert.assertEquals((long)0L, (long)fooGroup.getServers().size());
        RSGroupInfo defaultGroup = ADMIN.getRSGroup("default");
        try {
            ADMIN.moveServersToRSGroup(defaultGroup.getServers(), fooGroup.getName());
            Assert.fail((String)"should keep at least one server in 'default' RSGroup.");
        }
        catch (ConstraintException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("should keep at least one server in 'default' RSGroup."));
        }
        if (defaultGroup.getServers().size() > 1) {
            Address serverInDefaultGroup = (Address)defaultGroup.getServers().iterator().next();
            LOG.info("moving server " + serverInDefaultGroup + " from group default to group " + fooGroup.getName());
            ADMIN.moveServersToRSGroup((Set)Sets.newHashSet((Object[])new Address[]{serverInDefaultGroup}), fooGroup.getName());
        }
        fooGroup = ADMIN.getRSGroup("foo");
        LOG.info("moving servers " + fooGroup.getServers() + " to group default");
        ADMIN.moveServersToRSGroup(fooGroup.getServers(), "default");
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsAdmin2.this.getNumServers() == TestRSGroupsBase.ADMIN.getRSGroup("default").getServers().size();
            }
        });
        fooGroup = ADMIN.getRSGroup("foo");
        Assert.assertEquals((long)0L, (long)fooGroup.getServers().size());
        LOG.info("Remove group " + fooGroup.getName());
        ADMIN.removeRSGroup(fooGroup.getName());
        Assert.assertEquals(null, (Object)ADMIN.getRSGroup(fooGroup.getName()));
    }

    @Test
    public void testFailedMoveBeforeRetryExhaustedWhenMoveServer() throws Exception {
        String groupName = this.getGroupName(this.name.getMethodName());
        ADMIN.addRSGroup(groupName);
        RSGroupInfo newGroup = ADMIN.getRSGroup(groupName);
        Pair<ServerName, RegionStateNode> gotPair = this.createTableWithRegionSplitting(newGroup, 10);
        final ServerName movedServer = (ServerName)gotPair.getFirst();
        final RegionStateNode rsn = (RegionStateNode)gotPair.getSecond();
        final AtomicBoolean changed = new AtomicBoolean(false);
        Thread t1 = this.recoverRegionStateThread(movedServer, server -> MASTER.getAssignmentManager().getRegionsOnServer(movedServer), rsn, changed);
        t1.start();
        Thread t2 = new Thread(() -> {
            LOG.info("thread2 start running, to move regions");
            try {
                ADMIN.moveServersToRSGroup((Set)Sets.newHashSet((Object[])new Address[]{movedServer.getAddress()}), newGroup.getName());
            }
            catch (IOException e) {
                LOG.error("move server error", (Throwable)e);
            }
        });
        t2.start();
        t1.join();
        t2.join();
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() {
                if (changed.get()) {
                    return TestRSGroupsBase.MASTER.getAssignmentManager().getRegionsOnServer(movedServer).size() == 0 && !rsn.getRegionLocation().equals((Object)movedServer);
                }
                return false;
            }
        });
    }

    private <T> Thread recoverRegionStateThread(T owner, Function<T, List<RegionInfo>> getRegions, RegionStateNode rsn, AtomicBoolean changed) {
        return new Thread(() -> {
            LOG.info("thread1 start running, will recover region state");
            long current = EnvironmentEdgeManager.currentTime();
            while (EnvironmentEdgeManager.currentTime() - current <= 50000L) {
                List regions = (List)getRegions.apply(owner);
                LOG.debug("server table region size is:{}", (Object)regions.size());
                assert (regions.size() >= 1);
                if (regions.size() == 1) {
                    Assert.assertEquals((Object)((RegionInfo)regions.get(0)).getRegionNameAsString(), (Object)rsn.getRegionInfo().getRegionNameAsString());
                    rsn.setState(RegionState.State.OPEN, new RegionState.State[0]);
                    LOG.info("set region {} state OPEN", (Object)rsn.getRegionInfo().getRegionNameAsString());
                    changed.set(true);
                    break;
                }
                Threads.sleep((long)5000L);
            }
        });
    }

    private Pair<ServerName, RegionStateNode> createTableWithRegionSplitting(RSGroupInfo rsGroupInfo, final int tableRegionCount) throws Exception {
        byte[] familyNameBytes = Bytes.toBytes((String)"f");
        TEST_UTIL.createMultiRegionTable(this.tableName, familyNameBytes, tableRegionCount);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regions = TestRSGroupsAdmin2.this.getTableRegionMap().get(TestRSGroupsAdmin2.this.tableName);
                if (regions == null) {
                    return false;
                }
                return TestRSGroupsAdmin2.this.getTableRegionMap().get(TestRSGroupsAdmin2.this.tableName).size() >= tableRegionCount;
            }
        });
        return this.randomlySetOneRegionStateToSplitting(rsGroupInfo);
    }

    private Pair<ServerName, RegionStateNode> randomlySetOneRegionStateToSplitting(RSGroupInfo newGroup) throws IOException {
        return this.randomlySetRegionState(newGroup, RegionState.State.SPLITTING, this.tableName);
    }

    private Pair<ServerName, RegionStateNode> randomlySetRegionState(RSGroupInfo groupInfo, RegionState.State state, TableName ... tableNames) throws IOException {
        Preconditions.checkArgument((tableNames.length == 1 || tableNames.length == 2 ? 1 : 0) != 0, (Object)"only support one or two tables");
        Map<TableName, Map<ServerName, List<String>>> tableServerRegionMap = this.getTableServerRegionMap();
        Map<ServerName, List<String>> assignMap = tableServerRegionMap.get(tableNames[0]);
        if (tableNames.length == 2) {
            Map<ServerName, List<String>> assignMap2 = tableServerRegionMap.get(tableNames[1]);
            assignMap2.forEach((k, v) -> {
                if (!assignMap.containsKey(k)) {
                    assignMap.remove(k);
                }
            });
        }
        String toCorrectRegionName = null;
        ServerName srcServer = null;
        for (ServerName server : assignMap.keySet()) {
            toCorrectRegionName = assignMap.get(server).size() >= 1 && !groupInfo.containsServer(server.getAddress()) ? assignMap.get(server).get(0) : null;
            if (toCorrectRegionName == null) continue;
            srcServer = server;
            break;
        }
        assert (srcServer != null);
        RegionInfo toCorrectRegionInfo = TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionInfo(Bytes.toBytesBinary(toCorrectRegionName));
        RegionStateNode rsn = TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionStateNode(toCorrectRegionInfo);
        rsn.setState(state, new RegionState.State[0]);
        return new Pair((Object)srcServer, (Object)rsn);
    }

    @Test
    public void testFailedMoveServersAndRepair() throws Exception {
        RSGroupInfo newGroup = this.addGroup(this.getGroupName(this.name.getMethodName()), 1);
        Pair<ServerName, RegionStateNode> gotPair = this.createTableWithRegionSplitting(newGroup, ThreadLocalRandom.current().nextInt(8) + 4);
        RegionStateNode rsn = (RegionStateNode)gotPair.getSecond();
        ServerName srcServer = rsn.getRegionLocation();
        try {
            ADMIN.moveServersToRSGroup((Set)Sets.newHashSet((Object[])new Address[]{srcServer.getAddress()}), newGroup.getName());
            Assert.fail((String)"should get IOException when retry exhausted but there still exists failed moved regions");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains(((RegionStateNode)gotPair.getSecond()).getRegionInfo().getRegionNameAsString()));
        }
        for (RegionInfo regionInfo : MASTER.getAssignmentManager().getAssignedRegions()) {
            if (!regionInfo.getTable().equals((Object)this.tableName) || !regionInfo.equals(rsn.getRegionInfo())) continue;
            Assert.assertEquals((Object)MASTER.getAssignmentManager().getRegionStates().getRegionServerOfRegion(regionInfo), (Object)srcServer);
        }
        rsn.setState(RegionState.State.OPEN, new RegionState.State[0]);
        ADMIN.moveServersToRSGroup((Set)Sets.newHashSet((Object[])new Address[]{srcServer.getAddress()}), newGroup.getName());
        Assert.assertEquals((long)MASTER.getAssignmentManager().getRegionsOnServer(srcServer).size(), (long)0L);
    }

    @Test
    public void testFailedMoveServersTablesAndRepair() throws Exception {
        RSGroupInfo newGroup = this.addGroup(this.getGroupName(this.name.getMethodName()), 1);
        byte[] familyNameBytes = Bytes.toBytes((String)"f");
        TableName table1 = TableName.valueOf((String)(this.tableName.getNameAsString() + "_1"));
        TableName table2 = TableName.valueOf((String)(this.tableName.getNameAsString() + "_2"));
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        TEST_UTIL.createMultiRegionTable(table1, familyNameBytes, ((Random)rand).nextInt(12) + 4);
        TEST_UTIL.createMultiRegionTable(table2, familyNameBytes, ((Random)rand).nextInt(12) + 4);
        Pair<ServerName, RegionStateNode> gotPair = this.randomlySetRegionState(newGroup, RegionState.State.SPLITTING, table1, table2);
        RegionStateNode rsn = (RegionStateNode)gotPair.getSecond();
        ServerName srcServer = rsn.getRegionLocation();
        try {
            ADMIN.moveServersToRSGroup((Set)Sets.newHashSet((Object[])new Address[]{srcServer.getAddress()}), newGroup.getName());
            ADMIN.setRSGroup((Set)Sets.newHashSet((Object[])new TableName[]{table2}), newGroup.getName());
            Assert.fail((String)"should get IOException when retry exhausted but there still exists failed moved regions");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains(((RegionStateNode)gotPair.getSecond()).getRegionInfo().getRegionNameAsString()));
        }
        for (RegionInfo regionInfo : MASTER.getAssignmentManager().getAssignedRegions()) {
            if (!regionInfo.getTable().equals((Object)table1) || !regionInfo.equals(rsn.getRegionInfo())) continue;
            Assert.assertEquals((Object)MASTER.getAssignmentManager().getRegionStates().getRegionServerOfRegion(regionInfo), (Object)srcServer);
        }
        rsn.setState(RegionState.State.OPEN, new RegionState.State[0]);
        ADMIN.moveServersToRSGroup((Set)Sets.newHashSet((Object[])new Address[]{srcServer.getAddress()}), newGroup.getName());
        ADMIN.setRSGroup((Set)Sets.newHashSet((Object[])new TableName[]{table2}), newGroup.getName());
        for (RegionInfo regionsInfo : MASTER.getAssignmentManager().getRegionsOnServer(srcServer)) {
            Assert.assertEquals((Object)regionsInfo.getTable(), (Object)table2);
        }
    }

    @Test
    public void testMoveServersToRSGroupPerformance() throws Exception {
        RSGroupInfo newGroup = this.addGroup(this.getGroupName(this.name.getMethodName()), 2);
        byte[] familyNameBytes = Bytes.toBytes((String)"f");
        int tableRegionCount = 200;
        TEST_UTIL.createMultiRegionTable(this.tableName, familyNameBytes, 200);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regions = TestRSGroupsAdmin2.this.getTableRegionMap().get(TestRSGroupsAdmin2.this.tableName);
                if (regions == null) {
                    return false;
                }
                return TestRSGroupsAdmin2.this.getTableRegionMap().get(TestRSGroupsAdmin2.this.tableName).size() >= 200;
            }
        });
        ADMIN.setRSGroup((Set)Sets.newHashSet((Object[])new TableName[]{this.tableName}), newGroup.getName());
        TEST_UTIL.waitUntilAllRegionsAssigned(this.tableName);
        String rsGroup2 = "rsGroup2";
        ADMIN.addRSGroup(rsGroup2);
        long startTime = EnvironmentEdgeManager.currentTime();
        ADMIN.moveServersToRSGroup((Set)Sets.newHashSet((Object[])new Address[]{(Address)newGroup.getServers().iterator().next()}), rsGroup2);
        long timeTaken = EnvironmentEdgeManager.currentTime() - startTime;
        String msg = "Should not take mote than 15000 ms to move a table with 100 regions. Time taken  =" + timeTaken + " ms";
        Assert.assertTrue((String)msg, (timeTaken < 15000L ? 1 : 0) != 0);
        LOG.info("Time taken to move a table with 100 region is {} ms", (Object)timeTaken);
    }
}

