/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.testclassification.FlakeyTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.Uninterruptibles;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={FlakeyTests.class, LargeTests.class})
public class TestRegionReplicaReplication {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionReplicaReplication.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionReplicaReplication.class);
    private static final int NB_SERVERS = 2;
    private static final HBaseTestingUtil HTU = new HBaseTestingUtil();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws Exception {
        Configuration conf = HTU.getConfiguration();
        conf.setFloat("hbase.regionserver.logroll.multiplier", 3.0E-4f);
        conf.setInt("replication.source.size.capacity", 10240);
        conf.setLong("replication.source.sleepforretries", 100L);
        conf.setInt("hbase.regionserver.maxlogs", 10);
        conf.setLong("hbase.master.logcleaner.ttl", 10L);
        conf.setInt("zookeeper.recovery.retry", 1);
        conf.setInt("zookeeper.recovery.retry.intervalmill", 10);
        conf.setBoolean("hbase.region.replica.replication.enabled", true);
        conf.setLong("hbase.server.thread.wakefrequency", 100L);
        conf.setBoolean("hbase.tests.use.shortcircuit.reads", false);
        conf.setInt("hbase.client.retries.number", 5);
        conf.setInt("hbase.client.serverside.retries.multiplier", 1);
        HTU.startMiniCluster(2);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        HTU.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRegionReplicaReplication(int regionReplication, boolean skipWAL) throws Exception {
        TableName tableName = TableName.valueOf((String)("testRegionReplicaReplicationWithReplicas_" + regionReplication + (skipWAL ? "_skipWAL" : "")));
        TableDescriptorBuilder builder = HTU.createModifyableTableDescriptor(TableName.valueOf((String)tableName.toString()), 0, 3, Integer.MAX_VALUE, ColumnFamilyDescriptorBuilder.DEFAULT_KEEP_DELETED).setRegionReplication(regionReplication);
        if (skipWAL) {
            builder.setDurability(Durability.SKIP_WAL);
        }
        TableDescriptor htd = builder.build();
        this.createOrEnableTableWithRetries(htd, true);
        TableName tableNameNoReplicas = TableName.valueOf((String)"testRegionReplicaReplicationWithReplicas_NO_REPLICAS");
        HTU.deleteTableIfAny(tableNameNoReplicas);
        HTU.createTable(tableNameNoReplicas, HBaseTestingUtil.fam1);
        try (Connection connection = ConnectionFactory.createConnection((Configuration)HTU.getConfiguration());
             Table table = connection.getTable(tableName);
             Table tableNoReplicas = connection.getTable(tableNameNoReplicas);){
            HTU.loadNumericRows(tableNoReplicas, HBaseTestingUtil.fam1, 6000, 7000);
            HTU.loadNumericRows(table, HBaseTestingUtil.fam1, 0, 1000);
            this.verifyReplication(tableName, regionReplication, 0, 1000);
        }
        finally {
            HTU.deleteTableIfAny(tableNameNoReplicas);
        }
    }

    private void verifyReplication(TableName tableName, int regionReplication, int startRow, int endRow) throws Exception {
        this.verifyReplication(tableName, regionReplication, startRow, endRow, true);
    }

    private void verifyReplication(TableName tableName, int regionReplication, final int startRow, final int endRow, final boolean present) throws Exception {
        Region[] regions = new Region[regionReplication];
        for (int i = 0; i < 2; ++i) {
            HRegionServer rs = HTU.getMiniHBaseCluster().getRegionServer(i);
            List onlineRegions = rs.getRegions(tableName);
            for (HRegion region : onlineRegions) {
                regions[region.getRegionInfo().getReplicaId()] = region;
            }
        }
        for (Region region : regions) {
            Assert.assertNotNull((Object)region);
        }
        for (int i = 1; i < regionReplication; ++i) {
            final Region region = regions[i];
            Waiter.waitFor((Configuration)HTU.getConfiguration(), (long)90000L, (long)1000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    LOG.info("verifying replication for region replica:" + region.getRegionInfo());
                    try {
                        HTU.verifyNumericRows(region, HBaseTestingUtil.fam1, startRow, endRow, present);
                    }
                    catch (Throwable ex) {
                        LOG.warn("Verification from secondary region is not complete yet", ex);
                        return false;
                    }
                    return true;
                }
            });
        }
    }

    @Test
    public void testRegionReplicaReplicationWith2Replicas() throws Exception {
        this.testRegionReplicaReplication(2, false);
        this.testRegionReplicaReplication(2, true);
    }

    @Test
    public void testRegionReplicaReplicationWith3Replicas() throws Exception {
        this.testRegionReplicaReplication(3, false);
        this.testRegionReplicaReplication(3, true);
    }

    @Test
    public void testRegionReplicaReplicationWith10Replicas() throws Exception {
        this.testRegionReplicaReplication(10, false);
        this.testRegionReplicaReplication(10, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionReplicaWithoutMemstoreReplication() throws Exception {
        int regionReplication = 3;
        TableDescriptor htd = HTU.createModifyableTableDescriptor(this.name.getMethodName()).setRegionReplication(regionReplication).setRegionMemStoreReplication(false).build();
        this.createOrEnableTableWithRetries(htd, true);
        TableName tableName = htd.getTableName();
        Connection connection = ConnectionFactory.createConnection((Configuration)HTU.getConfiguration());
        Table table = connection.getTable(tableName);
        try {
            int STEP = 100;
            for (int i = 0; i < 3; ++i) {
                int startRow = i * 100;
                int endRow = (i + 1) * 100;
                LOG.info("Writing data from " + startRow + " to " + endRow);
                HTU.loadNumericRows(table, HBaseTestingUtil.fam1, startRow, endRow);
                this.verifyReplication(tableName, regionReplication, startRow, endRow, false);
                LOG.info("flushing table");
                HTU.flush(tableName);
                this.verifyReplication(tableName, regionReplication, 0, endRow, true);
            }
        }
        finally {
            table.close();
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionReplicaReplicationForFlushAndCompaction() throws Exception {
        int regionReplication = 3;
        TableDescriptor htd = HTU.createModifyableTableDescriptor(this.name.getMethodName()).setRegionReplication(regionReplication).build();
        this.createOrEnableTableWithRetries(htd, true);
        TableName tableName = htd.getTableName();
        Connection connection = ConnectionFactory.createConnection((Configuration)HTU.getConfiguration());
        Table table = connection.getTable(tableName);
        try {
            for (int i = 0; i < 6000; i += 1000) {
                LOG.info("Writing data from " + i + " to " + (i + 1000));
                HTU.loadNumericRows(table, HBaseTestingUtil.fam1, i, i + 1000);
                LOG.info("flushing table");
                HTU.flush(tableName);
                LOG.info("compacting table");
                HTU.compact(tableName, false);
            }
            this.verifyReplication(tableName, regionReplication, 0, 1000);
        }
        finally {
            table.close();
            connection.close();
        }
    }

    private void createOrEnableTableWithRetries(TableDescriptor htd, boolean createTableOperation) {
        boolean continueToRetry = true;
        int tries = 0;
        while (continueToRetry && tries < 50) {
            try {
                continueToRetry = false;
                if (createTableOperation) {
                    HTU.getAdmin().createTable(htd);
                    continue;
                }
                HTU.getAdmin().enableTable(htd.getTableName());
            }
            catch (IOException e) {
                if (!(e.getCause() instanceof ReplicationException)) continue;
                continueToRetry = true;
                ++tries;
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
        }
    }
}

