/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationGroupOffset;
import org.apache.hadoop.hbase.replication.ReplicationQueueData;
import org.apache.hadoop.hbase.replication.ReplicationQueueId;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.replication.TableReplicationQueueStorage;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.zookeeper.KeeperException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestTableReplicationQueueStorage {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTableReplicationQueueStorage.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestTableReplicationQueueStorage.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    @Rule
    public TableNameTestRule tableNameRule = new TableNameTestRule();
    private TableReplicationQueueStorage storage;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDown() throws IOException {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUpBeforeTest() throws Exception {
        TableName tableName = this.tableNameRule.getTableName();
        TableDescriptor td = ReplicationStorageFactory.createReplicationQueueTableDescriptor((TableName)tableName);
        UTIL.getAdmin().createTable(td);
        UTIL.waitTableAvailable(tableName);
        this.storage = new TableReplicationQueueStorage(UTIL.getConnection(), tableName);
    }

    private ServerName getServerName(int i) {
        return ServerName.valueOf((String)"127.0.0.1", (int)(8000 + i), (long)(10000 + i));
    }

    private String getFileName(String base, int i) {
        return String.format(base + "-%04d", i);
    }

    @Test
    public void testReplicator() throws ReplicationException {
        int i;
        Assert.assertTrue((boolean)this.storage.listAllReplicators().isEmpty());
        String peerId = "1";
        for (int i2 = 0; i2 < 10; ++i2) {
            ReplicationQueueId queueId = new ReplicationQueueId(this.getServerName(i2), peerId);
            this.storage.setOffset(queueId, "group-" + i2, new ReplicationGroupOffset("file-" + i2, (long)(i2 * 100)), Collections.emptyMap());
        }
        List replicators = this.storage.listAllReplicators();
        Assert.assertEquals((long)10L, (long)replicators.size());
        for (i = 0; i < 10; ++i) {
            MatcherAssert.assertThat((Object)replicators, (Matcher)Matchers.hasItem((Object)this.getServerName(i)));
        }
        for (i = 0; i < 5; ++i) {
            ReplicationQueueId queueId = new ReplicationQueueId(this.getServerName(i), peerId);
            this.storage.removeQueue(queueId);
        }
        replicators = this.storage.listAllReplicators();
        Assert.assertEquals((long)5L, (long)replicators.size());
        for (i = 0; i < 5; ++i) {
            MatcherAssert.assertThat((Object)replicators, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)this.getServerName(i))));
        }
        for (i = 5; i < 10; ++i) {
            MatcherAssert.assertThat((Object)replicators, (Matcher)Matchers.hasItem((Object)this.getServerName(i)));
        }
    }

    @Test
    public void testGetSetOffset() {
    }

    private void assertQueueId(String peerId, ServerName serverName, ReplicationQueueId queueId) {
        Assert.assertEquals((Object)peerId, (Object)queueId.getPeerId());
        Assert.assertEquals((Object)serverName, (Object)queueId.getServerName());
        Assert.assertFalse((boolean)queueId.getSourceServerName().isPresent());
    }

    @Test
    public void testPersistLogPositionAndSeqIdAtomically() throws Exception {
        ReplicationQueueId queueId;
        int i;
        ServerName serverName1 = ServerName.valueOf((String)"127.0.0.1", (int)8000, (long)10000L);
        Assert.assertTrue((boolean)this.storage.listAllQueueIds(serverName1).isEmpty());
        String peerId1 = "1";
        String region0 = "6b2c8f8555335cc9af74455b94516cbe";
        String region1 = "6ecd2e9e010499f8ddef97ee8f70834f";
        for (i = 0; i < 10; ++i) {
            queueId = new ReplicationQueueId(serverName1, peerId1);
            Assert.assertTrue((boolean)this.storage.getOffsets(queueId).isEmpty());
        }
        Assert.assertEquals((long)-1L, (long)this.storage.getLastSequenceId(region0, peerId1));
        Assert.assertEquals((long)-1L, (long)this.storage.getLastSequenceId(region1, peerId1));
        for (i = 0; i < 10; ++i) {
            queueId = new ReplicationQueueId(serverName1, peerId1);
            this.storage.setOffset(queueId, "group1-" + i, new ReplicationGroupOffset(this.getFileName("file1", i), (long)((i + 1) * 100)), (Map)ImmutableMap.of((Object)region0, (Object)((long)i * 100L), (Object)region1, (Object)((long)(i + 1) * 100L)));
        }
        List queueIds = this.storage.listAllQueueIds(serverName1);
        Assert.assertEquals((long)1L, (long)queueIds.size());
        this.assertQueueId(peerId1, serverName1, (ReplicationQueueId)queueIds.get(0));
        Map offsets = this.storage.getOffsets(new ReplicationQueueId(serverName1, peerId1));
        for (int i2 = 0; i2 < 10; ++i2) {
            ReplicationGroupOffset offset = (ReplicationGroupOffset)offsets.get("group1-" + i2);
            Assert.assertEquals((Object)this.getFileName("file1", i2), (Object)offset.getWal());
            Assert.assertEquals((long)((i2 + 1) * 100), (long)offset.getOffset());
        }
        Assert.assertEquals((long)900L, (long)this.storage.getLastSequenceId(region0, peerId1));
        Assert.assertEquals((long)1000L, (long)this.storage.getLastSequenceId(region1, peerId1));
        this.storage.setOffset(new ReplicationQueueId(serverName1, peerId1), "group1-0", new ReplicationGroupOffset(this.getFileName("file1", 0), 1100L), (Map)ImmutableMap.of((Object)region0, (Object)899L, (Object)region1, (Object)1001L));
        Assert.assertEquals((long)900L, (long)this.storage.getLastSequenceId(region0, peerId1));
        Assert.assertEquals((long)1001L, (long)this.storage.getLastSequenceId(region1, peerId1));
    }

    private void assertGroupOffset(String wal, long offset, ReplicationGroupOffset groupOffset) {
        Assert.assertEquals((Object)wal, (Object)groupOffset.getWal());
        Assert.assertEquals((long)offset, (long)groupOffset.getOffset());
    }

    @Test
    public void testClaimQueue() throws Exception {
        String peerId = "1";
        ServerName serverName1 = this.getServerName(1);
        ReplicationQueueId queueId = new ReplicationQueueId(serverName1, peerId);
        for (int i = 0; i < 10; ++i) {
            this.storage.setOffset(queueId, "group-" + i, new ReplicationGroupOffset("wal-" + i, (long)i), Collections.emptyMap());
        }
        ServerName serverName2 = this.getServerName(2);
        Map offsets2 = this.storage.claimQueue(queueId, serverName2);
        Assert.assertEquals((long)10L, (long)offsets2.size());
        for (int i = 0; i < 10; ++i) {
            this.assertGroupOffset("wal-" + i, i, (ReplicationGroupOffset)offsets2.get("group-" + i));
        }
        ReplicationQueueId claimedQueueId2 = new ReplicationQueueId(serverName2, peerId, serverName1);
        MatcherAssert.assertThat((Object)this.storage.listAllQueueIds(peerId, serverName1), (Matcher)IsEmptyCollection.empty());
        MatcherAssert.assertThat((Object)this.storage.listAllQueueIds(peerId, serverName2), (Matcher)Matchers.both((Matcher)Matchers.hasItem((Object)claimedQueueId2)).and(Matchers.hasSize((int)1)));
        offsets2 = this.storage.getOffsets(claimedQueueId2);
        Assert.assertEquals((long)10L, (long)offsets2.size());
        for (int i = 0; i < 10; ++i) {
            this.assertGroupOffset("wal-" + i, i, (ReplicationGroupOffset)offsets2.get("group-" + i));
        }
        ServerName serverName3 = this.getServerName(3);
        Map offsets3 = this.storage.claimQueue(claimedQueueId2, serverName3);
        Assert.assertEquals((long)10L, (long)offsets3.size());
        for (int i = 0; i < 10; ++i) {
            this.assertGroupOffset("wal-" + i, i, (ReplicationGroupOffset)offsets3.get("group-" + i));
        }
        ReplicationQueueId claimedQueueId3 = new ReplicationQueueId(serverName3, peerId, serverName1);
        MatcherAssert.assertThat((Object)this.storage.listAllQueueIds(peerId, serverName1), (Matcher)IsEmptyCollection.empty());
        MatcherAssert.assertThat((Object)this.storage.listAllQueueIds(peerId, serverName2), (Matcher)IsEmptyCollection.empty());
        MatcherAssert.assertThat((Object)this.storage.listAllQueueIds(peerId, serverName3), (Matcher)Matchers.both((Matcher)Matchers.hasItem((Object)claimedQueueId3)).and(Matchers.hasSize((int)1)));
        offsets3 = this.storage.getOffsets(claimedQueueId3);
        Assert.assertEquals((long)10L, (long)offsets3.size());
        for (int i = 0; i < 10; ++i) {
            this.assertGroupOffset("wal-" + i, i, (ReplicationGroupOffset)offsets3.get("group-" + i));
        }
        this.storage.removeQueue(claimedQueueId3);
        MatcherAssert.assertThat((Object)this.storage.listAllQueueIds(peerId), (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void testClaimQueueMultiThread() throws Exception {
        String peerId = "3";
        String walGroup = "group";
        ReplicationGroupOffset groupOffset = new ReplicationGroupOffset("wal", 123L);
        ServerName sourceServerName = this.getServerName(100);
        ReplicationQueueId queueId = new ReplicationQueueId(sourceServerName, peerId);
        this.storage.setOffset(queueId, walGroup, groupOffset, Collections.emptyMap());
        List serverNames = IntStream.range(0, 10).mapToObj(this::getServerName).collect(Collectors.toList());
        for (int i = 0; i < 10; ++i) {
            final ReplicationQueueId toClaim = queueId;
            ArrayList<1> threads = new ArrayList<1>();
            final ConcurrentHashMap claimed = new ConcurrentHashMap();
            final ConcurrentHashMap.KeySetView failed = ConcurrentHashMap.newKeySet();
            for (final ServerName serverName : serverNames) {
                if (serverName.equals((Object)queueId.getServerName())) continue;
                threads.add(new Thread("Claim-" + i + "-" + serverName){

                    @Override
                    public void run() {
                        try {
                            Map offsets = TestTableReplicationQueueStorage.this.storage.claimQueue(toClaim, serverName);
                            if (!offsets.isEmpty()) {
                                claimed.put(serverName, offsets);
                            }
                        }
                        catch (ReplicationException e) {
                            LOG.error("failed to claim queue", (Throwable)e);
                            failed.add(serverName);
                        }
                    }
                });
            }
            LOG.info("Claim round {}, there are {} threads to claim {}", new Object[]{i, threads.size(), toClaim});
            for (Thread thread : threads) {
                thread.start();
            }
            for (Thread thread : threads) {
                thread.join(30000L);
                Assert.assertFalse((boolean)thread.isAlive());
            }
            LOG.info("Finish claim round {}, claimed={}, failed={}", new Object[]{i, claimed, failed});
            MatcherAssert.assertThat(failed, (Matcher)IsEmptyCollection.empty());
            Assert.assertEquals((long)1L, (long)claimed.size());
            Map offsets = (Map)Iterables.getOnlyElement(claimed.values());
            Assert.assertEquals((long)1L, (long)offsets.size());
            this.assertGroupOffset("wal", 123L, (ReplicationGroupOffset)offsets.get("group"));
            queueId = new ReplicationQueueId((ServerName)Iterables.getOnlyElement(claimed.keySet()), peerId, sourceServerName);
            MatcherAssert.assertThat((Object)this.storage.listAllQueueIds(peerId), (Matcher)Matchers.both((Matcher)Matchers.hasItem((Object)queueId)).and(Matchers.hasSize((int)1)));
        }
    }

    @Test
    public void testListRemovePeerAllQueues() throws Exception {
        ServerName serverName;
        String peerId1 = "1";
        String peerId2 = "2";
        for (int i = 0; i < 100; ++i) {
            ServerName serverName2 = this.getServerName(i);
            String group = "group";
            ReplicationGroupOffset offset = new ReplicationGroupOffset("wal", (long)i);
            ReplicationQueueId queueId1 = new ReplicationQueueId(serverName2, peerId1);
            ReplicationQueueId queueId2 = new ReplicationQueueId(serverName2, peerId2);
            this.storage.setOffset(queueId1, group, offset, Collections.emptyMap());
            this.storage.setOffset(queueId2, group, offset, Collections.emptyMap());
        }
        List queueDatas = this.storage.listAllQueues();
        MatcherAssert.assertThat((Object)queueDatas, (Matcher)Matchers.hasSize((int)200));
        for (int i = 0; i < 100; ++i) {
            ReplicationQueueData peerId1Data = (ReplicationQueueData)queueDatas.get(i);
            ReplicationQueueData peerId2Data = (ReplicationQueueData)queueDatas.get(i + 100);
            serverName = this.getServerName(i);
            Assert.assertEquals((Object)new ReplicationQueueId(serverName, peerId1), (Object)peerId1Data.getId());
            Assert.assertEquals((Object)new ReplicationQueueId(serverName, peerId2), (Object)peerId2Data.getId());
            Assert.assertEquals((long)1L, (long)peerId1Data.getOffsets().size());
            Assert.assertEquals((long)1L, (long)peerId2Data.getOffsets().size());
            this.assertGroupOffset("wal", i, (ReplicationGroupOffset)peerId1Data.getOffsets().get((Object)"group"));
            this.assertGroupOffset("wal", i, (ReplicationGroupOffset)peerId2Data.getOffsets().get((Object)"group"));
        }
        List queueIds1 = this.storage.listAllQueueIds(peerId1);
        MatcherAssert.assertThat((Object)queueIds1, (Matcher)Matchers.hasSize((int)100));
        for (int i = 0; i < 100; ++i) {
            ServerName serverName3 = this.getServerName(i);
            Assert.assertEquals((Object)new ReplicationQueueId(serverName3, peerId1), queueIds1.get(i));
        }
        List queueIds2 = this.storage.listAllQueueIds(peerId2);
        MatcherAssert.assertThat((Object)queueIds2, (Matcher)Matchers.hasSize((int)100));
        for (int i = 0; i < 100; ++i) {
            serverName = this.getServerName(i);
            Assert.assertEquals((Object)new ReplicationQueueId(serverName, peerId2), queueIds2.get(i));
        }
        this.storage.removeAllQueues(peerId1);
        MatcherAssert.assertThat((Object)this.storage.listAllQueues(), (Matcher)Matchers.hasSize((int)100));
        MatcherAssert.assertThat((Object)this.storage.listAllQueueIds(peerId1), (Matcher)IsEmptyCollection.empty());
        MatcherAssert.assertThat((Object)this.storage.listAllQueueIds(peerId2), (Matcher)Matchers.hasSize((int)100));
        this.storage.removeAllQueues(peerId2);
        MatcherAssert.assertThat((Object)this.storage.listAllQueues(), (Matcher)IsEmptyCollection.empty());
        MatcherAssert.assertThat((Object)this.storage.listAllQueueIds(peerId1), (Matcher)IsEmptyCollection.empty());
        MatcherAssert.assertThat((Object)this.storage.listAllQueueIds(peerId2), (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void testRemoveAllLastPushedSeqIdsForPeer() throws Exception {
        String encodedRegionName;
        int i;
        String peerId = "1";
        String peerIdToDelete = "2";
        for (i = 0; i < 100; ++i) {
            encodedRegionName = MD5Hash.getMD5AsHex((byte[])Bytes.toBytes((int)i));
            this.storage.setLastSequenceIds(peerId, (Map)ImmutableMap.of((Object)encodedRegionName, (Object)i));
            this.storage.setLastSequenceIds(peerIdToDelete, (Map)ImmutableMap.of((Object)encodedRegionName, (Object)i));
        }
        for (i = 0; i < 100; ++i) {
            encodedRegionName = MD5Hash.getMD5AsHex((byte[])Bytes.toBytes((int)i));
            Assert.assertEquals((long)i, (long)this.storage.getLastSequenceId(encodedRegionName, peerId));
            Assert.assertEquals((long)i, (long)this.storage.getLastSequenceId(encodedRegionName, peerIdToDelete));
        }
        this.storage.removeLastSequenceIds(peerIdToDelete);
        for (i = 0; i < 100; ++i) {
            encodedRegionName = MD5Hash.getMD5AsHex((byte[])Bytes.toBytes((int)i));
            Assert.assertEquals((long)i, (long)this.storage.getLastSequenceId(encodedRegionName, peerId));
            Assert.assertEquals((long)-1L, (long)this.storage.getLastSequenceId(encodedRegionName, peerIdToDelete));
        }
    }

    @Test
    public void testHfileRefsReplicationQueues() throws ReplicationException, KeeperException {
        String peerId1 = "1";
        ArrayList<Pair> files1 = new ArrayList<Pair>(3);
        files1.add(new Pair(null, (Object)new Path("file_1")));
        files1.add(new Pair(null, (Object)new Path("file_2")));
        files1.add(new Pair(null, (Object)new Path("file_3")));
        Assert.assertTrue((boolean)this.storage.getReplicableHFiles(peerId1).isEmpty());
        Assert.assertEquals((long)0L, (long)this.storage.getAllPeersFromHFileRefsQueue().size());
        this.storage.addHFileRefs(peerId1, files1);
        Assert.assertEquals((long)1L, (long)this.storage.getAllPeersFromHFileRefsQueue().size());
        Assert.assertEquals((long)3L, (long)this.storage.getReplicableHFiles(peerId1).size());
        ArrayList<String> hfiles2 = new ArrayList<String>(files1.size());
        for (Pair p : files1) {
            hfiles2.add(((Path)p.getSecond()).getName());
        }
        String removedString = (String)hfiles2.remove(0);
        this.storage.removeHFileRefs(peerId1, hfiles2);
        Assert.assertEquals((long)1L, (long)this.storage.getReplicableHFiles(peerId1).size());
        hfiles2 = new ArrayList(1);
        hfiles2.add(removedString);
        this.storage.removeHFileRefs(peerId1, hfiles2);
        Assert.assertEquals((long)0L, (long)this.storage.getReplicableHFiles(peerId1).size());
    }

    @Test
    public void testRemovePeerForHFileRefs() throws ReplicationException, KeeperException {
        String peerId1 = "1";
        String peerId2 = "2";
        ArrayList<Pair> files1 = new ArrayList<Pair>(3);
        files1.add(new Pair(null, (Object)new Path("file_1")));
        files1.add(new Pair(null, (Object)new Path("file_2")));
        files1.add(new Pair(null, (Object)new Path("file_3")));
        this.storage.addHFileRefs(peerId1, files1);
        this.storage.addHFileRefs(peerId2, files1);
        Assert.assertEquals((long)2L, (long)this.storage.getAllPeersFromHFileRefsQueue().size());
        Assert.assertEquals((long)3L, (long)this.storage.getReplicableHFiles(peerId1).size());
        Assert.assertEquals((long)3L, (long)this.storage.getReplicableHFiles(peerId2).size());
        this.storage.removePeerFromHFileRefs(peerId1);
        Assert.assertEquals((long)1L, (long)this.storage.getAllPeersFromHFileRefsQueue().size());
        Assert.assertTrue((boolean)this.storage.getReplicableHFiles(peerId1).isEmpty());
        Assert.assertEquals((long)3L, (long)this.storage.getReplicableHFiles(peerId2).size());
        this.storage.removePeerFromHFileRefs(peerId2);
        Assert.assertEquals((long)0L, (long)this.storage.getAllPeersFromHFileRefsQueue().size());
        Assert.assertTrue((boolean)this.storage.getReplicableHFiles(peerId2).isEmpty());
    }

    private void addLastSequenceIdsAndHFileRefs(String peerId1, String peerId2) throws ReplicationException {
        for (int i = 0; i < 100; ++i) {
            String encodedRegionName = MD5Hash.getMD5AsHex((byte[])Bytes.toBytes((int)i));
            this.storage.setLastSequenceIds(peerId1, (Map)ImmutableMap.of((Object)encodedRegionName, (Object)i));
        }
        ArrayList<Pair> files1 = new ArrayList<Pair>(3);
        files1.add(new Pair(null, (Object)new Path("file_1")));
        files1.add(new Pair(null, (Object)new Path("file_2")));
        files1.add(new Pair(null, (Object)new Path("file_3")));
        this.storage.addHFileRefs(peerId2, files1);
    }

    @Test
    public void testRemoveLastSequenceIdsAndHFileRefsBefore() throws ReplicationException, InterruptedException {
        String encodedRegionName;
        int i;
        String peerId1 = "1";
        String peerId2 = "2";
        this.addLastSequenceIdsAndHFileRefs(peerId1, peerId2);
        for (int i2 = 0; i2 < 100; ++i2) {
            String encodedRegionName2 = MD5Hash.getMD5AsHex((byte[])Bytes.toBytes((int)i2));
            Assert.assertEquals((long)i2, (long)this.storage.getLastSequenceId(encodedRegionName2, peerId1));
        }
        Assert.assertEquals((long)1L, (long)this.storage.getAllPeersFromHFileRefsQueue().size());
        Assert.assertEquals((long)3L, (long)this.storage.getReplicableHFiles(peerId2).size());
        long ts = EnvironmentEdgeManager.currentTime();
        this.storage.removeLastSequenceIdsAndHFileRefsBefore(ts);
        for (i = 0; i < 100; ++i) {
            encodedRegionName = MD5Hash.getMD5AsHex((byte[])Bytes.toBytes((int)i));
            Assert.assertEquals((long)-1L, (long)this.storage.getLastSequenceId(encodedRegionName, peerId1));
        }
        Assert.assertEquals((long)0L, (long)this.storage.getAllPeersFromHFileRefsQueue().size());
        Thread.sleep(100L);
        this.addLastSequenceIdsAndHFileRefs(peerId1, peerId2);
        this.storage.removeLastSequenceIdsAndHFileRefsBefore(ts);
        for (i = 0; i < 100; ++i) {
            encodedRegionName = MD5Hash.getMD5AsHex((byte[])Bytes.toBytes((int)i));
            Assert.assertEquals((long)i, (long)this.storage.getLastSequenceId(encodedRegionName, peerId1));
        }
        Assert.assertEquals((long)1L, (long)this.storage.getAllPeersFromHFileRefsQueue().size());
        Assert.assertEquals((long)3L, (long)this.storage.getReplicableHFiles(peerId2).size());
    }
}

