/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.SyncReplicationTestBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestSyncReplicationStandbyKillRS
extends SyncReplicationTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestSyncReplicationStandbyKillRS.class);
    private final long SLEEP_TIME = 1000L;
    private final int COUNT = 1000;
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSyncReplicationStandbyKillRS.class);

    @Test
    public void testStandbyKillRegionServer() throws Exception {
        MasterFileSystem mfs = UTIL2.getHBaseCluster().getMaster().getMasterFileSystem();
        Path remoteWALDir = this.getRemoteWALDir(mfs, PEER_ID);
        Assert.assertFalse((boolean)mfs.getWALFileSystem().exists(remoteWALDir));
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.STANDBY);
        Assert.assertTrue((boolean)mfs.getWALFileSystem().exists(remoteWALDir));
        UTIL1.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.ACTIVE);
        UTIL1.getAdmin().disableReplicationPeer(PEER_ID);
        this.write(UTIL1, 0, 1000);
        UTIL1.shutdownMiniCluster();
        JVMClusterUtil.MasterThread activeMaster = UTIL2.getMiniHBaseCluster().getMasterThread();
        String threadName = "RegionServer-Restarter";
        Thread t = new Thread(() -> {
            try {
                List<JVMClusterUtil.RegionServerThread> regionServers = UTIL2.getMiniHBaseCluster().getLiveRegionServerThreads();
                LOG.debug("Going to stop {} RSes: [{}]", (Object)regionServers.size(), (Object)regionServers.stream().map(rst -> rst.getRegionServer().getServerName().getServerName()).collect(Collectors.joining(", ")));
                for (JVMClusterUtil.RegionServerThread rst2 : regionServers) {
                    ServerName serverName = rst2.getRegionServer().getServerName();
                    LOG.debug("Going to RS stop [{}]", (Object)serverName);
                    rst2.getRegionServer().stop("Stop RS for test");
                    this.waitForRSShutdownToStartAndFinish(activeMaster, serverName);
                    LOG.debug("Going to start a new RS");
                    JVMClusterUtil.RegionServerThread restarted = UTIL2.getMiniHBaseCluster().startRegionServer();
                    LOG.debug("Waiting RS [{}] to online", (Object)restarted.getRegionServer().getServerName());
                    restarted.waitForServerOnline();
                    LOG.debug("Waiting the old RS {} thread to quit", (Object)rst2.getName());
                    rst2.join();
                    LOG.debug("Done stop RS [{}] and restart [{}]", (Object)serverName, (Object)restarted.getRegionServer().getServerName());
                }
                LOG.debug("All RSes restarted");
            }
            catch (Exception e) {
                LOG.error("Failed to kill RS", (Throwable)e);
            }
        }, threadName);
        t.start();
        LOG.debug("Going to transit peer {} to {} state", (Object)PEER_ID, (Object)SyncReplicationState.DOWNGRADE_ACTIVE);
        try {
            UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.DOWNGRADE_ACTIVE);
        }
        catch (Exception e) {
            LOG.error("Failed to transit standby cluster to " + SyncReplicationState.DOWNGRADE_ACTIVE, (Throwable)e);
        }
        LOG.debug("Waiting for the restarter thread {} to quit", (Object)threadName);
        t.join();
        while (UTIL2.getAdmin().getReplicationPeerSyncReplicationState(PEER_ID) != SyncReplicationState.DOWNGRADE_ACTIVE) {
            LOG.debug("Waiting for peer {} to be in {} state", (Object)PEER_ID, (Object)SyncReplicationState.DOWNGRADE_ACTIVE);
            Thread.sleep(1000L);
        }
        LOG.debug("Going to verify the result, {} records expected", (Object)1000);
        this.verify(UTIL2, 0, 1000);
        LOG.debug("Verification successfully done");
    }

    private void waitForRSShutdownToStartAndFinish(JVMClusterUtil.MasterThread activeMaster, ServerName serverName) throws InterruptedException, IOException {
        ServerManager sm = activeMaster.getMaster().getServerManager();
        while (!sm.getDeadServers().isDeadServer(serverName)) {
            LOG.debug("Waiting for {} to be listed as dead in master", (Object)serverName);
            Thread.sleep(1000L);
        }
        LOG.debug("Server {} marked as dead, waiting for it to finish dead processing", (Object)serverName);
        while (sm.areDeadServersInProgress()) {
            LOG.debug("Server {} still being processed, waiting", (Object)serverName);
            Thread.sleep(1000L);
        }
        LOG.debug("Server {} done with server shutdown processing", (Object)serverName);
    }
}

