/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.replication.ReplicationGroupOffset;
import org.apache.hadoop.hbase.replication.ReplicationOffsetUtil;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, SmallTests.class})
public class TestReplicationOffsetUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationOffsetUtil.class);

    @Test
    public void test() {
        Assert.assertTrue((boolean)ReplicationOffsetUtil.shouldReplicate(null, (String)"whatever"));
        Assert.assertTrue((boolean)ReplicationOffsetUtil.shouldReplicate((ReplicationGroupOffset)ReplicationGroupOffset.BEGIN, (String)"whatever"));
        ServerName sn = ServerName.valueOf((String)"host", (int)16010, (long)EnvironmentEdgeManager.currentTime());
        ReplicationGroupOffset offset = new ReplicationGroupOffset(sn + ".12345", 100L);
        Assert.assertTrue((boolean)ReplicationOffsetUtil.shouldReplicate((ReplicationGroupOffset)offset, (String)(sn + ".12346")));
        Assert.assertFalse((boolean)ReplicationOffsetUtil.shouldReplicate((ReplicationGroupOffset)offset, (String)(sn + ".12344")));
        Assert.assertTrue((boolean)ReplicationOffsetUtil.shouldReplicate((ReplicationGroupOffset)offset, (String)(sn + ".12345")));
        Assert.assertFalse((boolean)ReplicationOffsetUtil.shouldReplicate((ReplicationGroupOffset)new ReplicationGroupOffset(sn + ".12345", -1L), (String)(sn + ".12345")));
    }
}

