/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ReplicationTests.class})
public class TestNonHBaseReplicationEndpoint {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNonHBaseReplicationEndpoint.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static Admin ADMIN;
    private static final TableName tableName;
    private static final byte[] famName;
    private static final AtomicBoolean REPLICATED;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        UTIL.startMiniCluster();
        ADMIN = UTIL.getAdmin();
    }

    @AfterClass
    public static void teardownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() {
        REPLICATED.set(false);
    }

    @Test
    public void test() throws IOException {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])famName).setScope(1).build()).build();
        Table table = UTIL.createTable(td, HBaseTestingUtil.KEYS_FOR_HBA_CREATE_TABLE);
        ReplicationPeerConfig peerConfig = ReplicationPeerConfig.newBuilder().setReplicationEndpointImpl(NonHBaseReplicationEndpoint.class.getName()).setReplicateAllUserTables(false).setTableCFsMap((Map)ImmutableMap.of((Object)tableName, new ArrayList())).build();
        ADMIN.addReplicationPeer("1", peerConfig);
        TestNonHBaseReplicationEndpoint.loadData(table);
        UTIL.waitFor(10000L, () -> REPLICATED.get());
    }

    protected static void loadData(Table table) throws IOException {
        for (int i = 0; i < 100; ++i) {
            Put put = new Put(Bytes.toBytes((String)Integer.toString(i)));
            put.addColumn(famName, famName, Bytes.toBytes((int)i));
            table.put(put);
        }
    }

    static {
        tableName = TableName.valueOf((String)"test");
        famName = Bytes.toBytes((String)"f");
        REPLICATED = new AtomicBoolean();
    }

    public static class NonHBaseReplicationEndpoint
    implements ReplicationEndpoint {
        private boolean running = false;

        public void init(ReplicationEndpoint.Context context) throws IOException {
        }

        public boolean canReplicateToSameCluster() {
            return false;
        }

        public UUID getPeerUUID() {
            return UUID.randomUUID();
        }

        public WALEntryFilter getWALEntryfilter() {
            return null;
        }

        public boolean replicate(ReplicationEndpoint.ReplicateContext replicateContext) {
            REPLICATED.set(true);
            return true;
        }

        public boolean isRunning() {
            return this.running;
        }

        public boolean isStarting() {
            return false;
        }

        public void start() {
            this.running = true;
        }

        public void awaitRunning() {
            long interval = 100L;
            while (!this.running) {
                Threads.sleep((long)interval);
            }
        }

        public void awaitRunning(long timeout, TimeUnit unit) {
            long start = System.currentTimeMillis();
            long end = start + unit.toMillis(timeout);
            long interval = 100L;
            while (!this.running && System.currentTimeMillis() < end) {
                Threads.sleep((long)interval);
            }
        }

        public void stop() {
            this.running = false;
        }

        public void awaitTerminated() {
            long interval = 100L;
            while (this.running) {
                Threads.sleep((long)interval);
            }
        }

        public void awaitTerminated(long timeout, TimeUnit unit) {
            long start = System.currentTimeMillis();
            long end = start + unit.toMillis(timeout);
            long interval = 100L;
            while (this.running && System.currentTimeMillis() < end) {
                Threads.sleep((long)interval);
            }
        }

        public Throwable failureCause() {
            return null;
        }

        public void peerConfigUpdated(ReplicationPeerConfig rpc) {
        }
    }
}

