/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HBaseZKTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncClusterConnection;
import org.apache.hadoop.hbase.client.AsyncRegionServerAdmin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.protobuf.ReplicationProtobufUtil;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public class SyncReplicationTestBase {
    protected static final HBaseZKTestingUtil ZK_UTIL = new HBaseZKTestingUtil();
    protected static final HBaseTestingUtil UTIL1 = new HBaseTestingUtil();
    protected static final HBaseTestingUtil UTIL2 = new HBaseTestingUtil();
    protected static TableName TABLE_NAME = TableName.valueOf((String)"SyncRep");
    protected static byte[] CF = Bytes.toBytes((String)"cf");
    protected static byte[] CQ = Bytes.toBytes((String)"cq");
    protected static String PEER_ID = "1";
    protected static Path REMOTE_WAL_DIR1;
    protected static Path REMOTE_WAL_DIR2;

    protected static void initTestingUtility(HBaseTestingUtil util, String zkParent) {
        util.setZkCluster(ZK_UTIL.getZkCluster());
        Configuration conf = util.getConfiguration();
        conf.set("zookeeper.znode.parent", zkParent);
        conf.setInt("replication.source.size.capacity", 102400);
        conf.setLong("replication.source.sleepforretries", 100L);
        conf.setInt("hbase.regionserver.maxlogs", 10);
        conf.setLong("hbase.master.logcleaner.ttl", 10L);
        conf.setInt("zookeeper.recovery.retry", 1);
        conf.setInt("zookeeper.recovery.retry.intervalmill", 10);
        conf.setLong("hbase.server.thread.wakefrequency", 100L);
        conf.setInt("replication.stats.thread.period.seconds", 5);
        conf.setBoolean("hbase.tests.use.shortcircuit.reads", false);
        conf.setLong("replication.sleep.before.failover", 2000L);
        conf.setInt("replication.source.maxretriesmultiplier", 10);
        conf.setFloat("replication.source.ratio", 1.0f);
        conf.setBoolean("replication.source.eof.autorecovery", true);
    }

    @BeforeClass
    public static void setUp() throws Exception {
        ZK_UTIL.startMiniZKCluster();
        SyncReplicationTestBase.initTestingUtility(UTIL1, "/cluster1");
        SyncReplicationTestBase.initTestingUtility(UTIL2, "/cluster2");
        StartTestingClusterOption option = StartTestingClusterOption.builder().numMasters(2).numRegionServers(3).numDataNodes(3).build();
        UTIL1.startMiniCluster(option);
        UTIL2.startMiniCluster(option);
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])CF).setScope(1).build()).build();
        UTIL1.getAdmin().createTable(td);
        UTIL2.getAdmin().createTable(td);
        FileSystem fs1 = UTIL1.getTestFileSystem();
        FileSystem fs2 = UTIL2.getTestFileSystem();
        REMOTE_WAL_DIR1 = new Path(UTIL1.getMiniHBaseCluster().getMaster().getMasterFileSystem().getWALRootDir(), "remoteWALs").makeQualified(fs1.getUri(), fs1.getWorkingDirectory());
        REMOTE_WAL_DIR2 = new Path(UTIL2.getMiniHBaseCluster().getMaster().getMasterFileSystem().getWALRootDir(), "remoteWALs").makeQualified(fs2.getUri(), fs2.getWorkingDirectory());
        UTIL1.getAdmin().addReplicationPeer(PEER_ID, ReplicationPeerConfig.newBuilder().setClusterKey(UTIL2.getClusterKey()).setReplicateAllUserTables(false).setTableCFsMap((Map)ImmutableMap.of((Object)TABLE_NAME, new ArrayList())).setRemoteWALDir(REMOTE_WAL_DIR2.toUri().toString()).build());
        UTIL2.getAdmin().addReplicationPeer(PEER_ID, ReplicationPeerConfig.newBuilder().setClusterKey(UTIL1.getClusterKey()).setReplicateAllUserTables(false).setTableCFsMap((Map)ImmutableMap.of((Object)TABLE_NAME, new ArrayList())).setRemoteWALDir(REMOTE_WAL_DIR1.toUri().toString()).build());
    }

    private static void shutdown(HBaseTestingUtil util) throws Exception {
        if (util.getHBaseCluster() == null) {
            return;
        }
        Admin admin = util.getAdmin();
        if (!admin.listReplicationPeers(Pattern.compile(PEER_ID)).isEmpty()) {
            if (admin.getReplicationPeerSyncReplicationState(PEER_ID) != SyncReplicationState.DOWNGRADE_ACTIVE) {
                admin.transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.DOWNGRADE_ACTIVE);
            }
            admin.removeReplicationPeer(PEER_ID);
        }
        util.shutdownMiniCluster();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        SyncReplicationTestBase.shutdown(UTIL1);
        SyncReplicationTestBase.shutdown(UTIL2);
        ZK_UTIL.shutdownMiniZKCluster();
    }

    protected final void write(HBaseTestingUtil util, int start, int end) throws IOException {
        try (Table table = util.getConnection().getTable(TABLE_NAME);){
            for (int i = start; i < end; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
    }

    protected final void verify(HBaseTestingUtil util, int start, int end) throws IOException {
        try (Table table = util.getConnection().getTable(TABLE_NAME);){
            for (int i = start; i < end; ++i) {
                Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])table.get(new Get(Bytes.toBytes((int)i))).getValue(CF, CQ)));
            }
        }
    }

    protected final void verifyThroughRegion(HBaseTestingUtil util, int start, int end) throws IOException {
        HRegion region = util.getMiniHBaseCluster().getRegions(TABLE_NAME).get(0);
        for (int i = start; i < end; ++i) {
            Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])region.get(new Get(Bytes.toBytes((int)i))).getValue(CF, CQ)));
        }
    }

    protected final void verifyNotReplicatedThroughRegion(HBaseTestingUtil util, int start, int end) throws IOException {
        HRegion region = util.getMiniHBaseCluster().getRegions(TABLE_NAME).get(0);
        for (int i = start; i < end; ++i) {
            Assert.assertTrue((boolean)region.get(new Get(Bytes.toBytes((int)i))).isEmpty());
        }
    }

    protected final void waitUntilReplicationDone(HBaseTestingUtil util, final int end) throws Exception {
        final HRegion region = util.getMiniHBaseCluster().getRegions(TABLE_NAME).get(0);
        util.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                return !region.get(new Get(Bytes.toBytes((int)(end - 1)))).isEmpty();
            }

            public String explainFailure() throws Exception {
                return "Replication has not been catched up yet";
            }
        });
    }

    protected final void writeAndVerifyReplication(HBaseTestingUtil util1, HBaseTestingUtil util2, int start, int end) throws Exception {
        this.write(util1, start, end);
        this.waitUntilReplicationDone(util2, end);
        this.verifyThroughRegion(util2, start, end);
    }

    protected final Path getRemoteWALDir(MasterFileSystem mfs, String peerId) {
        Path remoteWALDir = new Path(mfs.getWALRootDir(), "remoteWALs");
        return this.getRemoteWALDir(remoteWALDir, peerId);
    }

    protected final Path getRemoteWALDir(Path remoteWALDir, String peerId) {
        return new Path(remoteWALDir, peerId);
    }

    protected final Path getReplayRemoteWALs(Path remoteWALDir, String peerId) {
        return new Path(remoteWALDir, peerId + "-replay");
    }

    protected final void verifyRemovedPeer(String peerId, Path remoteWALDir, HBaseTestingUtil utility) throws Exception {
        ReplicationPeerStorage rps = ReplicationStorageFactory.getReplicationPeerStorage((FileSystem)utility.getTestFileSystem(), (ZKWatcher)utility.getZooKeeperWatcher(), (Configuration)utility.getConfiguration());
        try {
            rps.getPeerSyncReplicationState(peerId);
            Assert.fail((String)"Should throw exception when get the sync replication state of a removed peer.");
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        try {
            rps.getPeerNewSyncReplicationState(peerId);
            Assert.fail((String)"Should throw exception when get the new sync replication state of a removed peer");
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        try (FileSystem fs = utility.getTestFileSystem();){
            Assert.assertFalse((boolean)fs.exists(this.getRemoteWALDir(remoteWALDir, peerId)));
            Assert.assertFalse((boolean)fs.exists(this.getReplayRemoteWALs(remoteWALDir, peerId)));
        }
    }

    private void assertRejection(Throwable error) {
        MatcherAssert.assertThat((Object)error, (Matcher)CoreMatchers.instanceOf(DoNotRetryIOException.class));
        Assert.assertTrue((boolean)error.getMessage().contains("Reject to apply to sink cluster"));
        Assert.assertTrue((boolean)error.getMessage().contains(TABLE_NAME.toString()));
    }

    protected final void verifyReplicationRequestRejection(HBaseTestingUtil utility, boolean expectedRejection) throws Exception {
        HRegionServer regionServer = utility.getRSForFirstRegionInTable(TABLE_NAME);
        AsyncClusterConnection connection = regionServer.getAsyncClusterConnection();
        WAL.Entry[] entries = new WAL.Entry[10];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = new WAL.Entry(new WALKeyImpl(HConstants.EMPTY_BYTE_ARRAY, TABLE_NAME, 0L), new WALEdit());
        }
        if (!expectedRejection) {
            FutureUtils.get((Future)ReplicationProtobufUtil.replicateWALEntry((AsyncRegionServerAdmin)connection.getRegionServerAdmin(regionServer.getServerName()), (WAL.Entry[])entries, null, null, null, (int)60000));
        } else {
            try {
                FutureUtils.get((Future)ReplicationProtobufUtil.replicateWALEntry((AsyncRegionServerAdmin)connection.getRegionServerAdmin(regionServer.getServerName()), (WAL.Entry[])entries, null, null, null, (int)60000));
                Assert.fail((String)"Should throw IOException when sync-replication state is in A or DA");
            }
            catch (RemoteException e) {
                this.assertRejection(e.unwrapRemoteException());
            }
            catch (DoNotRetryIOException e) {
                this.assertRejection(e);
            }
        }
    }

    protected final void waitUntilDeleted(HBaseTestingUtil util, final Path remoteWAL) throws Exception {
        final MasterFileSystem mfs = util.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        util.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                return !mfs.getWALFileSystem().exists(remoteWAL);
            }

            public String explainFailure() throws Exception {
                return remoteWAL + " has not been deleted yet";
            }
        });
    }
}

