/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hbase.thirdparty.com.google.common.base.Throwables;

class WriterOverAsyncWriter
implements WALProvider.Writer {
    private final WALProvider.AsyncWriter asyncWriter;

    public WriterOverAsyncWriter(WALProvider.AsyncWriter asyncWriter) {
        this.asyncWriter = asyncWriter;
    }

    public void close() throws IOException {
        this.asyncWriter.close();
    }

    public long getLength() {
        return this.asyncWriter.getLength();
    }

    public long getSyncedLength() {
        return this.asyncWriter.getSyncedLength();
    }

    public void append(WAL.Entry entry) throws IOException {
        this.asyncWriter.append(entry);
    }

    public void sync(boolean forceSync) throws IOException {
        try {
            this.asyncWriter.sync(forceSync).get();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class);
            throw new IOException(e.getCause());
        }
    }
}

