/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.util.LRUDictionary;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={RegionServerTests.class, SmallTests.class})
@RunWith(value=Parameterized.class)
public class TestWALCellCodecWithCompression {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALCellCodecWithCompression.class);
    private Compression.Algorithm compression;

    public TestWALCellCodecWithCompression(Compression.Algorithm algo) {
        this.compression = algo;
    }

    @Parameterized.Parameters
    public static List<Object[]> params() {
        return HBaseCommonTestingUtil.COMPRESSION_ALGORITHMS_PARAMETERIZED;
    }

    @Test
    public void testEncodeDecodeKVsWithTags() throws Exception {
        this.doTest(false, false);
    }

    @Test
    public void testEncodeDecodeKVsWithTagsWithTagsCompression() throws Exception {
        this.doTest(true, false);
    }

    @Test
    public void testEncodeDecodeOffKVsWithTagsWithTagsCompression() throws Exception {
        this.doTest(true, false);
    }

    @Test
    public void testValueCompressionEnabled() throws Exception {
        this.doTest(false, true);
    }

    @Test
    public void testValueCompression() throws Exception {
        byte[] row_1 = Bytes.toBytes((String)"row_1");
        byte[] value_1 = new byte[20];
        Bytes.zero((byte[])value_1);
        byte[] row_2 = Bytes.toBytes((String)"row_2");
        byte[] value_2 = new byte[8];
        Bytes.random((byte[])value_2);
        byte[] row_3 = Bytes.toBytes((String)"row_3");
        byte[] value_3 = new byte[100];
        Bytes.random((byte[])value_3);
        byte[] row_4 = Bytes.toBytes((String)"row_4");
        byte[] value_4 = new byte[128];
        TestWALCellCodecWithCompression.fillBytes(value_4, Bytes.toBytes((String)"DEADBEEF"));
        byte[] row_5 = Bytes.toBytes((String)"row_5");
        byte[] value_5 = new byte[64];
        TestWALCellCodecWithCompression.fillBytes(value_5, Bytes.toBytes((String)"CAFEBABE"));
        Configuration conf = new Configuration(false);
        WALCellCodec codec = new WALCellCodec(conf, new CompressionContext(LRUDictionary.class, false, true, true, this.compression));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Codec.Encoder encoder = codec.getEncoder((OutputStream)bos);
        encoder.write((Cell)this.createKV(row_1, value_1, 0));
        encoder.write((Cell)this.createOffheapKV(row_2, value_2, 0));
        encoder.write((Cell)this.createKV(row_3, value_3, 0));
        encoder.write((Cell)this.createOffheapKV(row_4, value_4, 0));
        encoder.write((Cell)this.createKV(row_5, value_5, 0));
        encoder.flush();
        try (ByteArrayInputStream is = new ByteArrayInputStream(bos.toByteArray());){
            Codec.Decoder decoder = codec.getDecoder((InputStream)is);
            decoder.advance();
            KeyValue kv = (KeyValue)decoder.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])row_1, (int)0, (int)row_1.length, (byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength()));
            Assert.assertTrue((boolean)Bytes.equals((byte[])value_1, (int)0, (int)value_1.length, (byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength()));
            decoder.advance();
            kv = (KeyValue)decoder.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])row_2, (int)0, (int)row_2.length, (byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength()));
            Assert.assertTrue((boolean)Bytes.equals((byte[])value_2, (int)0, (int)value_2.length, (byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength()));
            decoder.advance();
            kv = (KeyValue)decoder.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])row_3, (int)0, (int)row_3.length, (byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength()));
            Assert.assertTrue((boolean)Bytes.equals((byte[])value_3, (int)0, (int)value_3.length, (byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength()));
            decoder.advance();
            kv = (KeyValue)decoder.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])row_4, (int)0, (int)row_4.length, (byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength()));
            Assert.assertTrue((boolean)Bytes.equals((byte[])value_4, (int)0, (int)value_4.length, (byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength()));
            decoder.advance();
            kv = (KeyValue)decoder.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])row_5, (int)0, (int)row_5.length, (byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength()));
            Assert.assertTrue((boolean)Bytes.equals((byte[])value_5, (int)0, (int)value_5.length, (byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength()));
        }
    }

    static void fillBytes(byte[] buffer, byte[] fill) {
        int len;
        int offset = 0;
        for (int remaining = buffer.length; remaining > 0; remaining -= len) {
            len = remaining < fill.length ? remaining : fill.length;
            System.arraycopy(fill, 0, buffer, offset, len);
            offset += len;
        }
    }

    private void doTest(boolean compressTags, boolean offheapKV) throws Exception {
        byte[] key = Bytes.toBytes((String)"myRow");
        byte[] value = Bytes.toBytes((String)"myValue");
        Configuration conf = new Configuration(false);
        conf.setBoolean("hbase.regionserver.wal.tags.enablecompression", compressTags);
        WALCellCodec codec = new WALCellCodec(conf, new CompressionContext(LRUDictionary.class, false, compressTags));
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        Codec.Encoder encoder = codec.getEncoder((OutputStream)bos);
        if (offheapKV) {
            encoder.write((Cell)this.createOffheapKV(key, value, 1));
            encoder.write((Cell)this.createOffheapKV(key, value, 0));
            encoder.write((Cell)this.createOffheapKV(key, value, 2));
        } else {
            encoder.write((Cell)this.createKV(key, value, 1));
            encoder.write((Cell)this.createKV(key, value, 0));
            encoder.write((Cell)this.createKV(key, value, 2));
        }
        ByteArrayInputStream is = new ByteArrayInputStream(bos.toByteArray());
        Codec.Decoder decoder = codec.getDecoder((InputStream)is);
        decoder.advance();
        KeyValue kv = (KeyValue)decoder.current();
        List tags = PrivateCellUtil.getTags((Cell)kv);
        Assert.assertEquals((long)1L, (long)tags.size());
        Assert.assertEquals((Object)"tagValue1", (Object)Bytes.toString((byte[])Tag.cloneValue((Tag)((Tag)tags.get(0)))));
        decoder.advance();
        kv = (KeyValue)decoder.current();
        tags = PrivateCellUtil.getTags((Cell)kv);
        Assert.assertEquals((long)0L, (long)tags.size());
        decoder.advance();
        kv = (KeyValue)decoder.current();
        tags = PrivateCellUtil.getTags((Cell)kv);
        Assert.assertEquals((long)2L, (long)tags.size());
        Assert.assertEquals((Object)"tagValue1", (Object)Bytes.toString((byte[])Tag.cloneValue((Tag)((Tag)tags.get(0)))));
        Assert.assertEquals((Object)"tagValue2", (Object)Bytes.toString((byte[])Tag.cloneValue((Tag)((Tag)tags.get(1)))));
    }

    private KeyValue createKV(byte[] row, byte[] value, int noOfTags) {
        byte[] cf = Bytes.toBytes((String)"myCF");
        byte[] q = Bytes.toBytes((String)"myQualifier");
        ArrayList<ArrayBackedTag> tags = new ArrayList<ArrayBackedTag>(noOfTags);
        for (int i = 1; i <= noOfTags; ++i) {
            tags.add(new ArrayBackedTag((byte)i, Bytes.toBytes((String)("tagValue" + i))));
        }
        return new KeyValue(row, cf, q, Long.MAX_VALUE, value, tags);
    }

    private ByteBufferKeyValue createOffheapKV(byte[] row, byte[] value, int noOfTags) {
        byte[] cf = Bytes.toBytes((String)"myCF");
        byte[] q = Bytes.toBytes((String)"myQualifier");
        ArrayList<ArrayBackedTag> tags = new ArrayList<ArrayBackedTag>(noOfTags);
        for (int i = 1; i <= noOfTags; ++i) {
            tags.add(new ArrayBackedTag((byte)i, Bytes.toBytes((String)("tagValue" + i))));
        }
        KeyValue kv = new KeyValue(row, cf, q, Long.MAX_VALUE, value, tags);
        ByteBuffer dbb = ByteBuffer.allocateDirect(kv.getBuffer().length);
        dbb.put(kv.getBuffer());
        return new ByteBufferKeyValue(dbb, 0, kv.getBuffer().length);
    }
}

