/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.wal.CombinedAsyncWriter;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogTestHelper;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufWALStreamReader;
import org.apache.hadoop.hbase.regionserver.wal.WriterOverAsyncWriter;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.AsyncFSWALProvider;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestCombinedAsyncWriter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCombinedAsyncWriter.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static EventLoopGroup EVENT_LOOP_GROUP;
    private static Class<? extends Channel> CHANNEL_CLASS;
    private static WALFactory WALS;
    @Rule
    public final TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        EVENT_LOOP_GROUP = new NioEventLoopGroup();
        CHANNEL_CLASS = NioSocketChannel.class;
        UTIL.startMiniDFSCluster(3);
        UTIL.getTestFileSystem().mkdirs(UTIL.getDataTestDirOnTestFS());
        WALS = new WALFactory(UTIL.getConfiguration(), TestCombinedAsyncWriter.class.getSimpleName());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (WALS != null) {
            WALS.close();
        }
        EVENT_LOOP_GROUP.shutdownGracefully().syncUninterruptibly();
        UTIL.shutdownMiniDFSCluster();
    }

    @Test
    public void testWithTrailer() throws IOException {
        this.doTest(true);
    }

    @Test
    public void testWithoutTrailer() throws IOException {
        this.doTest(false);
    }

    private Path getPath(int index) throws IOException {
        String methodName = this.name.getMethodName().replaceAll("[^A-Za-z0-9_-]", "_");
        return new Path(UTIL.getDataTestDirOnTestFS(), methodName + "-" + index);
    }

    private void doTest(boolean withTrailer) throws IOException {
        int columnCount = 5;
        int recordCount = 5;
        TableName tableName = TableName.valueOf((String)"tablename");
        byte[] row = Bytes.toBytes((String)"row");
        long timestamp = EnvironmentEdgeManager.currentTime();
        Path path1 = this.getPath(1);
        Path path2 = this.getPath(2);
        FileSystem fs = UTIL.getTestFileSystem();
        Configuration conf = UTIL.getConfiguration();
        try (AsyncFSWALProvider.AsyncWriter writer1 = AsyncFSWALProvider.createAsyncWriter((Configuration)conf, (FileSystem)fs, (Path)path1, (boolean)false, (EventLoopGroup)EVENT_LOOP_GROUP.next(), CHANNEL_CLASS);
             AsyncFSWALProvider.AsyncWriter writer2 = AsyncFSWALProvider.createAsyncWriter((Configuration)conf, (FileSystem)fs, (Path)path2, (boolean)false, (EventLoopGroup)EVENT_LOOP_GROUP.next(), CHANNEL_CLASS);
             CombinedAsyncWriter writer = CombinedAsyncWriter.create((WALProvider.AsyncWriter)writer1, (WALProvider.AsyncWriter[])new WALProvider.AsyncWriter[]{writer2});){
            ProtobufLogTestHelper.doWrite(new WriterOverAsyncWriter((WALProvider.AsyncWriter)writer), withTrailer, tableName, columnCount, recordCount, row, timestamp);
            try (ProtobufWALStreamReader reader = (ProtobufWALStreamReader)WALS.createStreamReader(fs, path1);){
                ProtobufLogTestHelper.doRead(reader, withTrailer, tableName, columnCount, recordCount, row, timestamp);
            }
            reader = (ProtobufWALStreamReader)WALS.createStreamReader(fs, path2);
            var19_24 = null;
            try {
                ProtobufLogTestHelper.doRead(reader, withTrailer, tableName, columnCount, recordCount, row, timestamp);
            }
            catch (Throwable throwable) {
                var19_24 = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (var19_24 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            var19_24.addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
    }
}

