/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.util.ArrayList;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestLogRollPeriod {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTestLogRollPeriod.class);
    protected static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final long LOG_ROLL_PERIOD = 4000L;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.regionsever.info.port", -1);
        TEST_UTIL.getConfiguration().setLong("hbase.regionserver.logroll.period", 4000L);
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoEdits() throws Exception {
        TableName tableName = TableName.valueOf((String)"TestLogRollPeriodNoEdits");
        TEST_UTIL.createTable(tableName, "cf");
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            HRegionServer server = TEST_UTIL.getRSForFirstRegionInTable(tableName);
            WAL log = server.getWAL(null);
            this.checkMinLogRolls(log, 5);
        }
        finally {
            TEST_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithEdits() throws Exception {
        TableName tableName = TableName.valueOf((String)"TestLogRollPeriodWithEdits");
        String family = "cf";
        TEST_UTIL.createTable(tableName, "cf");
        try {
            HRegionServer server = TEST_UTIL.getRSForFirstRegionInTable(tableName);
            WAL log = server.getWAL(null);
            final Table table = TEST_UTIL.getConnection().getTable(tableName);
            Thread writerThread = new Thread("writer"){

                @Override
                public void run() {
                    try {
                        long row = 0L;
                        while (!1.interrupted()) {
                            Put p = new Put(Bytes.toBytes((String)String.format("row%d", row)));
                            p.addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"col"), Bytes.toBytes((long)row));
                            table.put(p);
                            ++row;
                            Thread.sleep(250L);
                        }
                    }
                    catch (Exception e) {
                        LOG.warn(e.toString(), (Throwable)e);
                    }
                }
            };
            try {
                writerThread.start();
                this.checkMinLogRolls(log, 5);
            }
            finally {
                writerThread.interrupt();
                writerThread.join();
                table.close();
            }
        }
        finally {
            TEST_UTIL.deleteTable(tableName);
        }
    }

    private void checkMinLogRolls(WAL log, int minRolls) throws Exception {
        final ArrayList paths = new ArrayList();
        log.registerWALActionsListener(new WALActionsListener(){

            public void postLogRoll(Path oldFile, Path newFile) {
                LOG.debug("postLogRoll: oldFile=" + oldFile + " newFile=" + newFile);
                paths.add(newFile);
            }
        });
        long wtime = EnvironmentEdgeManager.currentTime();
        Thread.sleep((long)(minRolls + 1) * 4000L);
        int NUM_RETRIES = 1 + 8 * (minRolls - paths.size());
        for (int retry = 0; paths.size() < minRolls && retry < NUM_RETRIES; ++retry) {
            Thread.sleep(1000L);
        }
        wtime = EnvironmentEdgeManager.currentTime() - wtime;
        LOG.info(String.format("got %d rolls after %dms (%dms each) - expected at least %d rolls", paths.size(), wtime, wtime / (long)paths.size(), minRolls));
        Assert.assertFalse((paths.size() < minRolls ? 1 : 0) != 0);
    }
}

